/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.utils;

import com.theoriginalbit.moarperipherals.MoarPeripherals;
import com.theoriginalbit.moarperipherals.common.utils.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ResourceExtractingUtils {
    private static void copyFile(File source, File destination) throws IOException {
        FileInputStream inputStream = new FileInputStream(source);
        FileOutputStream outputStream = new FileOutputStream(destination);
        FileChannel sourceChannel = inputStream.getChannel();
        FileChannel targetChannel = outputStream.getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
        inputStream.close();
        outputStream.close();
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        File[] files;
        if (!source.isDirectory()) {
            throw new IllegalArgumentException("Source (" + source.getPath() + ") must be a directory.");
        }
        if (!source.exists()) {
            throw new IllegalArgumentException("Source directory (" + source.getPath() + ") doesn't exist.");
        }
        if (destination.mkdirs() && (files = source.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ResourceExtractingUtils.copyDirectory(file, new File(destination, file.getName()));
                    continue;
                }
                String name = file.getName();
                if (name.endsWith(".lua")) {
                    name = name.substring(0, name.length() - 4);
                }
                ResourceExtractingUtils.copyFile(file, new File(destination, name));
            }
        }
    }

    public static void copy(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            ResourceExtractingUtils.copyDirectory(source, destination);
        } else {
            ResourceExtractingUtils.copyFile(source, destination);
        }
    }

    public static void extractZipToLocation(File zipFile, String sourceFolder, String destFolder) {
        try {
            ZipEntry zipEntry;
            sourceFolder = sourceFolder.substring(1) + "/";
            File destFile = new File(MoarPeripherals.proxy.getBase(), destFolder);
            String destinationName = destFile.getAbsolutePath();
            byte[] buf = new byte[1024];
            ZipInputStream inputStream = new ZipInputStream(new FileInputStream(zipFile));
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                int n;
                String zipEntryName = zipEntry.getName();
                if (!zipEntryName.startsWith(sourceFolder)) continue;
                String entryName = destinationName + zipEntryName.substring(Math.min(zipEntryName.length(), sourceFolder.length() - 1));
                entryName = entryName.replace('/', File.separatorChar);
                entryName = entryName.replace('\\', File.separatorChar);
                File newFile = new File(entryName);
                if (zipEntry.isDirectory()) {
                    if (newFile.mkdirs()) continue;
                    break;
                }
                if (entryName.endsWith(".lua")) {
                    entryName = entryName.substring(0, entryName.length() - 4);
                }
                FileOutputStream fileoutputstream = new FileOutputStream(entryName);
                while ((n = inputStream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                inputStream.closeEntry();
            }
            inputStream.close();
        }
        catch (Exception e) {
            LogUtils.warn("Error while extracting Lua files. Peripheral may not auto-mount Lua files! Exception follows.", new Object[0]);
            e.printStackTrace();
        }
    }
}

