/*
 * Decompiled with CFR 0.152.
 */
package com.theoriginalbit.moarperipherals.common.utils;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class WorldUtils {
    public static <T> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<T> te) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && te.isAssignableFrom(tile.getClass())) {
            return (T)tile;
        }
        return null;
    }

    public static ChunkCoordinates moveCoords(ChunkCoordinates coordinates, int dir) {
        return new ChunkCoordinates(coordinates.field_71574_a + Facing.field_71586_b[dir], coordinates.field_71572_b + Facing.field_71587_c[dir], coordinates.field_71573_c + Facing.field_71585_d[dir]);
    }

    public static boolean isBlockInWorld(World world, ChunkCoordinates coordinates) {
        return coordinates.field_71572_b >= 0 && coordinates.field_71572_b < world.func_72800_K();
    }

    public static boolean isLiquidBlock(World world, ChunkCoordinates coordinates) {
        Block block;
        if (WorldUtils.isBlockInWorld(world, coordinates) && (block = world.func_147439_a(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c)) != null) {
            return block.func_149688_o().func_76224_d();
        }
        return false;
    }

    public static Entity rayTraceEntities(World world, Vec3 vecStart, Vec3 vecDir, double distance) {
        Vec3 vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        MovingObjectPosition result = world.func_72933_a(vecStart.func_72441_c(0.0, 0.0, 0.0), vecEnd.func_72441_c(0.0, 0.0, 0.0));
        if (result != null && result.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            distance = vecStart.func_72438_d(result.field_72307_f);
            vecEnd = vecStart.func_72441_c(vecDir.field_72450_a * distance, vecDir.field_72448_b * distance, vecDir.field_72449_c * distance);
        }
        float xStretch = Math.abs(vecDir.field_72450_a) > 0.25 ? 0.0f : 1.0f;
        float yStretch = Math.abs(vecDir.field_72448_b) > 0.25 ? 0.0f : 1.0f;
        float zStretch = Math.abs(vecDir.field_72449_c) > 0.25 ? 0.0f : 1.0f;
        AxisAlignedBB bigBox = AxisAlignedBB.func_72330_a((double)(Math.min(vecStart.field_72450_a, vecEnd.field_72450_a) - (double)(0.375f * xStretch)), (double)(Math.min(vecStart.field_72448_b, vecEnd.field_72448_b) - (double)(0.375f * yStretch)), (double)(Math.min(vecStart.field_72449_c, vecEnd.field_72449_c) - (double)(0.375f * zStretch)), (double)(Math.max(vecStart.field_72450_a, vecEnd.field_72450_a) + (double)(0.375f * xStretch)), (double)(Math.max(vecStart.field_72448_b, vecEnd.field_72448_b) + (double)(0.375f * yStretch)), (double)(Math.max(vecStart.field_72449_c, vecEnd.field_72449_c) + (double)(0.375f * zStretch)));
        Entity closest = null;
        double closestDist = 99.0;
        List list = world.func_72839_b(null, bigBox);
        for (Object aList : list) {
            Entity entity = (Entity)aList;
            if (!entity.func_70067_L()) continue;
            AxisAlignedBB littleBox = entity.field_70121_D;
            if (littleBox.func_72318_a(vecStart)) {
                closest = entity;
                closestDist = 0.0;
                continue;
            }
            MovingObjectPosition littleBoxResult = littleBox.func_72327_a(vecStart, vecEnd);
            if (littleBoxResult != null) {
                double dist = vecStart.func_72438_d(littleBoxResult.field_72307_f);
                if (closest != null && !(dist <= closestDist)) continue;
                closest = entity;
                closestDist = dist;
                continue;
            }
            if (!littleBox.func_72326_a(bigBox) || closest != null) continue;
            closest = entity;
            closestDist = distance;
        }
        if (closest != null && closestDist <= distance) {
            return closest;
        }
        return null;
    }

    public static boolean isClient(World world) {
        return world.field_72995_K;
    }

    public static boolean isServer(World world) {
        return !world.field_72995_K;
    }
}

