/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;

public class PixelBuffers {
    private static int buffersType;

    public static int glGenBuffers() {
        switch (buffersType) {
            case 0: {
                return GL15.glGenBuffers();
            }
            case 1: {
                return ARBVertexBufferObject.glGenBuffersARB();
            }
        }
        return 0;
    }

    public static void glBindBuffer(int target, int buffer) {
        switch (buffersType) {
            case 0: {
                GL15.glBindBuffer((int)target, (int)buffer);
                break;
            }
            case 1: {
                ARBVertexBufferObject.glBindBufferARB((int)target, (int)buffer);
            }
        }
    }

    public static void glBufferData(int target, long size, int usage) {
        switch (buffersType) {
            case 0: {
                GL15.glBufferData((int)target, (long)size, (int)usage);
                break;
            }
            case 1: {
                ARBVertexBufferObject.glBufferDataARB((int)target, (long)size, (int)usage);
            }
        }
    }

    public static ByteBuffer glMapBuffer(int target, int access, long length, ByteBuffer old_buffer) {
        switch (buffersType) {
            case 0: {
                return GL15.glMapBuffer((int)target, (int)access, (long)length, (ByteBuffer)old_buffer);
            }
            case 1: {
                return ARBVertexBufferObject.glMapBufferARB((int)target, (int)access, (long)length, (ByteBuffer)old_buffer);
            }
        }
        return null;
    }

    public static boolean glUnmapBuffer(int target) {
        switch (buffersType) {
            case 0: {
                return GL15.glUnmapBuffer((int)target);
            }
            case 1: {
                return ARBVertexBufferObject.glUnmapBufferARB((int)target);
            }
        }
        return false;
    }

    public static void glDeleteBuffers(int buffer) {
        switch (buffersType) {
            case 0: {
                GL15.glDeleteBuffers((int)buffer);
                break;
            }
            case 1: {
                ARBVertexBufferObject.glDeleteBuffersARB((int)buffer);
            }
        }
    }

    public static void glDeleteBuffers(IntBuffer buffers) {
        switch (buffersType) {
            case 0: {
                GL15.glDeleteBuffers((IntBuffer)buffers);
                break;
            }
            case 1: {
                ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buffers);
            }
        }
    }

    static {
        if (GLContext.getCapabilities().OpenGL15) {
            buffersType = 0;
        } else if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            buffersType = 1;
        } else {
            throw new RuntimeException("Xaero's Minimap requires Buffer Object support!");
        }
        if (!(GLContext.getCapabilities().OpenGL21 || GLContext.getCapabilities().GL_EXT_pixel_buffer_object || GLContext.getCapabilities().GL_ARB_pixel_buffer_object)) {
            throw new RuntimeException("Xaero's Minimap requires Pixel Buffer Object support!");
        }
    }
}

