/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.WaypointEditForm;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.CustomTextFieldFontRendererWrapper;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends GuiScreen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private static final Function<WaypointEditForm, String> NAME_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getName();
        }
    };
    private static final Function<WaypointEditForm, String> X_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getxText();
        }
    };
    private static final Function<WaypointEditForm, String> Y_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getyText();
        }
    };
    private static final Function<WaypointEditForm, String> Z_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getzText();
        }
    };
    private static final Function<WaypointEditForm, String> YAW_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getYawText();
        }
    };
    private static final Function<WaypointEditForm, String> INITIAL_VALUE = new Function<WaypointEditForm, String>(){

        @Override
        public String apply(WaypointEditForm w) {
            return w.getInitial();
        }
    };
    private static final Function<WaypointEditForm, Boolean> DISABLED_VALUE = new Function<WaypointEditForm, Boolean>(){

        @Override
        public Boolean apply(WaypointEditForm w) {
            return w.isDisabled();
        }
    };
    private static final Function<WaypointEditForm, Boolean> GLOBAL_VALUE = new Function<WaypointEditForm, Boolean>(){

        @Override
        public Boolean apply(WaypointEditForm w) {
            return w.isGlobal();
        }
    };
    private static final Function<WaypointEditForm, Integer> COLOR_VALUE = new Function<WaypointEditForm, Integer>(){

        @Override
        public Integer apply(WaypointEditForm w) {
            return w.getColor();
        }
    };
    private GuiButton leftButton;
    private GuiButton rightButton;
    private GuiButton modeSwitchButton;
    private GuiTextField nameTextField;
    private GuiTextField xTextField;
    private GuiTextField yTextField;
    private GuiTextField zTextField;
    private GuiTextField yawTextField;
    private GuiTextField initialTextField;
    private WaypointEditForm mutualForm;
    private ArrayList<WaypointEditForm> editForms;
    private int selectedWaypointIndex;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private ArrayList<Waypoint> waypointsEdited;
    private boolean dropped;
    private MySuperTinyButton disableButton;
    private MySuperTinyButton globalButton;
    private NumericFieldValidator fieldValidator;
    private boolean adding;
    private boolean prefilled;
    private boolean startPrefilled;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private GuiButton defaultYawButton;
    private GuiButton defaultDisabledButton;
    private GuiButton defaultGlobalButton;
    private boolean censorCoordsIfNeeded;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private CustomTextFieldFontRendererWrapper censoredTextFormatter;

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, waypointsManager, par1GuiScreen, point == null ? new ArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, point == null || point.getActualColor() == -1);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, GuiScreen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        this.parentGuiScreen = par1GuiScreen;
        this.waypointsEdited = waypointsEdited;
        this.modMain = modMain;
        this.waypointsManager = waypointsManager;
        this.fromSet = defaultWorld.getCurrent();
        this.defaultWorld = defaultWorld;
        this.frozenAutoContainerID = waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = waypointsManager.getAutoWorldID();
        this.containers = new GuiWaypointContainers(modMain, waypointsManager, defaultParentContainer, this.frozenAutoContainerID);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(waypointsManager.getWorldContainer(defaultParentContainer), waypointsManager, defaultWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.sets = new GuiWaypointSets(false, defaultWorld);
        this.dropDowns = new ArrayList();
        this.prefilled = !waypointsEdited.isEmpty();
        this.startPrefilled = this.prefilled;
        this.createForms();
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.adding = adding;
        this.namePlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "\u00a78- x";
        this.yPlaceholder = "\u00a78- y";
        this.zPlaceholder = "\u00a78- z";
        this.yawPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
        this.censorCoordsIfNeeded = true;
        this.censoredTextFormatter = new CustomTextFieldFontRendererWrapper(Minecraft.func_71410_x()){

            @Override
            public String censor(String p_195610_0_) {
                if (!GuiAddWaypoint.this.censorCoordsIfNeeded) {
                    return p_195610_0_;
                }
                int formatIndex = p_195610_0_.indexOf("\u00a7".charAt(0));
                if (formatIndex == -1) {
                    return p_195610_0_.replaceAll("[^_]", "#");
                }
                return p_195610_0_.substring(0, formatIndex).replaceAll(".", "#") + p_195610_0_.substring(formatIndex);
            }
        };
    }

    private void fillFormWaypoint(WaypointEditForm form, Waypoint w) {
        form.name = w.getLocalizedName();
        form.xText = w.getX() + "";
        form.yText = w.getY() + "";
        form.zText = w.getZ() + "";
        form.yawText = w.isRotation() ? w.getYaw() + "" : "";
        form.initial = w.getSymbol() + "";
        form.disabled = w.isDisabled();
        form.color = 1 + (w.getActualColor() == -1 ? (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) : w.getActualColor());
        form.global = w.isGlobal();
    }

    private int getAutomaticX(double dimDiv) {
        return OptimizedMath.myFloor((double)OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70165_t) * dimDiv);
    }

    private int getAutomaticY() {
        return OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70163_u);
    }

    private int getAutomaticZ(double dimDiv) {
        return OptimizedMath.myFloor((double)OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70161_v) * dimDiv);
    }

    private void fillFormAutomatic(WaypointEditForm form) {
        form.xText = "";
        form.yText = "";
        form.zText = "";
        form.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) + 1;
    }

    private void createForms() {
        this.editForms = new ArrayList();
        this.mutualForm = new WaypointEditForm();
        for (int i = 0; i < this.waypointsEdited.size(); ++i) {
            Waypoint w = this.waypointsEdited.get(i);
            WaypointEditForm form = new WaypointEditForm();
            this.fillFormWaypoint(form, w);
            this.editForms.add(form);
        }
        if (!this.startPrefilled) {
            WaypointEditForm createdForm = new WaypointEditForm();
            this.fillFormAutomatic(createdForm);
            this.editForms.add(createdForm);
        }
        this.updateMutual();
    }

    private void resetCurrentForm() {
        if (this.selectedWaypointIndex >= this.waypointsEdited.size()) {
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormAutomatic(freshForm);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        } else {
            Waypoint w = this.waypointsEdited.get(this.selectedWaypointIndex);
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormWaypoint(freshForm, w);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        }
    }

    private void updateMutual() {
        String nameTextMutual = "";
        String initialMutual = "";
        String yawMutual = "";
        String xTextMutual = "";
        String yTextMutual = "";
        String zTextMutual = "";
        boolean waypointDisabledMutual = false;
        boolean waypointGlobalMutual = false;
        int colorMutual = 0;
        colorMutual = this.differentValues(COLOR_VALUE) ? 0 : this.editForms.get((int)0).color;
        xTextMutual = "";
        yTextMutual = "";
        zTextMutual = "";
        WaypointEditForm firstForm = this.editForms.get(0);
        this.mutualForm.keepName = this.differentValues(NAME_VALUE);
        this.mutualForm.keepXText = this.editForms.size() > 1 && firstForm.xText.isEmpty() || this.differentValues(X_VALUE);
        this.mutualForm.keepYText = this.editForms.size() > 1 && firstForm.yText.isEmpty() || this.differentValues(Y_VALUE);
        this.mutualForm.keepZText = this.editForms.size() > 1 && firstForm.zText.isEmpty() || this.differentValues(Z_VALUE);
        this.mutualForm.defaultKeepYawText = this.mutualForm.keepYawText = this.differentValues(YAW_VALUE);
        this.mutualForm.keepInitial = this.differentValues(INITIAL_VALUE);
        this.mutualForm.defaultKeepDisabled = this.mutualForm.keepDisabled = this.differentValues(DISABLED_VALUE);
        this.mutualForm.defaultKeepGlobal = this.mutualForm.keepGlobal = this.differentValues(GLOBAL_VALUE);
        if (!this.mutualForm.keepName) {
            nameTextMutual = firstForm.name;
        }
        if (!this.mutualForm.keepXText) {
            xTextMutual = firstForm.xText;
        }
        if (!this.mutualForm.keepYText) {
            yTextMutual = firstForm.yText;
        }
        if (!this.mutualForm.keepZText) {
            zTextMutual = firstForm.zText;
        }
        if (!this.mutualForm.keepYawText) {
            yawMutual = firstForm.yawText;
        }
        if (!this.mutualForm.keepInitial) {
            initialMutual = firstForm.initial;
        }
        if (!this.mutualForm.keepDisabled) {
            waypointDisabledMutual = firstForm.disabled;
        }
        if (!this.mutualForm.keepGlobal) {
            waypointGlobalMutual = firstForm.global;
        }
        this.mutualForm.name = nameTextMutual;
        this.mutualForm.xText = xTextMutual;
        this.mutualForm.yText = yTextMutual;
        this.mutualForm.zText = zTextMutual;
        this.mutualForm.yawText = yawMutual;
        this.mutualForm.initial = initialMutual;
        this.mutualForm.disabled = waypointDisabledMutual;
        this.mutualForm.global = waypointGlobalMutual;
        this.mutualForm.color = colorMutual;
    }

    private void confirmMutual() {
        for (int i = 0; i < this.editForms.size(); ++i) {
            WaypointEditForm individualForm = this.editForms.get(i);
            if (!this.mutualForm.keepName) {
                individualForm.name = this.mutualForm.name;
            }
            if (!this.mutualForm.keepXText) {
                individualForm.xText = this.mutualForm.xText;
            }
            if (!this.mutualForm.keepYText) {
                individualForm.yText = this.mutualForm.yText;
            }
            if (!this.mutualForm.keepZText) {
                individualForm.zText = this.mutualForm.zText;
            }
            if (!this.mutualForm.keepYawText) {
                individualForm.yawText = this.mutualForm.yawText;
            }
            if (!this.mutualForm.keepInitial) {
                individualForm.initial = this.mutualForm.initial;
            }
            if (!this.mutualForm.keepDisabled) {
                individualForm.disabled = this.mutualForm.disabled;
            }
            if (!this.mutualForm.keepGlobal) {
                individualForm.global = this.mutualForm.global;
            }
            if (this.mutualForm.color == 0) continue;
            individualForm.color = this.mutualForm.color;
        }
    }

    private <T> boolean differentValues(Function<WaypointEditForm, T> s) {
        if (this.editForms.size() == 1) {
            return false;
        }
        WaypointEditForm testWaypoint = this.editForms.get(0);
        for (int i = 1; i < this.editForms.size(); ++i) {
            WaypointEditForm w = this.editForms.get(i);
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.getCurrent().color == 0;
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void func_73866_w_() {
        String string = this.screenTitle = this.adding ? I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (this.editForms.size() > 1) {
            this.screenTitle = this.screenTitle + (this.editForms.size() > 1 ? " (" + (this.modMain.getSettings().waypointsMutualEdit ? "" : this.selectedWaypointIndex + 1 + "/") + this.editForms.size() + ")" : "");
        }
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.leftButton = new GuiButton(208, this.field_146294_l / 2 - 203, 104, 20, 20, "<");
        this.rightButton = new GuiButton(209, this.field_146294_l / 2 + 183, 104, 20, 20, ">");
        this.modeSwitchButton = new MyTinyButton(210, this.field_146294_l / 2 + 129, 56, null, I18n.func_135052_a((String)(this.modMain.getSettings().waypointsMutualEdit ? "gui.xaero_waypoints_edit_mode_all" : "gui.xaero_waypoints_edit_mode_individually"), (Object[])new Object[0]));
        if (this.editForms.size() > 1) {
            this.field_146292_n.add(this.leftButton);
            this.field_146292_n.add(this.rightButton);
            this.field_146292_n.add(this.modeSwitchButton);
        }
        this.field_146292_n.add(new MyTinyButton(211, this.field_146294_l / 2 - 204, 56, null, I18n.func_135052_a((String)"gui.xaero_waypoints_edit_reset", (Object[])new Object[0])));
        this.nameTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 104, 200, 20);
        this.xTextField = new GuiTextField(0, (FontRenderer)(this.modMain.getSettings().hideWaypointCoordinates ? this.censoredTextFormatter : this.field_146289_q), this.field_146294_l / 2 - 109, 134, 50, 20);
        this.yTextField = new GuiTextField(0, (FontRenderer)(this.modMain.getSettings().hideWaypointCoordinates ? this.censoredTextFormatter : this.field_146289_q), this.field_146294_l / 2 - 53, 134, 50, 20);
        this.zTextField = new GuiTextField(0, (FontRenderer)(this.modMain.getSettings().hideWaypointCoordinates ? this.censoredTextFormatter : this.field_146289_q), this.field_146294_l / 2 + 3, 134, 50, 20);
        this.yawTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 59, 134, 50, 20);
        this.initialTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 25, 164, 50, 20);
        this.nameTextField.func_146180_a(this.getCurrent().name);
        this.xTextField.func_146180_a(this.getCurrent().xText);
        this.yTextField.func_146180_a(this.getCurrent().yText);
        this.zTextField.func_146180_a(this.getCurrent().zText);
        this.yawTextField.func_146180_a(this.getCurrent().yawText);
        this.initialTextField.func_146180_a(this.getCurrent().initial);
        String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(205, this.field_146294_l / 2 + 31, 164, enabledisable[this.getCurrent().disabled ? 1 : 0]);
        this.field_146292_n.add(this.disableButton);
        this.globalButton = new MySuperTinyButton(213, this.field_146294_l / 2 - 81, 164, I18n.func_135052_a((String)(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"), (Object[])new Object[0]));
        this.func_189646_b(this.globalButton);
        if (this.getCurrent().defaultKeepYawText) {
            this.defaultYawButton = new GuiButton(206, this.field_146294_l / 2 + 111, 134, 20, 20, "-");
            this.func_189646_b(this.defaultYawButton);
            boolean bl = this.defaultYawButton.field_146124_l = !this.getCurrent().keepYawText;
        }
        if (this.getCurrent().defaultKeepDisabled) {
            this.defaultDisabledButton = new GuiButton(207, this.field_146294_l / 2 + 81, 164, 20, 20, "-");
            this.func_189646_b(this.defaultDisabledButton);
            boolean bl = this.defaultDisabledButton.field_146124_l = !this.getCurrent().keepDisabled;
        }
        if (this.getCurrent().defaultKeepGlobal) {
            this.defaultGlobalButton = new GuiButton(214, this.field_146294_l / 2 - 101, 164, 20, 20, "-");
            this.func_189646_b(this.defaultGlobalButton);
            boolean bl = this.defaultGlobalButton.field_146124_l = !this.getCurrent().keepGlobal;
        }
        if (this.modMain.getSettings().hideWaypointCoordinates) {
            this.func_189646_b(new MySuperTinyButton(212, this.field_146294_l / 2 + 115, 134, I18n.func_135052_a((String)(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"), (Object[])new Object[0])));
        }
        this.dropDowns.clear();
        int currentColor = this.getCurrent().color;
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.field_146294_l / 2 - 60, 82, 120, currentColor == 0 ? 0 : currentColor - 1, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.field_146294_l / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.nameTextField.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    private WaypointEditForm getCurrent() {
        return this.modMain.getSettings().waypointsMutualEdit ? this.mutualForm : this.editForms.get(this.selectedWaypointIndex);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.nameTextField.func_146206_l()) {
            if (par2 == 15) {
                this.nameTextField.func_146195_b(false);
                this.xTextField.func_146195_b(true);
            }
            this.nameTextField.func_146201_a(par1, par2);
            if (!(this.getCurrent().initial.length() != 0 || this.nameTextField.func_146179_b().length() <= 0 || this.getCurrent().keepInitial && this.modMain.getSettings().waypointsMutualEdit)) {
                this.initialTextField.func_146180_a(this.nameTextField.func_146179_b().substring(0, 1));
            }
        } else if (this.xTextField.func_146206_l()) {
            if (par2 == 15) {
                this.xTextField.func_146195_b(false);
                this.yTextField.func_146195_b(true);
            }
            this.xTextField.func_146201_a(par1, par2);
        } else if (this.yTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yTextField.func_146195_b(false);
                this.zTextField.func_146195_b(true);
            }
            this.yTextField.func_146201_a(par1, par2);
        } else if (this.zTextField.func_146206_l()) {
            if (par2 == 15) {
                this.zTextField.func_146195_b(false);
                this.yawTextField.func_146195_b(true);
            }
            this.zTextField.func_146201_a(par1, par2);
        } else if (this.yawTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yawTextField.func_146195_b(false);
                this.initialTextField.func_146195_b(true);
            }
            this.yawTextField.func_146201_a(par1, par2);
            this.fieldValidator.validate(this.yawTextField);
            this.getCurrent().keepYawText = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.field_146124_l = true;
            }
        } else if (this.initialTextField.func_146206_l()) {
            if (par2 == 15) {
                this.initialTextField.func_146195_b(false);
                this.nameTextField.func_146195_b(true);
            }
            if (par2 != 57) {
                this.initialTextField.func_146201_a(par1, par2);
            }
        }
        if (par2 == 28 || par2 == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        this.checkFields();
        this.updateConfirmButton();
        super.func_73869_a(par1, par2);
    }

    private boolean canConfirm() {
        WaypointEditForm current = this.getCurrent();
        return !(!current.keepName && current.name.length() <= 0 || !current.keepInitial && current.initial.length() <= 0);
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.modeSwitchButton.field_146124_l = this.canConfirm();
        this.leftButton.field_146124_l = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex > 0;
        this.rightButton.field_146124_l = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex < this.editForms.size() - 1;
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        WaypointEditForm current = this.getCurrent();
        current.name = this.nameTextField.func_146179_b();
        current.xText = this.xTextField.func_146179_b();
        current.yText = this.yTextField.func_146179_b();
        current.zText = this.zTextField.func_146179_b();
        current.yawText = this.yawTextField.func_146179_b();
        current.initial = this.initialTextField.func_146179_b();
        current.initial = current.initial.toUpperCase();
        if (current.initial.length() > 2) {
            current.initial = current.initial.substring(0, 2);
            this.initialTextField.func_146180_a(current.initial);
        }
        if (current.yawText.length() > 4) {
            current.yawText = current.yawText.substring(0, 4);
            this.yawTextField.func_146180_a(current.yawText);
        }
        if (this.prefilled && this.editForms.size() > 1 && this.modMain.getSettings().waypointsMutualEdit) {
            current.keepName = current.name.isEmpty();
            current.keepXText = current.xText.isEmpty();
            current.keepYText = current.yText.isEmpty();
            current.keepZText = current.zText.isEmpty();
            current.keepInitial = current.initial.isEmpty();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        super.func_73864_a(par1, par2, par3);
        this.nameTextField.func_146192_a(par1, par2, par3);
        this.xTextField.func_146192_a(par1, par2, par3);
        this.yTextField.func_146192_a(par1, par2, par3);
        this.zTextField.func_146192_a(par1, par2, par3);
        this.yawTextField.func_146192_a(par1, par2, par3);
        this.initialTextField.func_146192_a(par1, par2, par3);
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased(par1, par2, par3, this.field_146295_m);
        }
    }

    private void setFieldText(GuiTextField field, String text) {
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public void func_73876_c() {
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.initialTextField.func_146178_a();
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            String[] enabledisable;
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof MySmallButton) {
                try {
                    this.modMain.getSettings().setOptionValue(((MySmallButton)par1GuiButton).returnModOptions(), 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                par1GuiButton.field_146126_j = this.modMain.getSettings().getKeyBinding(ModOptions.getModOptions(par1GuiButton.field_146127_k));
            }
            if (par1GuiButton.field_146127_k == 200) {
                WaypointEditForm waypointForm;
                Waypoint w;
                int i;
                if (this.modMain.getSettings().waypointsMutualEdit) {
                    this.confirmMutual();
                }
                boolean creatingAWaypoint = this.adding && this.waypointsEdited.size() < this.editForms.size();
                double dimDiv = this.waypointsManager.getDimensionDivision(this.worlds.getCurrentKeys()[0]);
                for (i = 0; i < this.waypointsEdited.size(); ++i) {
                    w = this.waypointsEdited.get(i);
                    waypointForm = this.editForms.get(i);
                    String nameString = waypointForm.name;
                    String xString = waypointForm.xText;
                    String yString = waypointForm.yText;
                    String zString = waypointForm.zText;
                    String initialString = waypointForm.initial;
                    int colorInt = waypointForm.color;
                    if (w.getType() != 1 || !nameString.equals(I18n.func_135052_a((String)"gui.xaero_deathpoint", (Object[])new Object[0]))) {
                        w.setName(nameString);
                        if (w.getType() == 1) {
                            w.setType(0);
                        }
                    }
                    int x = xString.equals("-") || xString.isEmpty() ? this.getAutomaticX(dimDiv) : Integer.parseInt(xString);
                    int y = yString.equals("-") || yString.isEmpty() ? this.getAutomaticY() : Integer.parseInt(yString);
                    int z = zString.equals("-") || zString.isEmpty() ? this.getAutomaticZ(dimDiv) : Integer.parseInt(zString);
                    w.setX(x);
                    w.setY(y);
                    w.setZ(z);
                    w.setSymbol(initialString);
                    w.setColor(colorInt - 1);
                }
                if (creatingAWaypoint) {
                    for (i = this.waypointsEdited.size(); i < this.editForms.size(); ++i) {
                        WaypointEditForm createdForm = this.editForms.get(i);
                        String nameString = createdForm.name;
                        String xString = createdForm.xText;
                        String yString = createdForm.yText;
                        String zString = createdForm.zText;
                        String initialString = createdForm.initial;
                        int colorInt = createdForm.color;
                        int x = xString.equals("-") || xString.isEmpty() ? this.getAutomaticX(dimDiv) : Integer.parseInt(xString);
                        int y = yString.equals("-") || yString.isEmpty() ? this.getAutomaticY() : Integer.parseInt(yString);
                        int z = zString.equals("-") || zString.isEmpty() ? this.getAutomaticZ(dimDiv) : Integer.parseInt(zString);
                        Waypoint created = new Waypoint(x, y, z, nameString, initialString, colorInt - 1);
                        this.waypointsEdited.add(created);
                    }
                }
                for (i = 0; i < this.waypointsEdited.size(); ++i) {
                    w = this.waypointsEdited.get(i);
                    waypointForm = this.editForms.get(i);
                    String yawText = waypointForm.yawText;
                    boolean disableBool = waypointForm.disabled;
                    boolean yawIsUsable = yawText.length() > 0 && !yawText.equals("-");
                    w.setRotation(yawIsUsable);
                    if (yawIsUsable) {
                        w.setYaw(Integer.parseInt(yawText));
                    }
                    w.setDisabled(disableBool);
                    w.setGlobal(waypointForm.global);
                }
                WaypointWorld sourceWorld = this.defaultWorld;
                WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
                String[] destinationWorldKeys = this.worlds.getCurrentKeys();
                String destinationSetKey = this.sets.getCurrentSetKey();
                WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
                WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
                if (this.adding || sourceSet != destinationSet) {
                    if (!this.modMain.getSettings().waypointsBottom) {
                        destinationSet.getList().addAll(0, this.waypointsEdited);
                    } else {
                        destinationSet.getList().addAll(this.waypointsEdited);
                    }
                }
                if (sourceSet != destinationSet) {
                    sourceSet.getList().removeAll(this.waypointsEdited);
                }
                try {
                    this.modMain.getSettings().saveWaypoints(sourceWorld);
                    if (destinationWorld != sourceWorld) {
                        this.modMain.getSettings().saveWaypoints(destinationWorld);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 205) {
                enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
                this.getCurrent().disabled = !this.getCurrent().disabled;
                this.disableButton.field_146126_j = this.getCurrent().disabled ? enabledisable[1] : enabledisable[0];
                this.getCurrent().keepDisabled = false;
                if (this.defaultDisabledButton != null) {
                    this.defaultDisabledButton.field_146124_l = true;
                }
            }
            if (par1GuiButton.field_146127_k == 206) {
                this.getCurrent().keepYawText = true;
                this.getCurrent().yawText = "";
                this.yawTextField.func_146180_a(this.getCurrent().yawText);
                par1GuiButton.field_146124_l = false;
            }
            if (par1GuiButton.field_146127_k == 207) {
                enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
                this.getCurrent().keepDisabled = true;
                this.getCurrent().disabled = false;
                this.disableButton.field_146126_j = this.getCurrent().disabled ? enabledisable[1] : enabledisable[0];
                par1GuiButton.field_146124_l = false;
            }
            if (par1GuiButton.field_146127_k == 208) {
                --this.selectedWaypointIndex;
                if (this.selectedWaypointIndex < 0) {
                    this.selectedWaypointIndex = 0;
                }
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (par1GuiButton.field_146127_k == 209) {
                ++this.selectedWaypointIndex;
                if (this.selectedWaypointIndex >= this.editForms.size()) {
                    this.selectedWaypointIndex = this.editForms.size() - 1;
                }
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (par1GuiButton.field_146127_k == 210) {
                this.modMain.getSettings().waypointsMutualEdit = !this.modMain.getSettings().waypointsMutualEdit;
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.modMain.getSettings().waypointsMutualEdit) {
                    this.prefilled = true;
                    this.updateMutual();
                } else {
                    this.confirmMutual();
                }
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (par1GuiButton.field_146127_k == 211) {
                if (this.modMain.getSettings().waypointsMutualEdit) {
                    this.createForms();
                    this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
                } else {
                    this.resetCurrentForm();
                    this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
                }
            }
            if (par1GuiButton.field_146127_k == 212) {
                this.censorCoordsIfNeeded = !this.censorCoordsIfNeeded;
                par1GuiButton.field_146126_j = I18n.func_135052_a((String)(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"), (Object[])new Object[0]);
            }
            if (par1GuiButton.field_146127_k == 213) {
                this.getCurrent().global = !this.getCurrent().global;
                this.globalButton.field_146126_j = I18n.func_135052_a((String)(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"), (Object[])new Object[0]);
                this.getCurrent().keepGlobal = false;
                if (this.defaultGlobalButton != null) {
                    this.defaultGlobalButton.field_146124_l = true;
                }
            }
            if (par1GuiButton.field_146127_k == 214) {
                this.getCurrent().keepGlobal = true;
                this.getCurrent().global = false;
                this.globalButton.field_146126_j = I18n.func_135052_a((String)(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"), (Object[])new Object[0]);
                par1GuiButton.field_146124_l = false;
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    public List getButtons() {
        return this.field_146292_n;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        WaypointEditForm current = this.getCurrent();
        if (!this.nameTextField.func_146206_l() && current.keepName) {
            this.setFieldText(this.nameTextField, this.namePlaceholder);
            this.nameTextField.func_146190_e(0);
        }
        double dimDiv = this.waypointsManager.getDimensionDivision(this.worlds.getCurrentKeys()[0]);
        if (current.keepXText) {
            if (!this.xTextField.func_146206_l()) {
                this.setFieldText(this.xTextField, this.xPlaceholder);
            }
        } else if (current.xText.isEmpty()) {
            this.setFieldText(this.xTextField, "\u00a78" + this.getAutomaticX(dimDiv));
            this.xTextField.func_146190_e(0);
        }
        if (current.keepYText) {
            if (!this.yTextField.func_146206_l()) {
                this.setFieldText(this.yTextField, this.yPlaceholder);
            }
        } else if (current.yText.isEmpty()) {
            this.setFieldText(this.yTextField, "\u00a78" + this.getAutomaticY());
            this.yTextField.func_146190_e(0);
        }
        if (current.keepZText) {
            if (!this.zTextField.func_146206_l()) {
                this.setFieldText(this.zTextField, this.zPlaceholder);
            }
        } else if (current.zText.isEmpty()) {
            this.setFieldText(this.zTextField, "\u00a78" + this.getAutomaticZ(dimDiv));
            this.zTextField.func_146190_e(0);
        }
        if (!this.yawTextField.func_146206_l() && current.yawText.isEmpty()) {
            if (current.keepYawText) {
                this.setFieldText(this.yawTextField, this.yawPlaceholder);
            } else {
                this.setFieldText(this.yawTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            }
            this.yawTextField.func_146190_e(0);
        }
        if (!this.initialTextField.func_146206_l() && current.initial.isEmpty()) {
            if (current.keepInitial) {
                this.setFieldText(this.initialTextField, this.initialPlaceholder);
            } else {
                this.setFieldText(this.initialTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            }
            this.initialTextField.func_146190_e(0);
        }
        this.nameTextField.func_146194_f();
        this.xTextField.func_146194_f();
        this.yTextField.func_146194_f();
        this.zTextField.func_146194_f();
        this.yawTextField.func_146194_f();
        this.initialTextField.func_146194_f();
        this.setFieldText(this.nameTextField, current.name);
        this.setFieldText(this.xTextField, current.xText);
        this.setFieldText(this.yTextField, current.yText);
        this.setFieldText(this.zTextField, current.zText);
        this.setFieldText(this.yawTextField, current.yawText);
        this.setFieldText(this.initialTextField, current.initial);
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(par1, par2, this.field_146295_m);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(par1, par2, this.field_146295_m);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return;
            }
        }
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.getCurrent().color = this.colorDD.size() > ModSettings.ENCHANT_COLORS.length ? selected : selected + 1;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld);
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, this.waypointsManager.getWorld(worldKeys[0], worldKeys[1]));
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
        return true;
    }
}

