/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.OptimizedMath;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    private WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<String> underText;
    protected double zoom = 1.0;
    private BlockPos.MutableBlockPos mutableBlockPos;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
    }

    public float getEntityYaw(Entity e, float partial) {
        if (e == this.mc.field_71439_g) {
            return e.field_70177_z;
        }
        if (e instanceof EntityLivingBase) {
            return ((EntityLivingBase)e).field_70758_at + (((EntityLivingBase)e).field_70759_as - ((EntityLivingBase)e).field_70758_at) * partial;
        }
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partial;
    }

    public double getRenderAngle(Entity player, float partial) {
        if (this.modMain.getSettings().getLockNorth()) {
            return 90.0;
        }
        return this.getActualAngle(player, partial);
    }

    public double getActualAngle(Entity player, float partial) {
        double angle;
        double rotation = this.getEntityYaw(player, partial);
        if (rotation < 0.0 || rotation > 360.0) {
            rotation %= 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0 || angle > 360.0) {
            angle %= 360.0;
        }
        return angle;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, MinimapProcessor var2, int var3, int var4, float var5, float var6, int var7, boolean var8);

    public void renderMinimap(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, int scale, int size, float partial) {
        int specW;
        if (this.modMain.getSettings().getMinimapSize() != this.lastMinimapSize) {
            this.lastMinimapSize = this.modMain.getSettings().getMinimapSize();
            minimap.setToResetImage(true);
        }
        long before = System.currentTimeMillis();
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize();
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize();
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float mapScale = (float)scale / 2.0f / this.modMain.getSettings().getMinimapScale();
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187425_g((int)3317, (int)4);
        GlStateManager.func_187425_g((int)3316, (int)0);
        GlStateManager.func_187425_g((int)3315, (int)0);
        GlStateManager.func_187425_g((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == -1 && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        this.renderChunks(minimapSession, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        boolean circleShape = this.modMain.getSettings().minimapShape == 1;
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0));
        if (!circleShape) {
            this.helper.drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            this.helper.drawTexturedElipseInsideRectangle(circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.modMain.getSettings().mainEntityAs == 0 && !this.modMain.getSettings().getLockNorth()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179109_b((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GlStateManager.func_179120_a((int)775, (int)0, (int)1, (int)0);
            this.helper.drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.helper.drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            int crosshairColor = minimap.getEntityRadar().getEntityColour((EntityPlayer)this.mc.field_71439_g, this.mc.func_175606_aa(), 0.0f);
            GlStateManager.func_179131_c((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.helper.drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.helper.drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.helper.drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
        int specH = specW = mapSize / 2 + 6;
        double angle = Math.toRadians(this.getRenderAngle(this.mc.func_175606_aa(), partial));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getLockNorth() || this.modMain.getSettings().mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            double arrowX = 2 * scaledX + 18 + mapSize / 2;
            double arrowY = 2 * scaledY + 18 + mapSize / 2;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            float arrowAngle = this.modMain.getSettings().getLockNorth() ? this.getEntityYaw(this.mc.func_175606_aa(), partial) : 180.0f;
            float arrowOpacity = (float)this.modMain.getSettings().playerArrowOpacity / 100.0f;
            this.drawArrow(arrowAngle, arrowX, arrowY + 1.0, 0.0f, 0.0f, 0.0f, 0.5f * arrowOpacity);
            if (this.modMain.getSettings().arrowColour != -1) {
                float[] c = this.modMain.getSettings().arrowColours[this.modMain.getSettings().arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getPlayerTeamColour((EntityPlayer)this.mc.field_71439_g);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = this.modMain.getSettings().arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, arrowX, arrowY, r, g, b, a *= arrowOpacity);
            GL11.glPopMatrix();
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        if (!circleShape) {
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4, 0, 0, 17, 15);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapSize / 2 - 9, scaledY + 9 - 4, 0, 15, 17, 15);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + mapSize / 2 - 7, 0, 30, 17, 15);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapSize / 2 - 9, scaledY + 9 - 4 + mapSize / 2 - 7, 0, 45, 17, 15);
            int horLineLength = (mapSize / 2 - 16) / 16;
            for (int i = 0; i < horLineLength; ++i) {
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4, 0, 60, 16, 4);
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4 + mapSize / 2 + 9 - 5, 0, 64, 16, 4);
            }
            int vertLineLength = (mapSize / 2 - 14) / 5;
            for (int i = 0; i < vertLineLength; ++i) {
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 68, 4, 5);
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapSize / 2 + 9 - 5, scaledY + 9 - 4 + 15 + i * 5, 0, 73, 4, 5);
            }
        } else {
            this.helper.drawTexturedElipseInsideRectangleFrame(circleSides, 4.0f, scaledX + 9, scaledY + 9, 1, 60, mapSize / 2, 4.0f, 256.0f);
        }
        GL11.glPushMatrix();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179109_b((float)(2 * scaledX + 18 + mapSize / 2), (float)(2 * scaledY + 18 + mapSize / 2), (float)0.0f);
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.func_175606_aa(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.func_175606_aa(), partial);
        this.waypointsGuiRenderer.render(minimapSession, playerX, playerZ, specW, specH, ps, pc, partial, this.zoom, circleShape);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (this.modMain.getSettings().getShowCoords()) {
            int interfaceSize = size / 2;
            String coords = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70163_u) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
            if (this.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70163_u);
                coords = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
                this.underText.add(coords);
                this.underText.add(stringLevel);
            } else {
                this.underText.add(coords);
            }
        }
        int playerBlockX = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t);
        int playerBlockY = OptimizedMath.myFloor(this.mc.func_175606_aa().func_174813_aQ().field_72338_b);
        int playerBlockZ = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
        BlockPos.MutableBlockPos pos = this.mutableBlockPos.func_181079_c(playerBlockX, playerBlockY, playerBlockZ);
        Chunk chunk = this.mc.field_71441_e.func_175726_f((BlockPos)pos);
        if (this.modMain.getSettings().showBiome) {
            String biomeText;
            Biome biome = chunk.func_177411_a((BlockPos)pos, this.mc.field_71441_e.func_72959_q());
            String string = biomeText = biome == null ? "Unknown Biome" : biome.func_185359_l();
            if (this.mc.field_71466_p.func_78256_a(biomeText) * scale <= size) {
                this.underText.add(biomeText);
            } else {
                String[] biomeWords = biomeText.split(" ");
                StringBuilder lineBuilder = new StringBuilder();
                for (int i = 0; i < biomeWords.length; ++i) {
                    int lineWidth;
                    int wordStart = lineBuilder.length();
                    if (i > 0) {
                        lineBuilder.append(' ');
                    }
                    lineBuilder.append(biomeWords[i]);
                    if (i == 0 || (lineWidth = this.mc.field_71466_p.func_78256_a(lineBuilder.toString()) * scale) <= size) continue;
                    lineBuilder.delete(wordStart, lineBuilder.length());
                    this.underText.add(lineBuilder.toString());
                    lineBuilder.delete(0, lineBuilder.length());
                    lineBuilder.append(biomeWords[i]);
                }
                this.underText.add(lineBuilder.toString());
            }
        }
        if (this.modMain.getSettings().showLightLevel > 0) {
            boolean lightFetchable;
            int playerBlockLightLevel = 0;
            int playerSkyLightLevel = 0;
            boolean bl = lightFetchable = playerBlockY >= 0 && playerBlockY < 256;
            if (this.modMain.getSettings().showLightLevel == 1 || this.modMain.getSettings().showLightLevel == 3) {
                int n = playerBlockLightLevel = lightFetchable ? chunk.func_177413_a(EnumSkyBlock.BLOCK, (BlockPos)pos) : 0;
            }
            if (this.modMain.getSettings().showLightLevel == 2 || this.modMain.getSettings().showLightLevel == 3) {
                playerSkyLightLevel = lightFetchable ? chunk.func_177413_a(EnumSkyBlock.SKY, (BlockPos)pos) : 15;
            }
            this.underText.add(String.format("Light: %d", Math.max(playerBlockLightLevel, playerSkyLightLevel)));
        }
        if (this.modMain.getSettings().showTime != 0) {
            long totalTime = 6000L + this.mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((this.modMain.getSettings().showTime - 1) % 2 == 0) {
                if (this.modMain.getSettings().showTime < 3) {
                    this.underText.add(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    this.underText.add(String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (this.modMain.getSettings().showTime < 3) {
                    this.underText.add(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    this.underText.add(String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            this.underText.add(String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug));
            this.underText.add(String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug));
            this.underText.add(String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug));
        }
        if (this.modMain.getSettings().showAngles) {
            this.underText.add(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)this.mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)this.mc.func_175606_aa().field_70125_A))));
        }
        if (this.modMain.getSettings().lightOverlayType > 0) {
            this.underText.add(I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
        this.drawTextUnderMinimap(scaledX, scaledY, height, size, mapScale);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)(0.5f * this.modMain.getSettings().arrowScale), (float)(0.5f * this.modMain.getSettings().arrowScale), (float)1.0f);
        GL11.glTranslated((double)-13.0, (double)-6.0, (double)0.0);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.mc.field_71456_v.func_73729_b(0, 0, 49, 0, 26, 27);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTextUnderMinimap(int scaledX, int scaledY, int height, int size, float mapScale) {
        int interfaceSize = size / 2;
        int scaledHeight = (int)((float)height * mapScale);
        GlStateManager.func_179097_i();
        for (int i = 0; i < this.underText.size(); ++i) {
            String s = this.underText.get(i);
            int stringWidth = this.mc.field_71466_p.func_78256_a(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int align = this.modMain.getSettings().minimapTextAlign;
            Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)(scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth))), (float)stringY, -1);
        }
        this.underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return MathHelper.func_76131_a((float)this.mc.field_71441_e.getSunBrightnessFactor(1.0f), (float)0.0f, (float)1.0f);
    }
}

