/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ResourceLocation;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.events.ForgeEventHandler;
import xaero.common.file.SimpleBackup;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.interfaces.Interface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModOptions;
import xaero.patreon.Patreon5;

public class ModSettings {
    public static int defaultSettings;
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    private IXaeroMinimap modMain;
    public static final String[] ENCHANT_COLORS;
    public static final String[] ENCHANT_COLOR_NAMES;
    public static final int[] COLORS;
    public static final String[] MINIMAP_SIZE;
    public static int serverSettings;
    public static KeyBinding keyBindZoom;
    public static KeyBinding keyBindZoom1;
    public static KeyBinding newWaypoint;
    public static KeyBinding keyWaypoints;
    public static KeyBinding keyLargeMap;
    public static KeyBinding keyToggleMap;
    public static KeyBinding keyToggleWaypoints;
    public static KeyBinding keyToggleMapWaypoints;
    public static KeyBinding keyToggleSlimes;
    public static KeyBinding keyToggleGrid;
    public static KeyBinding keyInstantWaypoint;
    public static KeyBinding keySwitchSet;
    public static KeyBinding keyAllSets;
    public static KeyBinding keyLightOverlay;
    private boolean minimap = true;
    public static String minimapItemId;
    public static Item minimapItem;
    public int zoom = 2;
    public float[] zooms = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    public int entityAmount = 1;
    private boolean showPlayers = true;
    private boolean showMobs = true;
    private boolean showHostile = true;
    private boolean showItems = true;
    private boolean showOther = true;
    private boolean showTamed = true;
    public int caveMaps = 1;
    public int caveZoom = 1;
    private boolean showOtherTeam = true;
    private boolean showWaypoints = true;
    private boolean deathpoints = true;
    private boolean oldDeathpoints = true;
    public int chunkGrid = -1;
    public boolean slimeChunks = false;
    private static HashMap<String, Long> serverSlimeSeeds;
    private boolean showIngameWaypoints = true;
    private boolean showCoords = true;
    private boolean lockNorth = false;
    private boolean antiAliasing = true;
    private boolean displayRedstone = true;
    public boolean mapSafeMode = false;
    public int distance = 1;
    public static final String[] distanceTypes;
    private int blockColours = 0;
    public static final String[] blockColourTypes;
    private boolean lighting = true;
    public boolean compassOverWaypoints = false;
    private int mapSize = -1;
    public int playersColor = 15;
    public int mobsColor = 14;
    public int hostileColor = 14;
    public int itemsColor = 12;
    public int otherColor = 5;
    public int otherTeamColor = -1;
    public int tamedMobsColor = -1;
    public float minimapOpacity = 100.0f;
    public float waypointsScale = 1.0f;
    public float dotsScale = 1.0f;
    public float headsScale = 1.0f;
    public float dotNameScale = 1.0f;
    public static boolean settingsButton;
    public boolean showBiome = false;
    public static boolean updateNotification;
    public boolean showEntityHeight = true;
    private boolean showFlowers = true;
    public boolean keepWaypointNames = false;
    public float waypointsDistance = 0.0f;
    public float waypointsDistanceMin = 0.0f;
    public String waypointTp = "tp";
    public float arrowScale = 1.5f;
    public int arrowColour = 0;
    public String[] arrowColourNames = new String[]{"gui.xaero_red", "gui.xaero_green", "gui.xaero_blue", "gui.xaero_yellow", "gui.xaero_purple", "gui.xaero_white", "gui.xaero_black", "gui.xaero_preset_classic"};
    public float[][] arrowColours = new float[][]{{0.8f, 0.1f, 0.1f, 1.0f}, {0.09f, 0.57f, 0.0f, 1.0f}, {0.0f, 0.55f, 1.0f, 1.0f}, {1.0f, 0.93f, 0.0f, 1.0f}, {0.73f, 0.33f, 0.83f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f}, {0.4588f, 0.0f, 0.0f, 1.0f}};
    public boolean smoothDots = true;
    public static final String[] ENTITY_ICONS_OPTIONS;
    public int playerIcons = 1;
    public int mobIcons = 0;
    public int hostileIcons = 0;
    public int tamedIcons = 3;
    public int heightLimit = 20;
    private boolean worldMap = true;
    private boolean terrainDepth = true;
    private static final String[] SLOPES_MODES;
    private int terrainSlopes = 2;
    public int mainEntityAs = 0;
    public boolean blockTransparency = true;
    public int waypointOpacityIngame = 80;
    public int waypointOpacityMap = 90;
    public boolean allowWrongWorldTeleportation = false;
    public int hideWorldNames = 1;
    public boolean openSlimeSettings = true;
    public boolean alwaysShowDistance = false;
    public static final String[] ENTITY_NAMES_OPTIONS;
    public int playerNames = 0;
    public int otherTeamsNames = 3;
    public int friendlyMobNames = 0;
    public int hostileMobNames = 0;
    public int itemNames = 0;
    public int otherNames = 0;
    public int tamedMobNames = 3;
    public int showLightLevel = 0;
    private static final String[] SHOW_LIGHT_LEVEL_NAMES;
    public int renderLayerIndex = 1;
    public int showTime = 0;
    public boolean differentiateByServerAddress = true;
    private boolean biomeColorsVanillaMode = false;
    public int lookingAtAngle = 20;
    public int lookingAtAngleVertical = 180;
    public boolean centeredEnlarged = false;
    public boolean zoomedOutEnlarged = false;
    public boolean alwaysEntityNametags = false;
    public int minimapTextAlign = 0;
    public boolean showAngles;
    public boolean waypointsMutualEdit = true;
    public boolean compass = true;
    public int caveMapsDepth = 30;
    public boolean hideWaypointCoordinates = false;
    public boolean renderAllSets = false;
    public int playerArrowOpacity = 100;
    private boolean ignoreHeightmaps;
    public boolean waypointsBottom;
    private static final String[] MINIMAP_SHAPES;
    public int minimapShape;
    public int lightOverlayType;
    public int lightOverlayMaxLight = 7;
    public int lightOverlayMinLight = 0;
    public int lightOverlayColor = 13;

    public ModSettings(IXaeroMinimap modMain) {
        this.modMain = modMain;
        int n = defaultSettings = modMain.getVersionID().endsWith("fair") ? 16188159 : Integer.MAX_VALUE;
        if (serverSettings == 0) {
            serverSettings = defaultSettings;
        }
    }

    public boolean isKeyRepeat(KeyBinding kb) {
        return kb != this.modMain.getSettingsKey() && kb != keyWaypoints && kb != newWaypoint && kb != keyLargeMap && kb != keyToggleMap && kb != keyToggleWaypoints && kb != keyToggleMapWaypoints && kb != keyToggleSlimes && kb != keyToggleGrid && kb != keyInstantWaypoint && kb != keySwitchSet && kb != keyAllSets && kb != keyLightOverlay;
    }

    public boolean getMinimap() {
        return this.minimap && !this.minimapDisabled() && (minimapItem == null || Minecraft.func_71410_x().field_71439_g == null || MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public boolean getShowPlayers() {
        return this.showPlayers && !this.minimapDisplayPlayersDisabled();
    }

    public boolean getShowMobs() {
        return this.showMobs && !this.minimapDisplayMobsDisabled();
    }

    public boolean getShowHostile() {
        return this.showHostile && !this.minimapDisplayMobsDisabled();
    }

    public boolean getShowItems() {
        return this.showItems && !this.minimapDisplayItemsDisabled();
    }

    public boolean getShowOther() {
        return this.showOther && !this.minimapDisplayOtherDisabled();
    }

    public boolean getShowTamedMobs() {
        return this.showTamed && !this.minimapDisplayTamedMobsDisabled();
    }

    public boolean getCaveMaps() {
        return this.caveMaps > 0 && !this.caveMapsDisabled();
    }

    public boolean getShowOtherTeam() {
        return this.showOtherTeam && !this.showOtherTeamDisabled();
    }

    public boolean getShowWaypoints() {
        return this.showWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getDeathpoints() {
        return this.deathpoints && !this.deathpointsDisabled();
    }

    public boolean getOldDeathpoints() {
        return this.oldDeathpoints;
    }

    public void setSlimeChunksSeed(long seed, String fullWorldID) {
        serverSlimeSeeds.put(fullWorldID, seed);
    }

    public Long getSlimeChunksSeed(String fullWorldID) {
        IntegratedServer sp = Minecraft.func_71410_x().func_71401_C();
        if (sp == null) {
            return serverSlimeSeeds.get(fullWorldID);
        }
        try {
            if (sp.func_130014_f_().field_73011_w.getDimension() != 0) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        long seed = sp.func_130014_f_().func_72905_C();
        return seed;
    }

    public boolean customSlimeSeedNeeded(XaeroMinimapSession minimapSession) {
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiSlimeSeed) && Minecraft.func_71410_x().func_71401_C() == null && minimapSession != null;
    }

    public boolean getSlimeChunks(WaypointsManager waypointsManager) {
        return this.slimeChunks && (Minecraft.func_71410_x().func_71401_C() != null || this.getSlimeChunksSeed(waypointsManager.getCurrentContainerAndWorldID()) != null);
    }

    public boolean getShowIngameWaypoints() {
        return this.showIngameWaypoints && !this.showWaypointsDisabled() && (minimapItem == null || Minecraft.func_71410_x().field_71439_g == null || MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public boolean waypointsGUI(WaypointsManager waypointsManager) {
        return Minecraft.func_71410_x().field_71439_g != null && waypointsManager.getWaypoints() != null && (minimapItem == null || Minecraft.func_71410_x().field_71439_g == null || MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    public boolean getShowCoords() {
        return this.showCoords;
    }

    public boolean getLockNorth() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return this.lockNorth;
        }
        return this.lockNorth || minimapSession.getMinimapProcessor().isEnlargedMap();
    }

    public boolean getAntiAliasing() {
        return this.antiAliasing && (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO());
    }

    public boolean getDisplayRedstone() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.displayRedstone;
        }
        return this.displayRedstone;
    }

    public int getBlockColours() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapColours();
        }
        return this.blockColours;
    }

    public boolean getLighting() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapLighting();
        }
        return this.lighting;
    }

    public int getMinimapSize() {
        if (this.mapSize > -1) {
            return this.mapSize;
        }
        int height = Minecraft.func_71410_x().field_71440_d;
        int width = Minecraft.func_71410_x().field_71443_c;
        int size = (int)((float)(height <= width ? height : width) / this.getMinimapScale());
        if (size <= 480) {
            return 0;
        }
        if (size <= 720) {
            return 1;
        }
        if (size <= 1080) {
            return 2;
        }
        return 3;
    }

    public float getMinimapScale() {
        int size;
        int height = Minecraft.func_71410_x().field_71440_d;
        int width = Minecraft.func_71410_x().field_71443_c;
        int n = size = height <= width ? height : width;
        if (size > 1500) {
            return Math.round((double)size / 1000.0);
        }
        return 1.0f;
    }

    public boolean getShowFlowers() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapFlowers();
        }
        return this.showFlowers;
    }

    public boolean getSmoothDots() {
        return this.smoothDots && (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO());
    }

    public boolean getUseWorldMap() {
        return this.worldMap && (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO());
    }

    public boolean getTerrainDepth() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapTerrainDepth();
        }
        return this.terrainDepth;
    }

    public int getTerrainSlopes() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapTerrainSlopes();
        }
        return this.terrainSlopes;
    }

    public boolean getBiomeColorsVanillaMode() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapBiomeColorsVanillaMode();
        }
        return this.biomeColorsVanillaMode;
    }

    public boolean isIgnoreHeightmaps() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapIgnoreHeightmaps();
        }
        return this.ignoreHeightmaps;
    }

    public void convertWaypointFilesToFolders() throws IOException {
        Stream<Path> files = Files.list(this.modMain.getWaypointsFolder().toPath());
        Path backupFolder = this.modMain.getWaypointsFolder().toPath().resolve("backup");
        Files.createDirectories(backupFolder, new FileAttribute[0]);
        if (files != null) {
            Object[] fileArray = files.toArray();
            for (int i = 0; i < fileArray.length; ++i) {
                String fileName;
                Path filePath = (Path)fileArray[i];
                if (filePath.toFile().isDirectory() || !(fileName = filePath.getFileName().toString()).endsWith(".txt") || !fileName.contains("_")) continue;
                int lastUnderscore = fileName.lastIndexOf("_");
                if (!fileName.startsWith("Multiplayer_") && !fileName.startsWith("Realms_")) {
                    fileName = fileName.substring(0, lastUnderscore).replace("_", "%us%") + fileName.substring(lastUnderscore);
                }
                String noExtension = fileName.substring(0, fileName.lastIndexOf("."));
                Path folderPath = filePath.getParent().resolve(noExtension);
                Path fixedFilePath = folderPath.resolve("waypoints.txt");
                Path backupFilePath = backupFolder.resolve(fileName);
                Files.createDirectories(folderPath, new FileAttribute[0]);
                if (!backupFilePath.toFile().exists()) {
                    Files.copy(filePath, backupFilePath, new CopyOption[0]);
                }
                try {
                    Files.move(filePath, fixedFilePath, new CopyOption[0]);
                    continue;
                }
                catch (FileAlreadyExistsException e) {
                    if (!backupFilePath.toFile().exists()) continue;
                    Files.deleteIfExists(filePath);
                }
            }
            files.close();
        }
    }

    public void convertWaypointFoldersToSingleFolder(WaypointsManager waypointsManager) throws IOException {
        Stream<Path> folders = Files.list(this.modMain.getWaypointsFolder().toPath());
        if (folders != null) {
            Object[] folderArray = folders.toArray();
            for (int i = 0; i < folderArray.length; ++i) {
                Stream<Path> deleteCheck;
                String dimensionName;
                String lastArg;
                String folderName;
                String[] folderArgs;
                Path folderPath = (Path)folderArray[i];
                if (!folderPath.toFile().isDirectory() || (folderArgs = (folderName = folderPath.getFileName().toString()).split("_")).length <= 1 || !(lastArg = folderArgs[folderArgs.length - 1]).equals("null") && (!lastArg.startsWith("DIM") || lastArg.length() <= 3)) continue;
                int dimensionId = lastArg.equals("null") ? 0 : Integer.parseInt(lastArg.substring(3));
                try {
                    dimensionName = waypointsManager.getDimensionDirectoryName(dimensionId);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
                Path correctFolder = folderPath.getParent().resolve(folderName.substring(0, folderName.lastIndexOf("_"))).resolve(dimensionName);
                Files.createDirectories(correctFolder, new FileAttribute[0]);
                Stream<Path> files = Files.list(folderPath);
                if (files != null) {
                    Object[] filesArray = files.toArray();
                    for (int j = 0; j < filesArray.length; ++j) {
                        Path filePath = (Path)filesArray[j];
                        if (filePath.toFile().isDirectory()) continue;
                        Path correctFilePath = correctFolder.resolve(filePath.getFileName());
                        Files.move(filePath, correctFilePath, new CopyOption[0]);
                    }
                    files.close();
                }
                if ((deleteCheck = Files.list(folderPath)).count() == 0L) {
                    Files.deleteIfExists(folderPath);
                }
                deleteCheck.close();
            }
            folders.close();
        }
    }

    public static void copyTempFilesBack(Path folder) throws IOException {
        Stream<Path> tempFiles = Files.list(folder);
        if (tempFiles != null) {
            Iterator tempFilesIter = tempFiles.iterator();
            while (tempFilesIter.hasNext()) {
                Path tempFile = (Path)tempFilesIter.next();
                Path newLocation = folder.getParent().resolve(tempFile.getFileName());
                if (!Files.exists(newLocation, new LinkOption[0]) || !Files.isDirectory(newLocation, new LinkOption[0]) && Files.size(newLocation) == 0L) {
                    Files.move(tempFile, newLocation, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                SimpleBackup.moveToBackup(folder.getParent(), tempFile);
            }
            tempFiles.close();
        }
        Files.delete(folder);
    }

    public void loadAllWaypoints(WaypointsManager waypointsManager) throws IOException {
        Path waypointTempToAddFolder;
        Path waypointsFolderPath = this.modMain.getWaypointsFolder().toPath();
        if (!Files.exists(waypointsFolderPath, new LinkOption[0])) {
            Files.createDirectories(waypointsFolderPath, new FileAttribute[0]);
        }
        if (Files.exists(waypointTempToAddFolder = waypointsFolderPath.resolve("temp_to_add"), new LinkOption[0])) {
            ModSettings.copyTempFilesBack(waypointTempToAddFolder);
        }
        this.convertWaypointFilesToFolders();
        this.convertWaypointFoldersToSingleFolder(waypointsManager);
        Stream<Path> folders = Files.list(this.modMain.getWaypointsFolder().toPath());
        if (folders != null) {
            Object[] paths = folders.toArray();
            for (int i = 0; i < paths.length; ++i) {
                Stream<Path> filesOrFolders;
                String folderName;
                Path folderPath = (Path)paths[i];
                Path tempToAdd = folderPath.resolve("temp_to_add");
                if (Files.exists(tempToAdd, new LinkOption[0])) {
                    ModSettings.copyTempFilesBack(tempToAdd);
                }
                if (!folderPath.toFile().isDirectory() || (folderName = folderPath.getFileName().toString()).equals("backup") || (filesOrFolders = Files.list(folderPath)) == null) continue;
                Object[] fileArray = filesOrFolders.toArray();
                for (int j = 0; j < fileArray.length; ++j) {
                    String fileOrFolderName;
                    Path fileOrFolderPath = (Path)fileArray[j];
                    Path tempToAdd2 = fileOrFolderPath.resolve("temp_to_add");
                    if (Files.exists(tempToAdd2, new LinkOption[0])) {
                        ModSettings.copyTempFilesBack(tempToAdd2);
                    }
                    if ((fileOrFolderName = fileOrFolderPath.getFileName().toString()).startsWith("backup")) continue;
                    if (fileOrFolderPath.toFile().isDirectory()) {
                        String dimensionName = fileOrFolderName;
                        String fixedDimensionName = this.fixDimensionName(dimensionName);
                        boolean toDeleteOld = !fixedDimensionName.equals(dimensionName);
                        String containerKey = folderName + "/" + fixedDimensionName;
                        WaypointWorldContainer wc = waypointsManager.addWorldContainer(containerKey);
                        Stream<Path> files = Files.list(fileOrFolderPath);
                        if (files != null) {
                            Object[] filesArray = files.toArray();
                            if (filesArray.length == 0) {
                                waypointsManager.removeContainer(containerKey);
                            } else {
                                for (int k = 0; k < filesArray.length; ++k) {
                                    Path filePath = (Path)filesArray[k];
                                    String fileName = filePath.getFileName().toString();
                                    this.loadWaypointsFile(wc, fileName, filePath.toFile());
                                }
                            }
                            files.close();
                        }
                        if (waypointsManager.getWorldContainer(folderName).isEmpty()) {
                            waypointsManager.removeContainer(folderName);
                        }
                        if (!toDeleteOld) continue;
                        SimpleBackup.moveToBackup(fileOrFolderPath);
                        this.saveWorlds(wc.getAllWorlds());
                        continue;
                    }
                    if (!fileOrFolderName.contains("_")) continue;
                    WaypointWorldContainer wc = waypointsManager.addWorldContainer(folderName);
                    this.loadWaypointsFile(wc, fileOrFolderName, null);
                }
                filesOrFolders.close();
            }
            folders.close();
        }
    }

    private String fixDimensionName(String savedDimName) {
        if (savedDimName.equals("Overworld")) {
            return "dim%0";
        }
        if (savedDimName.equals("Nether")) {
            return "dim%-1";
        }
        if (savedDimName.equals("The End")) {
            return "dim%1";
        }
        return savedDimName;
    }

    private boolean loadWaypointsFile(WaypointWorldContainer wc, String fileName, File file) throws IOException {
        WaypointWorld w;
        String noExtension;
        if (!fileName.endsWith(".txt")) {
            return false;
        }
        String multiworldId = noExtension = fileName.substring(0, fileName.lastIndexOf("."));
        if (!noExtension.equals("waypoints")) {
            String[] multiworld = noExtension.split("_");
            multiworldId = multiworld[0];
            String multiworldName = multiworld[1].replace("%us%", "_");
            wc.addName(multiworldId, multiworldName);
        }
        if ((w = wc.addWorld(multiworldId)) != null) {
            this.loadWaypoints(w, file);
        }
        return true;
    }

    public void saveAllWaypoints(WaypointsManager waypointsManager) throws IOException {
        String[] keys = waypointsManager.getWaypointMap().keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            WaypointWorldContainer wc = waypointsManager.getWaypointMap().get(key);
            this.saveWorlds(wc.getAllWorlds());
        }
    }

    public void saveWorlds(ArrayList<WaypointWorld> worlds) throws IOException {
        for (int j = 0; j < worlds.size(); ++j) {
            WaypointWorld w = worlds.get(j);
            if (w == null) continue;
            this.saveWaypoints(w);
        }
    }

    public void saveWaypoints(WaypointWorld wpw) throws IOException {
        this.saveWaypoints(wpw, true);
    }

    public File getWaypointsFile(WaypointWorld w) throws IOException {
        File containerFolder = w.getContainer().getDirectory();
        Files.createDirectories(containerFolder.toPath(), new FileAttribute[0]);
        String filePath = containerFolder.getPath() + "/" + w.getId();
        String name = w.getContainer().getName(w.getId());
        if (name != null) {
            filePath = filePath + "_" + name.replace("_", "%us%").replace(":", "\u00a7\u00a7");
        }
        return new File(filePath + ".txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWaypoints(WaypointWorld wpw, boolean overwrite) throws IOException {
        if (wpw == null) {
            return;
        }
        File worldFile = this.getWaypointsFile(wpw);
        if (worldFile.exists() && !overwrite) {
            return;
        }
        File worldFileTemp = new File(worldFile.getParentFile(), worldFile.getName() + ".temp");
        try (OutputStreamWriter output = null;){
            String name;
            int i;
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(worldFileTemp), StandardCharsets.UTF_8);
            Object[] keys = wpw.getSets().keySet().toArray();
            if (keys.length > 1) {
                output.write("sets:" + wpw.getCurrent());
                for (i = 0; i < keys.length; ++i) {
                    name = (String)keys[i];
                    if (name.equals(wpw.getCurrent())) continue;
                    output.write(":" + (String)keys[i]);
                }
                output.write("\n");
            }
            output.write("#\n");
            output.write("#waypoint:name:initials:x:y:z:color:disabled:type:set:rotate_on_tp:tp_yaw:global\n");
            output.write("#\n");
            for (i = 0; i < keys.length; ++i) {
                name = (String)keys[i];
                WaypointSet set = wpw.getSets().get(name);
                if (set == null) continue;
                ArrayList<Waypoint> list = set.getList();
                for (int j = 0; j < list.size(); ++j) {
                    Waypoint w = list.get(j);
                    if (w.isTemporary()) continue;
                    output.write("waypoint:" + w.getNameSafe("\u00a7\u00a7") + ":" + w.getSymbolSafe("\u00a7\u00a7") + ":" + w.getX() + ":" + w.getY() + ":" + w.getZ() + ":" + w.getColor() + ":" + w.isDisabled() + ":" + w.getType() + ":" + name + ":" + w.isRotation() + ":" + w.getYaw() + ":" + w.isGlobal() + "\n");
                }
            }
            ArrayList<Map.Entry<String, Boolean>> serverWaypointsDisabled = new ArrayList<Map.Entry<String, Boolean>>(wpw.getServerWaypointsDisabled().entrySet());
            for (int i2 = 0; i2 < serverWaypointsDisabled.size(); ++i2) {
                Map.Entry<String, Boolean> e = serverWaypointsDisabled.get(i2);
                output.write("server_waypoint:" + e.getKey() + ":" + e.getValue() + "\n");
            }
        }
        Files.move(worldFileTemp.toPath(), worldFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (wpw.hasSomethingToRemoveOnSave()) {
            wpw.onSaveCleanup(worldFile);
        }
    }

    public boolean checkWaypointsLine(String[] args, WaypointWorld wpw) {
        if (args[0].equalsIgnoreCase("sets")) {
            wpw.setCurrent(args[1]);
            for (int i = 1; i < args.length; ++i) {
                if (wpw.getSets().get(args[i]) != null) continue;
                wpw.getSets().put(args[i], new WaypointSet(args[i]));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("waypoint")) {
            String setName = args[9];
            WaypointSet waypoints = wpw.getSets().get(setName);
            if (waypoints == null) {
                waypoints = new WaypointSet(setName);
                wpw.getSets().put(setName, waypoints);
            }
            Waypoint loadWaypoint = new Waypoint(Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), Waypoint.getStringFromStringSafe(args[1], "\u00a7\u00a7"), Waypoint.getStringFromStringSafe(args[2], "\u00a7\u00a7"), Integer.parseInt(args[6]));
            if (args.length > 7) {
                loadWaypoint.setDisabled(args[7].equals("true"));
            }
            if (args.length > 8) {
                loadWaypoint.setType(Integer.parseInt(args[8]));
            }
            if (args.length > 10) {
                loadWaypoint.setRotation(args[10].equals("true"));
            }
            if (args.length > 11) {
                loadWaypoint.setYaw(Integer.parseInt(args[11]));
            }
            if (args.length > 12) {
                loadWaypoint.setGlobal(args[12].equals("true"));
            }
            waypoints.getList().add(loadWaypoint);
            return true;
        }
        if (args[0].equalsIgnoreCase("server_waypoint")) {
            wpw.getServerWaypointsDisabled().put(args[1], args[2].equals("true"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWaypoints(WaypointWorld wpw, File file) throws IOException {
        if (file == null) {
            file = this.getWaypointsFile(wpw);
        }
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            while ((s = reader.readLine()) != null) {
                Object[] args = s.split(":");
                try {
                    this.checkWaypointsLine((String[])args, wpw);
                }
                catch (Exception e) {
                    System.out.println("Skipping:" + Arrays.toString(args));
                    e.printStackTrace();
                }
            }
        }
    }

    public String convertToNewConteinerID(String oldID, WaypointsManager waypointsManager) {
        String parentContainer = oldID.substring(0, oldID.lastIndexOf("_"));
        String dimension = oldID.substring(oldID.lastIndexOf("_") + 1);
        if (dimension.equals("null")) {
            dimension = "Overworld";
        } else if (dimension.startsWith("DIM")) {
            dimension = waypointsManager.getDimensionDirectoryName(Integer.parseInt(dimension.substring(3)));
        }
        return parentContainer + "/" + this.fixDimensionName(dimension);
    }

    public boolean checkWaypointsLineOLD(String[] args, WaypointsManager waypointsManager) {
        if (args[0].equalsIgnoreCase("world")) {
            if (!args[1].contains("_")) {
                args[1] = args[1] + "_null";
            }
            WaypointWorldContainer wc = waypointsManager.addWorldContainer(this.convertToNewConteinerID(args[1], waypointsManager));
            WaypointWorld map = wc.addWorld("waypoints");
            map.setCurrent(args[2]);
            for (int i = 2; i < args.length; ++i) {
                if (map.getSets().get(args[i]) != null) continue;
                map.getSets().put(args[i], new WaypointSet(args[i]));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("waypoint")) {
            WaypointSet waypoints;
            if (!args[1].contains("_")) {
                args[1] = args[1] + "_null";
            }
            WaypointWorldContainer wc = waypointsManager.addWorldContainer(this.convertToNewConteinerID(args[1], waypointsManager));
            WaypointWorld map = wc.addWorld("waypoints");
            String setName = "gui.xaero_default";
            if (args.length > 10) {
                setName = args[10];
            }
            if ((waypoints = map.getSets().get(setName)) == null) {
                waypoints = new WaypointSet(setName);
                map.getSets().put(setName, waypoints);
            }
            Waypoint loadWaypoint = new Waypoint(Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), args[2].replace("\u00a7\u00a7", ":"), args[3].replace("\u00a7\u00a7", ":"), Integer.parseInt(args[7]));
            if (args.length > 8) {
                loadWaypoint.setDisabled(args[8].equals("true"));
            }
            if (args.length > 9) {
                loadWaypoint.setType(Integer.parseInt(args[9]));
            }
            if (args.length > 11) {
                loadWaypoint.setRotation(args[11].equals("true"));
            }
            if (args.length > 12) {
                loadWaypoint.setYaw(Integer.parseInt(args[12]));
            }
            waypoints.getList().add(loadWaypoint);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOldWaypoints(File file, WaypointsManager waypointsManager) throws IOException {
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(file));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    this.checkWaypointsLineOLD(args, waypointsManager);
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
        File backupFile = new File(file.getAbsolutePath() + ".backup");
        if (backupFile.exists()) {
            System.out.println("Waypoints old file backup already exists!");
            return;
        }
        Files.move(file.toPath(), backupFile.toPath(), new CopyOption[0]);
    }

    public void writeSettings(PrintWriter writer) {
        writer.println("#CONFIG ONLY OPTIONS");
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("updateNotification:" + updateNotification);
        writer.println("settingsButton:" + settingsButton);
        if (minimapItemId != null) {
            writer.println("minimapItemId:" + minimapItemId);
        }
        writer.println("allowWrongWorldTeleportation:" + this.allowWrongWorldTeleportation);
        writer.println("differentiateByServerAddress:" + this.differentiateByServerAddress);
        writer.println("#INGAME SETTINGS (DO NOT EDIT!)");
        writer.println("minimap:" + this.minimap);
        writer.println("caveMaps:" + this.caveMaps);
        writer.println("caveZoom:" + this.caveZoom);
        writer.println("showPlayers:" + this.showPlayers);
        writer.println("showHostile:" + this.showHostile);
        writer.println("showMobs:" + this.showMobs);
        writer.println("showItems:" + this.showItems);
        writer.println("showOther:" + this.showOther);
        writer.println("showOtherTeam:" + this.showOtherTeam);
        writer.println("showTamed:" + this.showTamed);
        writer.println("showWaypoints:" + this.showWaypoints);
        writer.println("showIngameWaypoints:" + this.showIngameWaypoints);
        writer.println("displayRedstone:" + this.displayRedstone);
        writer.println("deathpoints:" + this.deathpoints);
        writer.println("oldDeathpoints:" + this.oldDeathpoints);
        writer.println("distance:" + this.distance);
        writer.println("showCoords:" + this.showCoords);
        writer.println("lockNorth:" + this.lockNorth);
        writer.println("zoom:" + this.zoom);
        writer.println("mapSize:" + this.mapSize);
        writer.println("entityAmount:" + this.entityAmount);
        writer.println("chunkGrid:" + this.chunkGrid);
        writer.println("slimeChunks:" + this.slimeChunks);
        writer.println("playersColor:" + this.playersColor);
        writer.println("mobsColor:" + this.mobsColor);
        writer.println("hostileColor:" + this.hostileColor);
        writer.println("itemsColor:" + this.itemsColor);
        writer.println("otherColor:" + this.otherColor);
        writer.println("otherTeamColor:" + this.otherTeamColor);
        writer.println("tamedMobsColor:" + this.tamedMobsColor);
        writer.println("mapSafeMode:" + this.mapSafeMode);
        writer.println("minimapOpacity:" + this.minimapOpacity);
        writer.println("waypointsScale:" + this.waypointsScale);
        writer.println("antiAliasing:" + this.antiAliasing);
        writer.println("blockColours:" + this.blockColours);
        writer.println("lighting:" + this.lighting);
        writer.println("dotsScale:" + this.dotsScale);
        writer.println("headsScale:" + this.headsScale);
        writer.println("dotNameScale:" + this.dotNameScale);
        writer.println("compassOverWaypoints:" + this.compassOverWaypoints);
        writer.println("showBiome:" + this.showBiome);
        writer.println("showEntityHeight:" + this.showEntityHeight);
        writer.println("showFlowers:" + this.showFlowers);
        writer.println("keepWaypointNames:" + this.keepWaypointNames);
        writer.println("waypointsDistance:" + this.waypointsDistance);
        writer.println("waypointsDistanceMin:" + this.waypointsDistanceMin);
        writer.println("waypointTp:" + this.waypointTp);
        writer.println("arrowScale:" + this.arrowScale);
        writer.println("arrowColour:" + this.arrowColour);
        writer.println("smoothDots:" + this.smoothDots);
        writer.println("playerIcons:" + this.playerIcons);
        writer.println("mobIcons:" + this.mobIcons);
        writer.println("hostileIcons:" + this.hostileIcons);
        writer.println("tamedIcons:" + this.tamedIcons);
        writer.println("heightLimit:" + this.heightLimit);
        writer.println("worldMap:" + this.worldMap);
        writer.println("terrainDepth:" + this.terrainDepth);
        writer.println("terrainSlopes:" + this.terrainSlopes);
        writer.println("mainEntityAs:" + this.mainEntityAs);
        writer.println("blockTransparency:" + this.blockTransparency);
        writer.println("waypointOpacityIngame:" + this.waypointOpacityIngame);
        writer.println("waypointOpacityMap:" + this.waypointOpacityMap);
        writer.println("hideWorldNames:" + this.hideWorldNames);
        writer.println("openSlimeSettings:" + this.openSlimeSettings);
        writer.println("alwaysShowDistance:" + this.alwaysShowDistance);
        writer.println("playerNames:" + this.playerNames);
        writer.println("otherTeamsNames:" + this.otherTeamsNames);
        writer.println("friendlyMobNames:" + this.friendlyMobNames);
        writer.println("hostileMobNames:" + this.hostileMobNames);
        writer.println("itemNames:" + this.itemNames);
        writer.println("otherNames:" + this.otherNames);
        writer.println("tamedMobNames:" + this.tamedMobNames);
        writer.println("showLightLevel:" + this.showLightLevel);
        writer.println("renderLayerIndex:" + this.renderLayerIndex);
        writer.println("showTime:" + this.showTime);
        writer.println("biomeColorsVanillaMode:" + this.biomeColorsVanillaMode);
        writer.println("lookingAtAngle:" + this.lookingAtAngle);
        writer.println("lookingAtAngleVertical:" + this.lookingAtAngleVertical);
        writer.println("centeredEnlarged:" + this.centeredEnlarged);
        writer.println("zoomedOutEnlarged:" + this.zoomedOutEnlarged);
        writer.println("alwaysEntityNametags:" + this.alwaysEntityNametags);
        writer.println("minimapTextAlign:" + this.minimapTextAlign);
        writer.println("showAngles:" + this.showAngles);
        writer.println("waypointsMutualEdit:" + this.waypointsMutualEdit);
        writer.println("compass:" + this.compass);
        writer.println("caveMapsDepth:" + this.caveMapsDepth);
        writer.println("hideWaypointCoordinates:" + this.hideWaypointCoordinates);
        writer.println("renderAllSets:" + this.renderAllSets);
        writer.println("playerArrowOpacity:" + this.playerArrowOpacity);
        writer.println("ignoreHeightmaps:" + this.ignoreHeightmaps);
        writer.println("waypointsBottom:" + this.waypointsBottom);
        writer.println("minimapShape:" + this.minimapShape);
        writer.println("lightOverlayType:" + this.lightOverlayType);
        writer.println("lightOverlayMaxLight:" + this.lightOverlayMaxLight);
        writer.println("lightOverlayMinLight:" + this.lightOverlayMinLight);
        writer.println("lightOverlayColor:" + this.lightOverlayColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(this.modMain.getConfigFile()));
            this.writeSettings(writer);
            Object[] keys = serverSlimeSeeds.keySet().toArray();
            Object[] values = serverSlimeSeeds.values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                writer.println("seed:" + keys[i] + ":" + values[i]);
            }
            Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
            while (iter.hasNext()) {
                Interface l = iter.next();
                writer.println("interface:" + l.getIname() + ":" + l.getActualx() + ":" + l.getActualy() + ":" + l.isCentered() + ":" + l.isFlipped() + ":" + l.isFromRight() + ":" + l.isFromBottom());
            }
            writer.println("#WAYPOINTS HAVE BEEN MOVED TO /XaeroWaypoints");
        }
    }

    public void readSetting(String[] args) {
        if (args[0].equalsIgnoreCase("ignoreUpdate")) {
            ignoreUpdate = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("updateNotification")) {
            updateNotification = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("settingsButton")) {
            settingsButton = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapItemId")) {
            minimapItemId = args[1] + ":" + args[2];
            minimapItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(args[1], args[2]));
        } else if (args[0].equalsIgnoreCase("allowWrongWorldTeleportation")) {
            this.allowWrongWorldTeleportation = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("differentiateByServerAddress")) {
            this.differentiateByServerAddress = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimap")) {
            this.minimap = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("caveMaps")) {
            this.caveMaps = args[1].equals("true") ? 1 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("caveZoom")) {
            this.caveZoom = args[1].equals("true") ? 2 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("showPlayers")) {
            this.showPlayers = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showHostile")) {
            this.showHostile = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showMobs")) {
            this.showMobs = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showItems")) {
            this.showItems = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showOther")) {
            this.showOther = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showOtherTeam")) {
            this.showOtherTeam = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showTamed")) {
            this.showTamed = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showWaypoints")) {
            this.showWaypoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("deathpoints")) {
            this.deathpoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("oldDeathpoints")) {
            this.oldDeathpoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showIngameWaypoints")) {
            this.showIngameWaypoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("displayRedstone")) {
            this.displayRedstone = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("distance")) {
            this.distance = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("showCoords")) {
            this.showCoords = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("lockNorth")) {
            this.lockNorth = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("zoom")) {
            this.zoom = Integer.parseInt(args[1]);
            if (this.zoom >= this.zooms.length) {
                this.zoom = this.zooms.length - 1;
            }
        } else if (args[0].equalsIgnoreCase("mapSize")) {
            this.mapSize = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("entityAmount")) {
            this.entityAmount = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("chunkGrid")) {
            this.chunkGrid = args[1].equals("true") ? 0 : (args[1].equals("false") ? -1 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("slimeChunks")) {
            this.slimeChunks = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("playersColor")) {
            this.playersColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("mobsColor")) {
            this.mobsColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hostileColor")) {
            this.hostileColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("itemsColor")) {
            this.itemsColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("otherColor")) {
            this.otherColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("otherTeamColor")) {
            this.otherTeamColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("tamedMobsColor")) {
            this.tamedMobsColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("mapSafeMode")) {
            this.mapSafeMode = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapOpacity")) {
            this.minimapOpacity = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("waypointsScale")) {
            this.waypointsScale = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("antiAliasing")) {
            this.antiAliasing = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("blockColours")) {
            this.blockColours = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lighting")) {
            this.lighting = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("dotsScale")) {
            this.dotsScale = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("headsScale")) {
            this.headsScale = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("dotNameScale")) {
            this.dotNameScale = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("compassOverWaypoints")) {
            this.compassOverWaypoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showBiome")) {
            this.showBiome = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showEntityHeight")) {
            this.showEntityHeight = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showFlowers")) {
            this.showFlowers = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("keepWaypointNames")) {
            this.keepWaypointNames = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointsDistance")) {
            this.waypointsDistance = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("waypointsDistanceMin")) {
            this.waypointsDistanceMin = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("waypointTp")) {
            this.waypointTp = args[1];
        } else if (args[0].equalsIgnoreCase("arrowScale")) {
            this.arrowScale = Float.valueOf(args[1]).floatValue();
        } else if (args[0].equalsIgnoreCase("arrowColour")) {
            this.arrowColour = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("seed")) {
            serverSlimeSeeds.put(args[1], Long.parseLong(args[2]));
        } else if (args[0].equalsIgnoreCase("smoothDots")) {
            this.smoothDots = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("playerHeads")) {
            this.playerIcons = args[1].equals("true") ? 2 : (args[1].equals("false") ? 1 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("playerIcons")) {
            this.playerIcons = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("mobIcons")) {
            this.mobIcons = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hostileIcons")) {
            this.hostileIcons = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("tamedIcons")) {
            this.tamedIcons = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("heightLimit")) {
            this.heightLimit = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("worldMap")) {
            this.worldMap = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("terrainDepth")) {
            this.terrainDepth = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("terrainSlopes")) {
            this.terrainSlopes = args[1].equals("true") ? 2 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("alwaysArrow") && args[1].equals("true")) {
            this.mainEntityAs = 2;
        } else if (args[0].equalsIgnoreCase("mainEntityAs")) {
            this.mainEntityAs = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("blockTransparency")) {
            this.blockTransparency = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointOpacityIngame")) {
            this.waypointOpacityIngame = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointOpacityMap")) {
            this.waypointOpacityMap = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hideWorldNames")) {
            this.hideWorldNames = args[1].equals("true") ? 2 : (args[1].equals("false") ? 1 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("openSlimeSettings")) {
            this.openSlimeSettings = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("alwaysShowDistance")) {
            this.alwaysShowDistance = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("playerNames")) {
            this.playerNames = args[1].equals("true") ? this.playerIcons : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("otherTeamsNames")) {
            this.otherTeamsNames = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("friendlyMobNames")) {
            this.friendlyMobNames = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hostileMobNames")) {
            this.hostileMobNames = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("itemNames")) {
            this.itemNames = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("otherNames")) {
            this.otherNames = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("tamedMobNames")) {
            this.tamedMobNames = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("showLightLevel")) {
            this.showLightLevel = args[1].equals("true") ? 1 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("renderLayerIndex")) {
            this.renderLayerIndex = Integer.parseInt(args[1]);
            if (this.renderLayerIndex >= ForgeEventHandler.OVERLAY_LAYERS.length) {
                this.renderLayerIndex = ForgeEventHandler.OVERLAY_LAYERS.length - 1;
            }
        } else if (args[0].equalsIgnoreCase("showTime")) {
            this.showTime = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("biomeColorsVanillaMode")) {
            this.biomeColorsVanillaMode = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("lookingAtAngle")) {
            this.lookingAtAngle = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lookingAtAngleVertical")) {
            this.lookingAtAngleVertical = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("centeredEnlarged")) {
            this.centeredEnlarged = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("zoomedOutEnlarged")) {
            this.zoomedOutEnlarged = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("entityNametags") || args[0].equalsIgnoreCase("alwaysEntityNametags")) {
            this.alwaysEntityNametags = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapTextAlign")) {
            this.minimapTextAlign = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("showAngles")) {
            this.showAngles = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointsMutualEdit")) {
            this.waypointsMutualEdit = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("compass")) {
            this.compass = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("caveMapsDepth")) {
            this.caveMapsDepth = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hideWaypointCoordinates")) {
            this.hideWaypointCoordinates = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("renderAllSets")) {
            this.renderAllSets = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("playerArrowOpacity")) {
            this.playerArrowOpacity = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("ignoreHeightmaps")) {
            this.ignoreHeightmaps = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointsBottom")) {
            this.waypointsBottom = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapShape")) {
            this.minimapShape = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayType")) {
            this.lightOverlayType = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayMaxLight")) {
            this.lightOverlayMaxLight = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayMinLight")) {
            this.lightOverlayMinLight = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayColor")) {
            this.lightOverlayColor = Integer.parseInt(args[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWaypointsFromAllSources(WaypointsManager waypointsManager) throws IOException {
        waypointsManager.getWaypointMap().clear();
        boolean saveWaypoints = false;
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(this.modMain.getConfigFile()));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    if (!this.checkWaypointsLineOLD(args, waypointsManager)) continue;
                    saveWaypoints = true;
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
        if (this.modMain.getWaypointsFile().exists()) {
            this.loadOldWaypoints(this.modMain.getWaypointsFile(), waypointsManager);
            saveWaypoints = true;
        }
        this.loadAllWaypoints(waypointsManager);
        if (saveWaypoints) {
            this.saveAllWaypoints(waypointsManager);
            this.saveSettings();
        }
        waypointsManager.onLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() throws IOException {
        new File("./config").mkdirs();
        if (!this.modMain.getConfigFile().exists()) {
            this.saveSettings();
            return;
        }
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(this.modMain.getConfigFile()));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    this.readSetting(args);
                    if (!args[0].equalsIgnoreCase("interface")) continue;
                    Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
                    while (iter.hasNext()) {
                        Interface l = iter.next();
                        if (!args[1].equals(l.getIname())) continue;
                        l.setX(Integer.parseInt(args[2]));
                        l.setY(Integer.parseInt(args[3]));
                        l.setActualx(l.getX());
                        l.setActualy(l.getY());
                        l.setCentered(args[4].equals("true"));
                        l.setFlipped(args[5].equals("true"));
                        l.setFromRight(args[6].equals("true"));
                        if (args.length > 7) {
                            l.setFromBottom(args[7].equals("true"));
                        }
                        l.backup();
                    }
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
    }

    public String getMoreKeybindings(String s, ModOptions par1EnumOptions) {
        boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
        boolean serverSetting = this.getBooleanValue(par1EnumOptions);
        s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != clientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
        return s;
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        boolean usingSafeMode;
        String s = par1EnumOptions.getEnumString() + ": ";
        boolean bl = usingSafeMode = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.modMain.getInterfaces().getMinimapInterface().usingFBO() || this.mapSafeMode;
        if (par1EnumOptions == ModOptions.DOTS_SCALE && usingSafeMode) {
            return s + "\u00a7e" + ModSettings.getTranslation(false);
        }
        if (par1EnumOptions == ModOptions.CHUNK_GRID) {
            s = s + (this.chunkGrid > -1 ? format + ENCHANT_COLORS[this.chunkGrid] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.chunkGrid], (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]));
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_COLOR) {
            s = s + format + ENCHANT_COLORS[this.lightOverlayColor] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.lightOverlayColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            s = s + this.lightOverlayMaxLight;
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            s = s + this.lightOverlayMinLight;
        } else {
            if (par1EnumOptions.getEnumFloat()) {
                return this.getEnumFloatSliderText(s, par1EnumOptions);
            }
            if (par1EnumOptions == ModOptions.EDIT) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.DOTS) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.RESET) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.WAYPOINTS_DEFAULT_TP) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.ZOOM) {
                s = s + this.zooms[this.zoom] + "x";
            } else if (par1EnumOptions == ModOptions.COLOURS) {
                s = s + (this.modMain.getSupportMods().shouldUseWorldMapChunks() ? "\u00a7e" + I18n.func_135052_a((String)"gui.xaero_world_map", (Object[])new Object[0]) : I18n.func_135052_a((String)blockColourTypes[this.getBlockColours()], (Object[])new Object[0]));
            } else if (par1EnumOptions == ModOptions.DISTANCE) {
                s = s + I18n.func_135052_a((String)distanceTypes[this.distance], (Object[])new Object[0]);
            } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS && this.customSlimeSeedNeeded(XaeroMinimapSession.getCurrentSession())) {
                s = par1EnumOptions.getEnumString();
            } else if (par1EnumOptions == ModOptions.SIZE) {
                s = s + I18n.func_135052_a((String)(this.mapSize > -1 ? MINIMAP_SIZE[this.mapSize] : "gui.xaero_auto_map_size"), (Object[])new Object[0]);
            } else if (par1EnumOptions == ModOptions.EAMOUNT) {
                s = this.entityAmount == 0 ? s + I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : s + 100 * this.entityAmount;
            } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
                if (this.caveMaps == 0) {
                    s = s + I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]);
                } else {
                    int roofSideSize = (this.caveMaps - 1) * 2 + 1;
                    s = s + roofSideSize + "x" + roofSideSize + " " + I18n.func_135052_a((String)"gui.xaero_roof", (Object[])new Object[0]);
                    if (!this.getCaveMaps()) {
                        s = s + "\u00a7e (" + ModSettings.getTranslation(false) + ")";
                    }
                }
            } else if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
                s = this.caveZoom == 0 ? s + I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : s + (1 + this.caveZoom) + "x";
            } else if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
                s = s + (this.hideWorldNames == 0 ? I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : (this.hideWorldNames == 1 ? I18n.func_135052_a((String)"gui.xaero_partial", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_full", (Object[])new Object[0])));
            } else if (par1EnumOptions == ModOptions.SHOW_TIME) {
                s = s + (this.showTime == 0 ? I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : (this.showTime < 3 ? I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + "+" : "") + ((this.showTime - 1) % 2 == 0 ? I18n.func_135052_a((String)"gui.xaero_24h", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_12h", (Object[])new Object[0])));
            } else if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
                s = s + (this.minimapTextAlign == 0 ? I18n.func_135052_a((String)"gui.xaero_center", (Object[])new Object[0]) : (this.minimapTextAlign == 1 ? I18n.func_135052_a((String)"gui.xaero_left", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_right", (Object[])new Object[0])));
            } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
                String colourName = "gui.xaero_team";
                if (this.arrowColour != -1) {
                    colourName = this.arrowColourNames[this.arrowColour];
                }
                s = s + I18n.func_135052_a((String)colourName, (Object[])new Object[0]);
            } else {
                s = (par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS || par1EnumOptions == ModOptions.REDSTONE || par1EnumOptions == ModOptions.FLOWERS || par1EnumOptions == ModOptions.BIOMES_VANILLA || par1EnumOptions == ModOptions.LIGHT || par1EnumOptions == ModOptions.TERRAIN_DEPTH || par1EnumOptions == ModOptions.TERRAIN_SLOPES) && this.modMain.getSupportMods().shouldUseWorldMapChunks() ? s + "\u00a7e" + I18n.func_135052_a((String)"gui.xaero_world_map", (Object[])new Object[0]) : (par1EnumOptions == ModOptions.TERRAIN_SLOPES ? s + I18n.func_135052_a((String)SLOPES_MODES[this.terrainSlopes], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.RENDER_LAYER ? s + this.renderLayerIndex : (par1EnumOptions == ModOptions.MAIN_ENTITY_AS ? s + (this.mainEntityAs == 0 ? I18n.func_135052_a((String)"gui.xaero_crosshair", (Object[])new Object[0]) : (this.mainEntityAs == 1 ? I18n.func_135052_a((String)"gui.xaero_dot", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_arrow", (Object[])new Object[0]))) : (par1EnumOptions == ModOptions.SHOW_LIGHT_LEVEL ? s + I18n.func_135052_a((String)SHOW_LIGHT_LEVEL_NAMES[this.showLightLevel], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MINIMAP_SHAPE ? s + I18n.func_135052_a((String)MINIMAP_SHAPES[this.minimapShape], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE ? s + I18n.func_135052_a((String)SHOW_LIGHT_LEVEL_NAMES[this.lightOverlayType < 0 ? 0 : this.lightOverlayType], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.LIGHT_OVERLAY ? par1EnumOptions.getEnumString() : this.getMoreKeybindings(s, par1EnumOptions))))))));
            }
        }
        return s;
    }

    protected String getEnumFloatSliderText(String s, ModOptions par1EnumOptions) {
        String f1 = String.format("%.1f", Float.valueOf(this.getOptionFloatValue(par1EnumOptions)));
        if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE) {
            f1 = this.waypointsDistance == 0.0f ? I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : (int)this.waypointsDistance + "m";
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            f1 = this.waypointsDistanceMin == 0.0f ? I18n.func_135052_a((String)"gui.xaero_off", (Object[])new Object[0]) : (int)this.waypointsDistanceMin + "m";
        } else if (par1EnumOptions == ModOptions.ARROW_SCALE) {
            f1 = f1 + "x";
        }
        return s + f1;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.getMinimap();
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.getCaveMaps();
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.getShowOtherTeam();
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.getShowWaypoints();
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.getDeathpoints();
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.getOldDeathpoints();
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.getShowIngameWaypoints();
        }
        if (o == ModOptions.COORDS) {
            return this.getShowCoords();
        }
        if (o == ModOptions.NORTH) {
            return this.getLockNorth();
        }
        if (o == ModOptions.PLAYERS) {
            return this.getShowPlayers();
        }
        if (o == ModOptions.HOSTILE) {
            return this.getShowHostile();
        }
        if (o == ModOptions.MOBS) {
            return this.getShowMobs();
        }
        if (o == ModOptions.ITEMS) {
            return this.getShowItems();
        }
        if (o == ModOptions.ENTITIES) {
            return this.getShowOther();
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isLoadedFBO();
        }
        if (o == ModOptions.AA) {
            return this.getAntiAliasing();
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.getSmoothDots();
        }
        if (o == ModOptions.WORLD_MAP) {
            return this.getUseWorldMap();
        }
        if (o == ModOptions.TERRAIN_DEPTH) {
            return this.getTerrainDepth();
        }
        if (o == ModOptions.IGNORE_HEIGHTMAPS) {
            return this.isIgnoreHeightmaps();
        }
        if (o == ModOptions.TAMED) {
            return this.getShowTamedMobs();
        }
        return this.getClientBooleanValue(o);
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.minimap;
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.showOtherTeam;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.showWaypoints;
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.deathpoints;
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.oldDeathpoints;
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.showIngameWaypoints;
        }
        if (o == ModOptions.REDSTONE) {
            return this.displayRedstone;
        }
        if (o == ModOptions.COORDS) {
            return this.showCoords;
        }
        if (o == ModOptions.NORTH) {
            return this.lockNorth;
        }
        if (o == ModOptions.PLAYERS) {
            return this.showPlayers;
        }
        if (o == ModOptions.HOSTILE) {
            return this.showHostile;
        }
        if (o == ModOptions.MOBS) {
            return this.showMobs;
        }
        if (o == ModOptions.ITEMS) {
            return this.showItems;
        }
        if (o == ModOptions.ENTITIES) {
            return this.showOther;
        }
        if (o == ModOptions.SLIME_CHUNKS) {
            return this.slimeChunks;
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode;
        }
        if (o == ModOptions.AA) {
            return this.antiAliasing;
        }
        if (o == ModOptions.LIGHT) {
            return this.lighting;
        }
        if (o == ModOptions.COMPASS) {
            return this.compassOverWaypoints;
        }
        if (o == ModOptions.BIOME) {
            return this.showBiome;
        }
        if (o == ModOptions.ENTITY_HEIGHT) {
            return this.showEntityHeight;
        }
        if (o == ModOptions.FLOWERS) {
            return this.showFlowers;
        }
        if (o == ModOptions.KEEP_WP_NAMES) {
            return this.keepWaypointNames;
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.smoothDots;
        }
        if (o == ModOptions.WORLD_MAP) {
            return this.worldMap;
        }
        if (o == ModOptions.CAPES) {
            return Patreon5.showCapes;
        }
        if (o == ModOptions.TERRAIN_DEPTH) {
            return this.terrainDepth;
        }
        if (o == ModOptions.BLOCK_TRANSPARENCY) {
            return this.blockTransparency;
        }
        if (o == ModOptions.OPEN_SLIME_SETTINGS) {
            return this.openSlimeSettings;
        }
        if (o == ModOptions.ALWAYS_SHOW_DISTANCE) {
            return this.alwaysShowDistance;
        }
        if (o == ModOptions.BIOMES_VANILLA) {
            return this.biomeColorsVanillaMode;
        }
        if (o == ModOptions.CENTERED_ENLARGED) {
            return this.centeredEnlarged;
        }
        if (o == ModOptions.ZOOMED_OUT_ENLARGED) {
            return this.zoomedOutEnlarged;
        }
        if (o == ModOptions.ENTITY_NAMETAGS) {
            return this.alwaysEntityNametags;
        }
        if (o == ModOptions.SHOW_ANGLES) {
            return this.showAngles;
        }
        if (o == ModOptions.COMPASS_ENABLED) {
            return this.compass;
        }
        if (o == ModOptions.HIDE_WP_COORDS) {
            return this.hideWaypointCoordinates;
        }
        if (o == ModOptions.WAYPOINTS_ALL_SETS) {
            return this.renderAllSets;
        }
        if (o == ModOptions.IGNORE_HEIGHTMAPS) {
            return this.ignoreHeightmaps;
        }
        if (o == ModOptions.WAYPOINTS_BOTTOM) {
            return this.waypointsBottom;
        }
        if (o == ModOptions.TAMED) {
            return this.showTamed;
        }
        return false;
    }

    public static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.ZOOM) {
            this.zoom = (this.zoom + 1) % this.zooms.length;
        } else if (par1EnumOptions == ModOptions.SIZE) {
            this.mapSize = this.mapSize == 3 ? -1 : (this.mapSize + 1) % 4;
        } else if (par1EnumOptions == ModOptions.EAMOUNT) {
            this.entityAmount = (this.entityAmount + 1) % 11;
        } else if (par1EnumOptions == ModOptions.MINIMAP) {
            this.minimap = !this.minimap;
        } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            this.caveMaps = (this.caveMaps + 1) % 4;
        } else if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
            this.caveZoom = (this.caveZoom + 1) % 4;
        } else if (par1EnumOptions == ModOptions.DISPLAY_OTHER_TEAM) {
            this.showOtherTeam = !this.showOtherTeam;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS) {
            this.showWaypoints = !this.showWaypoints;
        } else if (par1EnumOptions == ModOptions.DEATHPOINTS) {
            this.deathpoints = !this.deathpoints;
        } else if (par1EnumOptions == ModOptions.OLD_DEATHPOINTS) {
            this.oldDeathpoints = !this.oldDeathpoints;
        } else if (par1EnumOptions == ModOptions.INGAME_WAYPOINTS) {
            this.showIngameWaypoints = !this.showIngameWaypoints;
        } else if (par1EnumOptions == ModOptions.REDSTONE) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.displayRedstone = !this.displayRedstone;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            this.distance = (this.distance + 1) % distanceTypes.length;
        } else if (par1EnumOptions == ModOptions.COORDS) {
            this.showCoords = !this.showCoords;
        } else if (par1EnumOptions == ModOptions.NORTH) {
            this.lockNorth = !this.lockNorth;
        } else if (par1EnumOptions == ModOptions.PLAYERS) {
            this.showPlayers = !this.showPlayers;
        } else if (par1EnumOptions == ModOptions.HOSTILE) {
            this.showHostile = !this.showHostile;
        } else if (par1EnumOptions == ModOptions.MOBS) {
            this.showMobs = !this.showMobs;
        } else if (par1EnumOptions == ModOptions.ITEMS) {
            this.showItems = !this.showItems;
        } else if (par1EnumOptions == ModOptions.ENTITIES) {
            this.showOther = !this.showOther;
        } else if (par1EnumOptions == ModOptions.TAMED) {
            this.showTamed = !this.showTamed;
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (this.customSlimeSeedNeeded(minimapSession)) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(this.modMain, minimapSession.getWaypointsManager(), Minecraft.func_71410_x().field_71462_r));
                return;
            }
            this.slimeChunks = !this.slimeChunks;
        } else if (par1EnumOptions == ModOptions.SAFE_MAP) {
            this.mapSafeMode = !this.mapSafeMode;
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
        } else if (par1EnumOptions == ModOptions.AA) {
            this.antiAliasing = !this.antiAliasing;
        } else if (par1EnumOptions == ModOptions.COLOURS) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.blockColours = (this.blockColours + 1) % blockColourTypes.length;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.LIGHT) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.lighting = !this.lighting;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.COMPASS) {
            this.compassOverWaypoints = !this.compassOverWaypoints;
        } else if (par1EnumOptions == ModOptions.BIOME) {
            this.showBiome = !this.showBiome;
        } else if (par1EnumOptions == ModOptions.ENTITY_HEIGHT) {
            this.showEntityHeight = !this.showEntityHeight;
        } else if (par1EnumOptions == ModOptions.FLOWERS) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.showFlowers = !this.showFlowers;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.KEEP_WP_NAMES) {
            this.keepWaypointNames = !this.keepWaypointNames;
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            ++this.arrowColour;
            if (this.arrowColour == this.arrowColours.length) {
                this.arrowColour = -1;
            }
        } else if (par1EnumOptions == ModOptions.SMOOTH_DOTS) {
            this.smoothDots = !this.smoothDots;
        } else if (par1EnumOptions == ModOptions.WORLD_MAP) {
            this.worldMap = !this.worldMap;
        } else if (par1EnumOptions == ModOptions.CAPES) {
            Patreon5.showCapes = !Patreon5.showCapes;
            Patreon5.saveSettings();
        } else if (par1EnumOptions == ModOptions.TERRAIN_DEPTH) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.terrainDepth = !this.terrainDepth;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.TERRAIN_SLOPES) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.terrainSlopes = (this.terrainSlopes + 1) % 3;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.MAIN_ENTITY_AS) {
            this.mainEntityAs = (this.mainEntityAs + 1) % 3;
        } else if (par1EnumOptions == ModOptions.BLOCK_TRANSPARENCY) {
            this.blockTransparency = !this.blockTransparency;
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
        } else if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
            this.hideWorldNames = (this.hideWorldNames + 1) % 3;
        } else if (par1EnumOptions == ModOptions.OPEN_SLIME_SETTINGS) {
            this.openSlimeSettings = !this.openSlimeSettings;
        } else if (par1EnumOptions == ModOptions.ALWAYS_SHOW_DISTANCE) {
            this.alwaysShowDistance = !this.alwaysShowDistance;
        } else if (par1EnumOptions == ModOptions.SHOW_LIGHT_LEVEL) {
            this.showLightLevel = (this.showLightLevel + 1) % 4;
        } else if (par1EnumOptions == ModOptions.RENDER_LAYER) {
            this.renderLayerIndex = (this.renderLayerIndex + 1) % ForgeEventHandler.OVERLAY_LAYERS.length;
        } else if (par1EnumOptions == ModOptions.SHOW_TIME) {
            this.showTime = (this.showTime + 1) % 5;
        } else if (par1EnumOptions == ModOptions.BIOMES_VANILLA) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.biomeColorsVanillaMode = !this.biomeColorsVanillaMode;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.CENTERED_ENLARGED) {
            this.centeredEnlarged = !this.centeredEnlarged;
        } else if (par1EnumOptions == ModOptions.ZOOMED_OUT_ENLARGED) {
            this.zoomedOutEnlarged = !this.zoomedOutEnlarged;
        } else if (par1EnumOptions == ModOptions.ENTITY_NAMETAGS) {
            this.alwaysEntityNametags = !this.alwaysEntityNametags;
        } else if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
            this.minimapTextAlign = (this.minimapTextAlign + 1) % 3;
        } else if (par1EnumOptions == ModOptions.SHOW_ANGLES) {
            this.showAngles = !this.showAngles;
        } else if (par1EnumOptions == ModOptions.COMPASS_ENABLED) {
            this.compass = !this.compass;
        } else if (par1EnumOptions == ModOptions.HIDE_WP_COORDS) {
            this.hideWaypointCoordinates = !this.hideWaypointCoordinates;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_ALL_SETS) {
            this.renderAllSets = !this.renderAllSets;
        } else if (par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS) {
            if (!this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                this.ignoreHeightmaps = !this.ignoreHeightmaps;
            } else {
                this.modMain.getSupportMods().worldmapSupport.openSettings();
            }
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_BOTTOM) {
            this.waypointsBottom = !this.waypointsBottom;
        } else if (par1EnumOptions == ModOptions.MINIMAP_SHAPE) {
            this.minimapShape = (this.minimapShape + 1) % 2;
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE) {
            if (this.lightOverlayType < 0) {
                this.lightOverlayType = 0;
            }
            this.lightOverlayType = (this.lightOverlayType + 1) % 4;
        }
        this.saveSettings();
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    public void setOptionFloatValue(ModOptions options, float f) throws IOException {
        if (options == ModOptions.OPACITY) {
            this.minimapOpacity = f;
        }
        if (options == ModOptions.WAYPOINTS_SCALE) {
            this.waypointsScale = f;
        }
        if (options == ModOptions.DOTS_SCALE) {
            this.dotsScale = f;
        }
        if (options == ModOptions.HEADS_SCALE) {
            this.headsScale = f;
        }
        if (options == ModOptions.DOT_NAME_SCALE) {
            this.dotNameScale = f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            this.waypointsDistance = (int)f;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            this.waypointsDistanceMin = (int)f;
        }
        if (options == ModOptions.ARROW_SCALE) {
            this.arrowScale = f;
        }
        if (options == ModOptions.HEIGHT_LIMIT) {
            this.heightLimit = (int)f;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_INGAME) {
            this.waypointOpacityIngame = (int)f;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_MAP) {
            this.waypointOpacityMap = (int)f;
        }
        if (options == ModOptions.WAYPOINT_LOOKING_ANGLE) {
            this.lookingAtAngle = (int)f;
        }
        if (options == ModOptions.WAYPOINT_VERTICAL_LOOKING_ANGLE) {
            this.lookingAtAngleVertical = (int)f;
        }
        if (options == ModOptions.CAVE_MAPS_DEPTH) {
            this.caveMapsDepth = (int)f;
        }
        if (options == ModOptions.CHUNK_GRID) {
            this.chunkGrid = (int)f;
        }
        if (options == ModOptions.PLAYER_ARROW_OPACITY) {
            this.playerArrowOpacity = (int)f;
        }
        if (options == ModOptions.LIGHT_OVERLAY_COLOR) {
            this.lightOverlayColor = (int)f;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            this.lightOverlayMaxLight = (int)f;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            this.lightOverlayMinLight = (int)f;
        }
        this.saveSettings();
    }

    public float getOptionFloatValue(ModOptions options) {
        if (options == ModOptions.OPACITY) {
            return this.minimapOpacity;
        }
        if (options == ModOptions.WAYPOINTS_SCALE) {
            return this.waypointsScale;
        }
        if (options == ModOptions.DOTS_SCALE) {
            return this.dotsScale;
        }
        if (options == ModOptions.HEADS_SCALE) {
            return this.headsScale;
        }
        if (options == ModOptions.DOT_NAME_SCALE) {
            return this.dotNameScale;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            return this.waypointsDistance;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            return this.waypointsDistanceMin;
        }
        if (options == ModOptions.ARROW_SCALE) {
            return this.arrowScale;
        }
        if (options == ModOptions.HEIGHT_LIMIT) {
            return this.heightLimit;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_INGAME) {
            return this.waypointOpacityIngame;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_MAP) {
            return this.waypointOpacityMap;
        }
        if (options == ModOptions.WAYPOINT_LOOKING_ANGLE) {
            return this.lookingAtAngle;
        }
        if (options == ModOptions.WAYPOINT_VERTICAL_LOOKING_ANGLE) {
            return this.lookingAtAngleVertical;
        }
        if (options == ModOptions.CAVE_MAPS_DEPTH) {
            return this.caveMapsDepth;
        }
        if (options == ModOptions.CHUNK_GRID) {
            return this.chunkGrid;
        }
        if (options == ModOptions.PLAYER_ARROW_OPACITY) {
            return this.playerArrowOpacity;
        }
        if (options == ModOptions.LIGHT_OVERLAY_COLOR) {
            return this.lightOverlayColor;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            return this.lightOverlayMaxLight;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            return this.lightOverlayMinLight;
        }
        return 1.0f;
    }

    public boolean minimapDisabled() {
        return (serverSettings & 1) != 1;
    }

    public boolean minimapDisplayPlayersDisabled() {
        return (serverSettings & 0x400) != 1024;
    }

    public boolean minimapDisplayMobsDisabled() {
        return (serverSettings & 0x800) != 2048;
    }

    public boolean minimapDisplayItemsDisabled() {
        return (serverSettings & 0x1000) != 4096;
    }

    public boolean minimapDisplayOtherDisabled() {
        return (serverSettings & 0x2000) != 8192;
    }

    public boolean caveMapsDisabled() {
        return (serverSettings & 0x4000) != 16384;
    }

    public boolean showOtherTeamDisabled() {
        return (serverSettings & 0x8000) != 32768;
    }

    public boolean showWaypointsDisabled() {
        return (serverSettings & 0x10000) != 65536;
    }

    public boolean deathpointsDisabled() {
        return (serverSettings & 0x200000) == 0;
    }

    private boolean minimapDisplayTamedMobsDisabled() {
        return (serverSettings & 0x1000000) == 0;
    }

    public void resetServerSettings() {
        serverSettings = defaultSettings;
    }

    public static void setServerSettings() {
    }

    static {
        ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        ENCHANT_COLOR_NAMES = new String[]{"gui.xaero_black", "gui.xaero_dark_blue", "gui.xaero_dark_green", "gui.xaero_dark_aqua", "gui.xaero_dark_red", "gui.xaero_dark_purple", "gui.xaero_gold", "gui.xaero_gray", "gui.xaero_dark_gray", "gui.xaero_blue", "gui.xaero_green", "gui.xaero_aqua", "gui.xaero_red", "gui.xaero_purple", "gui.xaero_yellow", "gui.xaero_white"};
        COLORS = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -22016, -5592406, -11184811, -11184641, -11141291, -11141121, -65536, -43521, -171, -1};
        MINIMAP_SIZE = new String[]{"gui.xaero_tiny", "gui.xaero_small", "gui.xaero_medium", "gui.xaero_large"};
        keyBindZoom = new KeyBinding("gui.xaero_zoom_in", 23, "Xaero's Minimap");
        keyBindZoom1 = new KeyBinding("gui.xaero_zoom_out", 24, "Xaero's Minimap");
        newWaypoint = new KeyBinding("gui.xaero_new_waypoint", 48, "Xaero's Minimap");
        keyWaypoints = new KeyBinding("gui.xaero_waypoints_key", 22, "Xaero's Minimap");
        keyLargeMap = new KeyBinding("gui.xaero_enlarge_map", 44, "Xaero's Minimap");
        keyToggleMap = new KeyBinding("gui.xaero_toggle_map", 0, "Xaero's Minimap");
        keyToggleWaypoints = new KeyBinding("gui.xaero_toggle_waypoints", 0, "Xaero's Minimap");
        keyToggleMapWaypoints = new KeyBinding("gui.xaero_toggle_map_waypoints", 0, "Xaero's Minimap");
        keyToggleSlimes = new KeyBinding("gui.xaero_toggle_slime", 0, "Xaero's Minimap");
        keyToggleGrid = new KeyBinding("gui.xaero_toggle_grid", 0, "Xaero's Minimap");
        keyInstantWaypoint = new KeyBinding("gui.xaero_instant_waypoint", 78, "Xaero's Minimap");
        keySwitchSet = new KeyBinding("gui.xaero_switch_waypoint_set", 0, "Xaero's Minimap");
        keyAllSets = new KeyBinding("gui.xaero_display_all_sets", 0, "Xaero's Minimap");
        keyLightOverlay = new KeyBinding("gui.xaero_toggle_light_overlay", 0, "Xaero's Minimap");
        minimapItemId = null;
        minimapItem = null;
        serverSlimeSeeds = new HashMap();
        distanceTypes = new String[]{"gui.xaero_off", "gui.xaero_looking_at", "gui.xaero_all"};
        blockColourTypes = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
        settingsButton = false;
        updateNotification = true;
        ENTITY_ICONS_OPTIONS = new String[]{"gui.xaero_icons_off", "gui.xaero_icons_list", "gui.xaero_icons_always", "-"};
        SLOPES_MODES = new String[]{"gui.xaero_off", "gui.xaero_slopes_legacy", "gui.xaero_slopes_default"};
        ENTITY_NAMES_OPTIONS = new String[]{"gui.xaero_names_off", "gui.xaero_names_list", "gui.xaero_names_always", "-"};
        SHOW_LIGHT_LEVEL_NAMES = new String[]{"gui.xaero_off", "gui.xaero_light_block", "gui.xaero_light_sky", "gui.xaero_light_both"};
        MINIMAP_SHAPES = new String[]{"gui.xaero_minimap_shape_square", "gui.xaero_minimap_shape_circle"};
    }
}

