/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class JEIIndexerTransfer {
    static ContainerIndexerSubContainer INSTANCE = new ContainerIndexerSubContainer();
    private static ContainerIndexerIRecipeTransferHandler recipeTransferHandler;

    public static void init(IModRegistry registry, IRecipeTransferRegistry recipeTransferRegistry) {
        recipeTransferHandler = new ContainerIndexerIRecipeTransferHandler();
        recipeTransferRegistry.addUniversalRecipeTransferHandler((IRecipeTransferHandler)recipeTransferHandler);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerIndexerSubContainer.class, "minecraft.crafting", 0, 9, 10, 54);
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingWrapper(), "minecraft.crafting");
    }

    public static class ContainerIndexerSubContainer
    extends TileIndexer.ContainerIndexer {
    }

    private static class ContainerIndexerIRecipeTransferHandler
    implements IRecipeTransferHandler<TileIndexer.ContainerIndexer> {
        private ContainerIndexerIRecipeTransferHandler() {
        }

        @Nonnull
        public Class<TileIndexer.ContainerIndexer> getContainerClass() {
            return TileIndexer.ContainerIndexer.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "universal recipe transfer handler";
        }

        @Nullable
        public IRecipeTransferError transferRecipe(@Nonnull TileIndexer.ContainerIndexer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
            IRecipeTransferHandlerHelper handlerHelper = XUJEIPlugin.jeiHelpers.recipeTransferHandlerHelper();
            ArrayList toFind = new ArrayList();
            IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
            Map guiIngredients = itemStackGroup.getGuiIngredients();
            for (IGuiIngredient ingredient : guiIngredients.values()) {
                Set collect;
                if (!ingredient.isInput() || (collect = ingredient.getAllIngredients().stream().map(ItemRef::wrapCrafting).collect(Collectors.toSet())).isEmpty()) continue;
                toFind.add(collect);
            }
            ArrayList<ItemRef> toRequest = new ArrayList<ItemRef>();
            ArrayList<ItemRef> list = container.list;
            for (ItemRef itemRef : list) {
                ItemRef craftingRef = itemRef.toCraftingVersion();
                ItemRef wildRef = craftingRef.toNoMetaVersion();
                Iterator iterator = toFind.iterator();
                while (iterator.hasNext()) {
                    Set itemRefs = (Set)iterator.next();
                    if (!itemRefs.contains(craftingRef) && !itemRefs.contains(wildRef)) continue;
                    toRequest.add(itemRef);
                    iterator.remove();
                }
                if (!toFind.isEmpty()) continue;
                break;
            }
            if (toRequest.isEmpty()) {
                return handlerHelper.createUserErrorWithTooltip(Lang.translate("Unable to find any ingredients"));
            }
            if (doTransfer) {
                for (ItemRef itemRef : toRequest) {
                    XUPacketBuffer pkt = new XUPacketBuffer();
                    if (itemRef == ItemRef.NULL) continue;
                    itemRef.write(pkt);
                    pkt.writeBoolean(maxTransfer);
                    container.sendInputPacket(container.mainButton, pkt);
                }
            }
            return null;
        }
    }

    private static class CraftingWrapper
    implements IRecipeTransferHandler<TileIndexer.ContainerIndexer> {
        private CraftingWrapper() {
        }

        @Nonnull
        public Class<TileIndexer.ContainerIndexer> getContainerClass() {
            return TileIndexer.ContainerIndexer.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return "minecraft.crafting";
        }

        @Nullable
        public IRecipeTransferError transferRecipe(@Nonnull TileIndexer.ContainerIndexer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
            IRecipeTransferHandler handler = XUJEIPlugin.recipeRegistry.getRecipeTransferHandler((Container)INSTANCE, (IRecipeCategory)XUJEIPlugin.recipeRegistry.getRecipeCategories((List)ImmutableList.of((Object)"minecraft.crafting")).get(0));
            IRecipeTransferError result = handler.transferRecipe((Container)container, recipeLayout, player, maxTransfer, false);
            if (result == null) {
                if (doTransfer) {
                    return handler.transferRecipe((Container)container, recipeLayout, player, maxTransfer, true);
                }
                return null;
            }
            return recipeTransferHandler.transferRecipe(container, recipeLayout, player, maxTransfer, doTransfer);
        }
    }
}

