/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.api.recipes.ICustomRecipeMatching;
import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.EntityCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.VanillaProfessions;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemGoldenLasso
extends XUItemFlat
implements ICustomRecipeMatching {
    public static final String NBT_ANIMAL = "Animal";
    public static final String NBT_ANIMAL_DISPLAY = "Animal_Metadata";
    public static final String NBT_GOLDEN_LASSO_PREVENT = "[GoldenLassoPrevent]";
    public static final List<ItemStack> genericNiceRecipeItemList = new ArrayList<ItemStack>();
    public static final List<ItemStack> genericEvilRecipeItemList = new ArrayList<ItemStack>();
    public static final String NBT_ANIMAL_ALREADYPICKEDUP = "CursedLassoPickedUp";
    public static final String NBT_ANIMAL_NOPLACE = "No_Place";
    public static final String NBT_ANIMAL_NOPLACE_OLD = "NoPlace";

    public ItemGoldenLasso() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ItemStack newCraftingVillagerStack(boolean needsContract, VanillaProfessions profession) {
        ItemStack itemStack = ItemGoldenLasso.newCraftingStack(EntityVillager.class);
        NBTTagCompound tags = NBTHelper.getOrInitTagCompound(itemStack.func_77978_p(), NBT_ANIMAL);
        if (needsContract) {
            NBTHelper.getOrInitTagCompound(tags, "ForgeData").func_74757_a("Contracted", true);
        }
        if (profession != null) {
            tags.func_74768_a("Profession", profession.profession);
            tags.func_74768_a("Career", profession.career);
        }
        return itemStack;
    }

    public static ItemStack newCraftingStack(Class<? extends Entity> entity) {
        int meta = IMob.class.isAssignableFrom(entity) ? 1 : 0;
        ItemStack itemStack = XU2Entries.goldenLasso.newStack(1, meta);
        NBTTagCompound animalTag = NBTHelper.getOrInitTagCompound(NBTHelper.getOrInitTagCompound(itemStack), NBT_ANIMAL);
        animalTag.func_74778_a("id", EntityCompat.getKey(entity));
        ItemGoldenLasso.setNoPlace(itemStack);
        return itemStack;
    }

    public static void setNoPlace(ItemStack cursedLasso) {
        cursedLasso.func_77978_p().func_74757_a(NBT_ANIMAL_NOPLACE, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    @Override
    public int getMaxMetadata() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("dark_lasso", "golden_lasso", "lasso_internal_1", "lasso_internal_2");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.hasAnimal(stack);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        NBTTagCompound tagCompound = copy.func_77978_p();
        tagCompound.func_82580_o(NBT_ANIMAL);
        tagCompound.func_82580_o("display");
        return copy;
    }

    @Override
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        switch (renderPass) {
            case 1: {
                return "lasso_internal_1";
            }
            case 2: {
                return "lasso_internal_2";
            }
        }
        if (StackHelper.isNonNull(itemStack) && itemStack.func_77952_i() == 1) {
            return "dark_lasso";
        }
        return "golden_lasso";
    }

    @Override
    public int getRenderLayers(@Nullable ItemStack itemStack) {
        return this.hasAnimal(itemStack) ? 3 : 1;
    }

    @Override
    public boolean renderLayerIn3D(ItemStack stack, int renderPass) {
        return renderPass == 0;
    }

    @Override
    public int getTint(ItemStack stack, int i) {
        switch (i) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean hasAnimal(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return this.hasAnimal(tagCompound);
    }

    private boolean hasAnimal(NBTTagCompound tagCompound) {
        return tagCompound != null && tagCompound.func_150297_b(NBT_ANIMAL, 10);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (this.hasAnimal(stack)) {
            return false;
        }
        if (target.field_70170_p.field_72995_K) {
            return true;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (stack.func_77952_i() == 1) {
            if (!(target instanceof IMob)) {
                playerIn.func_145747_a((ITextComponent)Lang.chat("%s is not a hostile mob.", target.func_145748_c_()));
                return false;
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                float maxHealth;
                float threshold;
                if (!target.func_184222_aU()) {
                    playerIn.func_145747_a((ITextComponent)Lang.chat("%s is too powerful.", target.func_145748_c_()));
                    return false;
                }
                NBTTagCompound data = target.getEntityData();
                if (data.func_74767_n(NBT_ANIMAL_ALREADYPICKEDUP)) {
                    return true;
                }
                float health = target.func_110143_aJ();
                if (health > (threshold = MathHelper.func_76131_a((float)((maxHealth = target.func_110138_aP()) / 4.0f), (float)4.0f, (float)10.0f))) {
                    playerIn.func_145747_a((ITextComponent)Lang.chat("%s has too much health (%s hearts). Reduce to %s hearts.", target.func_145748_c_(), (int)Math.floor(health / 2.0f), (int)Math.floor(threshold / 2.0f)));
                    return false;
                }
            }
        } else {
            if (target instanceof IMob) {
                playerIn.func_145747_a((ITextComponent)Lang.chat("%s is a hostile mob.", target.func_145748_c_()));
                return false;
            }
            if (!(target instanceof EntityCreature || target instanceof EntityAmbientCreature || target instanceof EntityWaterMob)) {
                return false;
            }
            if (((EntityLiving)target).func_70638_az() != null) {
                playerIn.func_145747_a((ITextComponent)Lang.chat("%s is too busy attacking someone.", target.func_145748_c_()));
                return false;
            }
        }
        return this.addTargetToLasso(stack, target);
    }

    public boolean addTargetToLasso(ItemStack stack, EntityLivingBase target) {
        if (target instanceof IMerchant) {
            target.func_145748_c_();
        }
        float health = target.func_110143_aJ();
        float maxHealth = target.func_110138_aP();
        NBTTagCompound entityTags = new NBTTagCompound();
        entityTags.func_74757_a(NBT_GOLDEN_LASSO_PREVENT, false);
        if (!target.func_184198_c(entityTags)) {
            return false;
        }
        if (!entityTags.func_74764_b(NBT_GOLDEN_LASSO_PREVENT) || entityTags.func_74767_n(NBT_GOLDEN_LASSO_PREVENT)) {
            return false;
        }
        entityTags.func_82580_o(NBT_GOLDEN_LASSO_PREVENT);
        String name = "";
        if (target.func_145818_k_()) {
            name = target.func_95999_t();
        }
        target.func_70106_y();
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(stack);
        nbt.func_74757_a(NBT_ANIMAL_NOPLACE, false);
        nbt.func_74782_a(NBT_ANIMAL, (NBTBase)entityTags);
        NBTTagCompound display = NBTHelper.getOrInitTagCompound(nbt, NBT_ANIMAL_DISPLAY);
        display.func_74776_a("Health", health);
        display.func_74776_a("MaxHealth", maxHealth);
        if (!name.equals("")) {
            stack.func_151001_c(name);
        }
        return true;
    }

    @Override
    @Nonnull
    public EnumActionResult onItemUseBase(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.hasAnimal(stack)) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound stackTags = stack.func_77978_p();
        NBTTagCompound entityTags = stackTags.func_74775_l(NBT_ANIMAL);
        if (entityTags.func_82582_d() || !entityTags.func_150297_b("id", 8)) {
            stackTags.func_82580_o(NBT_ANIMAL);
            return EnumActionResult.FAIL;
        }
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(side), side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (stack.func_77952_i() == 1 && worldIn.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            playerIn.func_145747_a((ITextComponent)Lang.chat("Difficulty set to peaceful.", new Object[0]));
            return EnumActionResult.FAIL;
        }
        if (stackTags.func_74767_n(NBT_ANIMAL_NOPLACE)) {
            if (playerIn.func_70093_af()) {
                stackTags.func_82580_o(NBT_ANIMAL);
                stackTags.func_82580_o(NBT_ANIMAL_DISPLAY);
                stackTags.func_82580_o(NBT_ANIMAL_NOPLACE);
                playerIn.func_145747_a((ITextComponent)Lang.chat("Mob soul released.", new Object[0]));
                stack.func_135074_t();
                return EnumActionResult.SUCCESS;
            }
            float health = stackTags.func_74775_l(NBT_ANIMAL_DISPLAY).func_74760_g("Health");
            playerIn.func_145747_a((ITextComponent)Lang.chat("Unable to place mob.", new Object[0]));
            if ((double)health <= 1.0E-10) {
                playerIn.func_145747_a((ITextComponent)Lang.chat("Mob's body is dead.", new Object[0]));
            }
            playerIn.func_145747_a((ITextComponent)Lang.chat("Sneak-right-click to release soul.", new Object[0]));
            return EnumActionResult.SUCCESS;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(side);
        double d0 = 0.0;
        if (side == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        entityTags.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5));
        entityTags.func_74782_a("Motion", (NBTBase)this.newDoubleNBTList(0.0, 0.0, 0.0));
        entityTags.func_74776_a("FallDistance", 0.0f);
        entityTags.func_74768_a("Dimension", worldIn.field_73011_w.getDimension());
        Entity entity = EntityList.func_75615_a((NBTTagCompound)entityTags, (World)worldIn);
        if (entity != null) {
            if (entity instanceof EntityLiving && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (entity instanceof IMob) {
                entity.getEntityData().func_74757_a(NBT_ANIMAL_ALREADYPICKEDUP, true);
            }
            worldIn.func_72838_d(entity);
        }
        stackTags.func_82580_o(NBT_ANIMAL);
        stackTags.func_82580_o(NBT_ANIMAL_DISPLAY);
        stackTags.func_82580_o(NBT_ANIMAL_NOPLACE);
        stack.func_135074_t();
        if (playerIn.field_71075_bZ.field_75098_d) {
            playerIn.func_184611_a(hand, stack.func_77946_l());
        }
        playerIn.field_71071_by.func_70296_d();
        return EnumActionResult.SUCCESS;
    }

    private NBTTagList newDoubleNBTList(double ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : numbers) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound entityTags;
        NBTTagCompound itemTags = stack.func_77978_p();
        if (this.hasAnimal(itemTags) && (entityTags = itemTags.func_74775_l(NBT_ANIMAL)).func_74764_b("id")) {
            if (!tooltip.isEmpty()) {
                tooltip.set(0, tooltip.get(0).replaceFirst(TextFormatting.ITALIC + stack.func_82833_r() + TextFormatting.RESET, this.func_77653_i(stack)));
            }
            String id = entityTags.func_74779_i("id");
            String animal_name = CompatHelper.getName(id);
            tooltip.add(animal_name);
            if ("Villager".equals(id)) {
                if (entityTags.func_74764_b("Profession")) {
                    int career = entityTags.func_74762_e("Career");
                    int profession = entityTags.func_74762_e("Profession");
                    int t = MCTimer.clientTimer >> 4;
                    String s1 = null;
                    switch (profession) {
                        case 0: {
                            if (career == 0) {
                                career = t % 4 + 1;
                            }
                            if (career == 1) {
                                s1 = "farmer";
                                break;
                            }
                            if (career == 2) {
                                s1 = "fisherman";
                                break;
                            }
                            if (career == 3) {
                                s1 = "shepherd";
                                break;
                            }
                            if (career != 4) break;
                            s1 = "fletcher";
                            break;
                        }
                        case 1: {
                            s1 = "librarian";
                            break;
                        }
                        case 2: {
                            s1 = "cleric";
                            break;
                        }
                        case 3: {
                            if (career == 0) {
                                career = t % 3 + 1;
                            }
                            if (career == 1) {
                                s1 = "armor";
                                break;
                            }
                            if (career == 2) {
                                s1 = "weapon";
                                break;
                            }
                            if (career != 3) break;
                            s1 = "tool";
                            break;
                        }
                        case 4: {
                            if (career == 0) {
                                career = t % 2 + 1;
                            }
                            if (career == 1) {
                                s1 = "butcher";
                                break;
                            }
                            if (career != 2) break;
                            s1 = "leather";
                        }
                    }
                    if (s1 != null) {
                        tooltip.add(I18n.func_74838_a((String)("entity.Villager." + s1)));
                    }
                }
                if (entityTags.func_74775_l("ForgeData").func_74767_n("Contracted")) {
                    tooltip.add(Lang.translate("*Under Contract*"));
                }
            }
            float health = itemTags.func_74775_l(NBT_ANIMAL_DISPLAY).func_74760_g("Health");
            float maxHealth = itemTags.func_74775_l(NBT_ANIMAL_DISPLAY).func_74760_g("MaxHealth");
            tooltip.add(Lang.translateArgs("Health: %s/%s", Float.valueOf(health), Float.valueOf(maxHealth)));
            if (stack.func_82837_s()) {
                tooltip.add(stack.func_82833_r());
            }
        }
    }

    @Override
    public void getSubItemsBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn, 1, 0));
        subItems.add(new ItemStack(itemIn, 1, 1));
    }

    public ItemStack check(ItemStack stack) {
        return StackHelper.isNull(stack) || stack.func_77973_b() != this || stack.func_77952_i() != 1 || this.hasAnimal(stack) ? null : stack;
    }

    @SubscribeEvent
    public void goldenLassoActivate(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ItemStack itemstack = entityPlayer.func_184586_b(event.getHand());
        if (StackHelper.isNonNull(itemstack) && itemstack.func_77973_b() == this && (entity = event.getTarget()) instanceof EntityLivingBase) {
            itemstack.func_111282_a(entityPlayer, (EntityLivingBase)entity, event.getHand());
            if (StackHelper.getStacksize(itemstack) <= 0) {
                entityPlayer.func_184611_a(event.getHand(), StackHelper.empty());
            }
            event.setCanceled(true);
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + stack.func_77952_i();
    }

    @Override
    public boolean itemsMatch(ItemStack slot, @Nonnull ItemStack target) {
        NBTTagCompound slotTags;
        String slotID;
        boolean sAnim;
        if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)slot, (boolean)false)) {
            return false;
        }
        boolean tAnim = this.hasAnimal(target);
        if (tAnim != (sAnim = this.hasAnimal(slot))) {
            return false;
        }
        if (!sAnim) {
            return true;
        }
        NBTTagCompound targetTags = this.getAnimalTags(target);
        String targetID = targetTags.func_74779_i("id");
        return targetID.equals(slotID = (slotTags = this.getAnimalTags(slot)).func_74779_i("id")) && ICustomRecipeMatching.satisfies((NBTBase)targetTags, (NBTBase)slotTags);
    }

    public NBTTagCompound getAnimalTags(ItemStack target) {
        return target.func_77978_p().func_74775_l(NBT_ANIMAL);
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        nbt.func_82580_o(NBT_ANIMAL_NOPLACE_OLD);
        return super.func_179215_a(nbt);
    }
}

