/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.blockaccess.ThreadSafeBlockAccess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TransferNodeEnergy
extends Grocket {
    public static final int MAX_SEND = 10000;
    static boolean sending = false;
    public ListenableFuture<Runnable> submit;
    boolean needsRecheck = true;
    @Nullable
    ArrayList<TileIndexer.SidedPos> dests;
    int sentPerTick = 0;
    public IEnergyStorage storage = new IEnergyStorage(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int receiveEnergy(int energy, boolean simulate) {
            if (sending) {
                return 0;
            }
            try {
                sending = true;
                ArrayList<TileIndexer.SidedPos> dests = TransferNodeEnergy.this.dests;
                if (dests == null) {
                    int n = 0;
                    return n;
                }
                if ((energy = Math.min(10000 - TransferNodeEnergy.this.sentPerTick, energy)) <= 0) {
                    int n = 0;
                    return n;
                }
                HashSet<IEnergyStorage> storages = new HashSet<IEnergyStorage>();
                World world = TransferNodeEnergy.this.holder.world();
                for (TileIndexer.SidedPos pos : dests) {
                    IPipe pipe = TransferHelper.getPipe((IBlockAccess)world, pos.pos);
                    if (pipe == null) continue;
                    IEnergyStorage capability = pipe.getCapability((IBlockAccess)world, pos.pos, pos.side, CapGetter.energyReceiver);
                    if (capability == null) {
                        TransferNodeEnergy.this.needsRecheck = true;
                        continue;
                    }
                    storages.add(capability);
                }
                if (storages.isEmpty()) {
                    int n = 0;
                    return n;
                }
                int sent = 0;
                if (!simulate) {
                    int limit;
                    for (int i = 0; i < 3 && (limit = energy / storages.size()) > 0; ++i) {
                        IEnergyStorage storage;
                        Iterator iterator = storages.iterator();
                        while (iterator.hasNext() && (sent += (storage = (IEnergyStorage)iterator.next()).receiveEnergy(Math.min(energy - sent, limit), false)) < energy) {
                        }
                    }
                }
                if (sent < energy) {
                    IEnergyStorage storage;
                    Iterator iterator = storages.iterator();
                    while (iterator.hasNext() && (sent += (storage = (IEnergyStorage)iterator.next()).receiveEnergy(energy - sent, simulate)) < energy) {
                    }
                }
                TransferNodeEnergy.this.sentPerTick += sent;
                int n = sent;
                return n;
            }
            finally {
                sending = false;
            }
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 10000;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
        }
        return super.getCapability(capability);
    }

    @Override
    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.needsRecheck = true;
        return true;
    }

    @Override
    public void func_73660_a() {
        this.sentPerTick = 0;
        if (this.holder.func_145831_w().field_72995_K) {
            return;
        }
        if (this.submit != null) {
            return;
        }
        if (!this.needsRecheck && this.holder.func_145831_w().func_82737_E() % 200L != 0L) {
            return;
        }
        final PositionPool pool = new PositionPool();
        BlockPos intern = pool.intern(this.holder.func_174877_v());
        final HashSet alreadyChecked = new HashSet();
        final LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(intern);
        final ThreadSafeBlockAccess world = new ThreadSafeBlockAccess((WorldServer)this.holder.func_145831_w());
        this.submit = HttpUtil.field_180193_a.submit((Callable)new Callable<Runnable>(){

            @Override
            public Runnable call() throws Exception {
                BlockPos pos1;
                ArrayList<TileIndexer.SidedPos> sides = new ArrayList<TileIndexer.SidedPos>();
                while ((pos1 = (BlockPos)toCheck.poll()) != null) {
                    if (TransferNodeEnergy.this.holder.func_145837_r()) {
                        return null;
                    }
                    IPipe pipe = TransferHelper.getPipe(world, pos1);
                    if (pipe == null) continue;
                    for (EnumFacing facing : EnumFacing.values()) {
                        IPipe otherPipe;
                        BlockPos offset;
                        if (pipe.hasCapability(world, pos1, facing, CapGetter.energyReceiver)) {
                            sides.add(new TileIndexer.SidedPos(pos1, facing));
                        }
                        if (alreadyChecked.contains(offset = pool.offset(pos1, facing)) || (otherPipe = TransferHelper.getPipe(world, offset)) == null || (!pipe.canOutput(world, pos1, facing, null) || !otherPipe.canInput(world, offset, facing.func_176734_d())) && (!pipe.canInput(world, pos1, facing) || !otherPipe.canOutput(world, offset, facing.func_176734_d(), null))) continue;
                        alreadyChecked.add(offset);
                        toCheck.add(offset);
                    }
                }
                return () -> TransferNodeEnergy.this.process(sides);
            }
        });
        Futures.addCallback(this.submit, (FutureCallback)new FutureCallback<Runnable>(){

            public void onSuccess(Runnable result) {
                if (result != null) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(result);
                }
                TransferNodeEnergy.this.submit = null;
            }

            public void onFailure(@Nonnull Throwable t) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                    throw Throwables.propagate((Throwable)t);
                });
                TransferNodeEnergy.this.submit = null;
            }
        });
    }

    public void process(ArrayList<TileIndexer.SidedPos> sides) {
        this.dests = sides;
    }

    @Override
    public GrocketType getType() {
        return GrocketType.TRANSFER_NODE_ENERGY;
    }

    @Override
    public float getPower() {
        return 0.0f;
    }
}

