/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public class PressurizedOutput
extends MachineOutput<PressurizedOutput> {
    private ItemStack itemOutput = ItemStack.field_190927_a;
    private GasStack gasOutput;

    public PressurizedOutput(ItemStack item, GasStack gas) {
        this.itemOutput = item;
        this.gasOutput = gas;
    }

    public PressurizedOutput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemOutput = new ItemStack(nbtTags.func_74775_l("itemOutput"));
        this.gasOutput = GasStack.readFromNBT(nbtTags.func_74775_l("gasOutput"));
    }

    public boolean canFillTank(GasTank tank) {
        return tank.canReceive(this.gasOutput.getGas()) && tank.getNeeded() >= this.gasOutput.amount;
    }

    public boolean canAddProducts(NonNullList<ItemStack> inventory, int index) {
        ItemStack stack = (ItemStack)inventory.get(index);
        return stack.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.itemOutput) && stack.func_190916_E() + this.itemOutput.func_190916_E() <= stack.func_77976_d();
    }

    public void fillTank(GasTank tank) {
        tank.receive(this.gasOutput, true);
    }

    public void addProducts(NonNullList<ItemStack> inventory, int index) {
        ItemStack stack = (ItemStack)inventory.get(index);
        if (stack.func_190926_b()) {
            inventory.set(index, (Object)this.itemOutput.func_77946_l());
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.itemOutput)) {
            stack.func_190917_f(this.itemOutput.func_190916_E());
        }
    }

    public boolean applyOutputs(NonNullList<ItemStack> inventory, int index, GasTank tank, boolean doEmit) {
        if (this.canFillTank(tank) && this.canAddProducts(inventory, index)) {
            if (doEmit) {
                this.fillTank(tank);
                this.addProducts(inventory, index);
            }
            return true;
        }
        return false;
    }

    public ItemStack getItemOutput() {
        return this.itemOutput;
    }

    public GasStack getGasOutput() {
        return this.gasOutput;
    }

    @Override
    public PressurizedOutput copy() {
        return new PressurizedOutput(this.itemOutput.func_77946_l(), this.gasOutput.copy());
    }
}

