/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.GasConversionHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityAdvancedElectricMachine<RECIPE extends AdvancedMachineRecipe<RECIPE>>
extends TileEntityUpgradeableMachine<AdvancedMachineInput, ItemStackOutput, RECIPE>
implements IGasHandler,
ISustainedData {
    private static final String[] methods = new String[]{"getEnergy", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    public static final int BASE_TICKS_REQUIRED = 200;
    public static final int BASE_GAS_PER_TICK = 1;
    public static int MAX_GAS = 210;
    public int BASE_SECONDARY_ENERGY_PER_TICK;
    public double secondaryEnergyPerTick;
    public int secondaryEnergyThisTick;
    public GasTank gasTank;
    public Gas prevGas;

    public TileEntityAdvancedElectricMachine(String soundPath, BlockStateMachine.MachineType type, int ticksRequired, int secondaryPerTick) {
        super(soundPath, type, 4, ticksRequired, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiAdvancedMachine.png"));
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 1, 0, 3, 0, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.gasTank = new GasTank(MAX_GAS);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        this.BASE_SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.secondaryEnergyPerTick = secondaryPerTick;
        if (this.upgradeableSecondaryEfficiency()) {
            this.upgradeComponent.setSupported(Upgrade.GAS);
        }
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.inventory.set(5, this.inventory.get(0));
        factory.inventory.set(4, this.inventory.get(1));
        factory.inventory.set(8, this.inventory.get(2));
        factory.inventory.set(1, this.inventory.get(3));
        factory.inventory.set(0, this.inventory.get(4));
    }

    @Nullable
    public GasStack getItemGas(ItemStack itemStack) {
        return GasConversionHandler.getItemGas(itemStack, this.gasTank, this::isValidGas);
    }

    public abstract boolean isValidGas(Gas var1);

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            this.handleSecondaryFuel();
            boolean inactive = false;
            MachineRecipe recipe = this.getRecipe();
            int n = this.secondaryEnergyThisTick = this.useStatisticalMechanics() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick);
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
                this.gasTank.draw(this.secondaryEnergyThisTick, true);
                this.electricityStored -= this.energyPerTick;
            } else {
                inactive = true;
                this.setActive(false);
            }
            if (inactive && this.getRecipe() == null) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.gasTank.getGasType() != null && this.gasTank.getStored() != 0) {
                this.prevGas = this.gasTank.getGasType();
            }
        }
    }

    public void handleSecondaryFuel() {
        GasStack gasStack;
        ItemStack itemStack = (ItemStack)this.inventory.get(1);
        int needed = this.gasTank.getNeeded();
        if (!itemStack.func_190926_b() && needed > 0 && (gasStack = this.getItemGas(itemStack)) != null && needed >= gasStack.amount) {
            if (itemStack.func_77973_b() instanceof IGasItem) {
                IGasItem item = (IGasItem)itemStack.func_77973_b();
                this.gasTank.receive(item.removeGas(itemStack, gasStack.amount), true);
            } else {
                this.gasTank.receive(gasStack, true);
                itemStack.func_190918_g(1);
            }
        }
    }

    public boolean upgradeableSecondaryEfficiency() {
        return false;
    }

    public boolean useStatisticalMechanics() {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 4) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 0) {
            for (AdvancedMachineInput input : this.getRecipes().keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemStack, (ItemStack)itemstack)) continue;
                return true;
            }
        } else {
            if (slotID == 3) {
                return ChargeUtils.canBeDischarged(itemstack);
            }
            if (slotID == 1) {
                return this.getItemGas(itemstack) != null;
            }
        }
        return false;
    }

    @Override
    public AdvancedMachineInput getInput() {
        return new AdvancedMachineInput((ItemStack)this.inventory.get(0), this.prevGas);
    }

    @Override
    public RECIPE getRecipe() {
        AdvancedMachineInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((AdvancedMachineInput)((AdvancedMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((AdvancedMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((AdvancedMachineRecipe)recipe).operate((NonNullList<ItemStack>)this.inventory, 0, 2, this.gasTank, this.secondaryEnergyThisTick);
        this.func_70296_d();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((AdvancedMachineRecipe)recipe).canOperate((NonNullList<ItemStack>)this.inventory, 0, 2, this.gasTank, this.secondaryEnergyThisTick);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.gasTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.gasTank);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.gasTank.setMaxGas(MAX_GAS);
        GasUtils.clearIfInvalid(this.gasTank, this::isValidGas);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        if (upgrade == Upgrade.SPEED || this.upgradeableSecondaryEfficiency() && upgrade == Upgrade.GAS) {
            this.secondaryEnergyPerTick = MekanismUtils.getSecondaryEnergyPerTickMean(this, this.BASE_SECONDARY_ENERGY_PER_TICK);
        }
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.gasTank.getStored()};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate((RECIPE)this.getRecipe())};
            }
            case 6: {
                return new Object[]{this.maxEnergy};
            }
            case 7: {
                return new Object[]{this.maxEnergy - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        GasUtils.writeSustainedData(this.gasTank, itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        GasUtils.readSustainedData(this.gasTank, itemStack);
    }
}

