/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class CraftingMonitorElementError
implements ICraftingMonitorElement {
    public static final String ID = "error";
    private ICraftingMonitorElement base;
    private String message;

    public CraftingMonitorElementError(ICraftingMonitorElement base, String message) {
        this.base = base;
        this.message = message;
    }

    @Override
    public void draw(int x, int y, IElementDrawers drawers) {
        this.base.draw(x, y, drawers);
        drawers.getErrorDrawer().draw(x, y, null);
    }

    @Override
    @Nullable
    public String getTooltip() {
        return this.base.getTooltip() + "\n" + TextFormatting.RED + I18n.func_135052_a((String)this.message, (Object[])new Object[0]);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.base.getId());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        this.base.write(buf);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        return this.elementHashCode() == element.elementHashCode() && this.base.merge(((CraftingMonitorElementError)element).base);
    }

    @Override
    public int elementHashCode() {
        return this.base.elementHashCode() ^ this.message.hashCode();
    }
}

