/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeReader;
import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.CollisionGroup;
import com.raoulvdberge.refinedstorage.tile.TileReader;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReader
extends BlockCable {
    public BlockReader() {
        super(BlockReader.createBuilder("reader").tileEntity(TileReader::new).create());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "connected=false,direction=north,down=false,east=true,north=false,south=false,up=false,west=true"));
        this.registerCoverAndFullbright(modelRegistration, "refinedstorage:blocks/reader/cutouts/connected");
    }

    @Override
    @Nullable
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    public List<CollisionGroup> getCollisions(TileEntity tile, IBlockState state) {
        return RSBlocks.CONSTRUCTOR.getCollisions(tile, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.canAccessGui(state, world, pos, hitX, hitY, hitZ)) {
            return false;
        }
        if (!world.field_72995_K) {
            NetworkNodeReader reader = (NetworkNodeReader)((TileReader)world.func_175625_s(pos)).getNode();
            if (player.func_70093_af()) {
                IReaderWriterChannel channel;
                if (reader.getNetwork() != null && (channel = reader.getNetwork().getReaderWriterManager().getChannel(reader.getChannel())) != null) {
                    channel.getHandlers().stream().map(h -> h.getStatusReader(reader, channel)).flatMap(Collection::stream).forEach(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
                }
            } else {
                this.openNetworkGui(20, player, world, pos, side);
            }
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileReader && side == ((TileReader)tile).getDirection().func_176734_d();
    }

    @Override
    public boolean hasConnectedState() {
        return true;
    }
}

