/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps;

import com.google.gson.Gson;
import guichaguri.betterfps.BetterFps;
import guichaguri.betterfps.BetterFpsConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterFpsHelper {
    public static final Logger LOG = LogManager.getLogger((String)"BetterFps");
    private static BetterFpsConfig INSTANCE = null;
    private static File CONFIG_FILE = null;

    public static BetterFpsConfig getConfig() {
        if (INSTANCE == null) {
            BetterFpsHelper.loadConfig();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig() {
        FileReader reader;
        block10: {
            File configPath = BetterFps.GAME_DIR == null ? new File("config") : new File(BetterFps.GAME_DIR, "config");
            CONFIG_FILE = new File(configPath, "betterfps.json");
            File oldConfig = BetterFps.GAME_DIR == null ? new File("config" + File.pathSeparator + "betterfps.json") : new File(BetterFps.GAME_DIR, "config" + File.pathSeparator + "betterfps.json");
            if (oldConfig.exists()) {
                reader = null;
                try {
                    reader = new FileReader(oldConfig);
                    INSTANCE = (BetterFpsConfig)new Gson().fromJson((Reader)reader, BetterFpsConfig.class);
                    BetterFpsHelper.saveConfig();
                }
                catch (Exception ex) {
                    try {
                        LOG.error("Could not load the old config file. It will be deleted.");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        oldConfig.deleteOnExit();
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    oldConfig.deleteOnExit();
                }
                IOUtils.closeQuietly((Reader)reader);
                oldConfig.deleteOnExit();
                return;
            }
            reader = null;
            try {
                if (!CONFIG_FILE.exists()) break block10;
                reader = new FileReader(CONFIG_FILE);
                INSTANCE = (BetterFpsConfig)new Gson().fromJson((Reader)reader, BetterFpsConfig.class);
            }
            catch (Exception ex) {
                try {
                    LOG.error("Could not load the config file", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        if (INSTANCE == null) {
            INSTANCE = new BetterFpsConfig();
        }
        BetterFpsHelper.saveConfig();
    }

    public static void saveConfig() {
        FileWriter writer = null;
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            writer = new FileWriter(CONFIG_FILE);
            new Gson().toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (Exception ex) {
            try {
                LOG.error("Could not save the config file", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

