/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.book.page;

import com.buuz135.industrial.api.book.CategoryEntry;
import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.gui.GUIBookBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class PageItemList
implements IPage {
    private final List<ItemStack> itemStacks;
    private final String display;

    public PageItemList(List<ItemStack> itemStacks, String display) {
        this.itemStacks = itemStacks;
        this.display = display;
    }

    public static List<PageItemList> generatePagesFromItemStacks(List<ItemStack> stacks, String display) {
        ArrayList<PageItemList> pages = new ArrayList<PageItemList>();
        while (stacks.size() > 49) {
            pages.add(new PageItemList(stacks.subList(0, 49), display));
            stacks = stacks.subList(49, stacks.size());
        }
        pages.add(new PageItemList(stacks, display));
        return pages;
    }

    @Override
    public void drawScreenPre(CategoryEntry entry, GUIBookBase base, int mouseX, int mouseY, float partialTicks, FontRenderer renderer) {
        renderer.func_78276_b(TextFormatting.DARK_GRAY + this.display, base.getGuiLeft() + 15, base.getGuiTop() + 24, 0xFFFFFF);
        RenderHelper.func_74520_c();
        int itemsRow = (base.getGuiXSize() - 40) / 18;
        for (int pos = 0; pos < this.itemStacks.size(); ++pos) {
            base.field_146297_k.func_175599_af().func_175042_a(this.itemStacks.get(pos), base.getGuiLeft() + 15 + pos % itemsRow * 20, base.getGuiTop() + 35 + pos / itemsRow * 20);
        }
    }

    @Override
    public void drawScreen(CategoryEntry entry, GUIBookBase base, int mouseX, int mouseY, float partialTicks, FontRenderer renderer) {
    }

    @Override
    public void drawScreenPost(CategoryEntry entry, GUIBookBase base, int mouseX, int mouseY, float partialTicks, FontRenderer renderer) {
        for (int pos = 0; pos < this.itemStacks.size(); ++pos) {
            int itemsRow = (base.getGuiXSize() - 40) / 18;
            if (mouseX < base.getGuiLeft() + 15 + pos % itemsRow * 20 || mouseX > base.getGuiLeft() + 15 + pos % itemsRow * 20 + 16 || mouseY < base.getGuiTop() + 35 + pos / itemsRow * 20 || mouseY > base.getGuiTop() + 35 + pos / itemsRow * 20 + 16) continue;
            base.func_146283_a(this.itemStacks.get(pos).func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL), mouseX, mouseY);
            break;
        }
    }
}

