/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.event;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.capability.IPlayerExtendedProperties;
import com.lothrazar.cyclicmagic.data.IRenderOutline;
import com.lothrazar.cyclicmagic.item.cyclicwand.InventoryWand;
import com.lothrazar.cyclicmagic.item.cyclicwand.ItemCyclicWand;
import com.lothrazar.cyclicmagic.playerupgrade.spell.ISpell;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.SpellRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import com.lothrazar.cyclicmagic.util.UtilTextureRender;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventRender {
    public static SpellHud spellHud;
    public static RenderLoc renderLocation;

    public EventRender() {
        spellHud = new SpellHud();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderWorldLastEvent evt) {
        IRenderOutline wandInstance;
        Set<BlockPos> coordinates;
        RayTraceResult mouseOver;
        EntityPlayer player = ModCyclic.proxy.getClientPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof IRenderOutline && (mouseOver = Minecraft.func_71410_x().field_71476_x) != null && mouseOver.func_178782_a() != null && mouseOver.field_178784_b != null && (coordinates = (wandInstance = (IRenderOutline)heldItem.func_77973_b()).renderOutline(player.func_130014_f_(), heldItem, mouseOver)) != null && coordinates.size() > 0) {
            int[] rgb = wandInstance.getRgb();
            UtilWorld.OutlineRenderer.renderOutlines(evt, player, coordinates, rgb[0], rgb[1], rgb[2]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTextOverlay(RenderGameOverlayEvent.Text event) {
        int noclipTicks;
        int flyingTicks;
        ItemStack wand;
        EntityPlayer player = ModCyclic.proxy.getClientPlayer();
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(player);
        if (props != null && props.getTODO() != null && props.getTODO().length() > 0) {
            event.getRight().add(props.getTODO());
        }
        if (!(wand = UtilSpellCaster.getPlayerWandIfHeld(player)).func_190926_b()) {
            spellHud.drawSpellWheel(wand);
        }
        if ((flyingTicks = props.getFlyingTimer()) > 0) {
            int secs = flyingTicks / 20;
            String time = UtilChat.formatSecondsToMinutes(secs);
            event.getRight().add(UtilChat.lang("screentext.flying.seconds") + time);
        }
        if ((noclipTicks = props.getChorusTimer()) > 0) {
            int secs = noclipTicks / 20;
            String time = UtilChat.formatSecondsToMinutes(secs);
            event.getRight().add(UtilChat.lang("screentext.noclip.seconds") + time);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        EntityPlayer effectivePlayer = ModCyclic.proxy.getClientPlayer();
        ItemStack heldWand = UtilSpellCaster.getPlayerWandIfHeld(effectivePlayer);
        if (heldWand.func_190926_b()) {
            return;
        }
        int itemSlot = ItemCyclicWand.BuildType.getSlot(heldWand);
        ItemStack current = InventoryWand.getFromSlot(heldWand, itemSlot);
        if (!current.func_190926_b()) {
            int leftOff = 7;
            int rightOff = -26;
            int topOff = 36;
            int bottOff = -2;
            int xmain = RenderLoc.locToX(renderLocation, leftOff, rightOff);
            int ymain = RenderLoc.locToY(renderLocation, topOff, bottOff);
            ModCyclic.proxy.renderItemOnScreen(current, xmain, ymain);
        }
    }

    private class SpellHud {
        private int ymain = 6;
        private int xmain;

        private SpellHud() {
        }

        @SideOnly(value=Side.CLIENT)
        public void drawSpellWheel(ItemStack wand) {
            if (!(wand.func_77973_b() instanceof ItemCyclicWand)) {
                return;
            }
            int leftOff = 8;
            int rightOff = -26;
            int topOff = 0;
            int bottOff = -38;
            this.xmain = RenderLoc.locToX(renderLocation, leftOff, rightOff);
            this.ymain = RenderLoc.locToY(renderLocation, topOff, bottOff);
            EntityPlayer player = ModCyclic.proxy.getClientPlayer();
            if (SpellRegistry.getSpellbook(wand) == null || SpellRegistry.getSpellbook(wand).size() <= 1) {
                return;
            }
            ISpell spellCurrent = UtilSpellCaster.getPlayerCurrentISpell(player);
            this.drawCurrentSpell(player, spellCurrent);
            this.drawNextSpells(player, spellCurrent);
            this.drawPrevSpells(player, spellCurrent);
        }

        private void drawCurrentSpell(EntityPlayer player, ISpell spellCurrent) {
            UtilTextureRender.drawTextureSquare(spellCurrent.getIconDisplay(), this.xmain, this.ymain, 16);
        }

        private void drawPrevSpells(EntityPlayer player, ISpell spellCurrent) {
            ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
            ISpell prev = SpellRegistry.prev(wand, spellCurrent);
            if (prev != null) {
                int x = this.xmain + 9;
                int y = this.ymain + 16;
                int dim = 8;
                UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x, y, dim);
                prev = SpellRegistry.prev(wand, prev);
                if (prev != null) {
                    UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x += 5, y += 14, dim -= 2);
                    prev = SpellRegistry.prev(wand, prev);
                    if (prev != null) {
                        UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x += 3, y += 10, dim -= 2);
                        prev = SpellRegistry.prev(wand, prev);
                        if (prev != null) {
                            UtilTextureRender.drawTextureSquare(prev.getIconDisplay(), x += 2, y += 10, --dim);
                        }
                    }
                }
            }
        }

        private void drawNextSpells(EntityPlayer player, ISpell spellCurrent) {
            ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
            ISpell next = SpellRegistry.next(wand, spellCurrent);
            if (next != null) {
                int x = this.xmain - 5;
                int y = this.ymain + 16;
                int dim = 8;
                UtilTextureRender.drawTextureSquare(next.getIconDisplay(), x, y, dim);
                ISpell next2 = SpellRegistry.next(wand, next);
                if (next2 != null) {
                    UtilTextureRender.drawTextureSquare(next2.getIconDisplay(), x -= 2, y += 14, dim -= 2);
                    ISpell next3 = SpellRegistry.next(wand, next2);
                    if (next3 != null) {
                        UtilTextureRender.drawTextureSquare(next3.getIconDisplay(), x -= 2, y += 10, dim -= 2);
                        ISpell next4 = SpellRegistry.next(wand, next3);
                        if (next4 != null) {
                            UtilTextureRender.drawTextureSquare(next4.getIconDisplay(), x -= 2, y += 10, --dim);
                        }
                    }
                }
            }
        }
    }

    public static enum RenderLoc {
        TOPLEFT,
        TOPRIGHT,
        BOTTOMLEFT,
        BOTTOMRIGHT;

        private static final int yPadding = 6;
        private static final int xPadding = 6;
        private static final int spellSize = 16;

        @SideOnly(value=Side.CLIENT)
        public static int locToX(RenderLoc loc, int leftOffset, int rightOffset) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            switch (loc) {
                case BOTTOMLEFT: 
                case TOPLEFT: {
                    return 6 + leftOffset;
                }
                case BOTTOMRIGHT: 
                case TOPRIGHT: {
                    return res.func_78326_a() - 6 + rightOffset;
                }
            }
            return 0;
        }

        @SideOnly(value=Side.CLIENT)
        public static int locToY(RenderLoc loc, int topOffset, int bottomOffset) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            switch (renderLocation) {
                case BOTTOMLEFT: 
                case BOTTOMRIGHT: {
                    return res.func_78328_b() - 16 - 6 + bottomOffset;
                }
                case TOPLEFT: 
                case TOPRIGHT: {
                    return 6 + topOffset;
                }
            }
            return 0;
        }
    }
}

