/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SoulstoneItem
extends BaseItem
implements IHasRecipe,
IContent {
    private static final float HEALTH_AFTER_TRIGGER = 6.0f;
    private boolean enabled;

    public SoulstoneItem() {
        this.func_77625_d(1);
    }

    @Override
    public String getContentName() {
        return "soulstone";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName());
        ModCyclic.instance.events.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("Soulstone", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDamageEvent(LivingDamageEvent event) {
        float currentHealth = event.getEntityLiving().func_110139_bj() + event.getEntityLiving().func_110143_aJ();
        if (currentHealth - event.getAmount() <= 0.0f && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof SoulstoneItem)) continue;
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                player.func_70606_j(6.0f);
                this.applyPotions(player);
                UtilSound.playSound(player, SoundEvents.field_187561_bM);
                UtilChat.addChatMessage(player, event.getEntityLiving().func_70005_c_() + UtilChat.lang("item.soulstone.used"));
                event.setCanceled(true);
                break;
            }
        }
    }

    private void applyPotions(EntityPlayer p) {
        int time = 600;
        p.func_70690_d(new PotionEffect(MobEffects.field_76426_n, time));
        time = 1200;
        p.func_70690_d(new PotionEffect(MobEffects.field_76429_m, time));
        p.func_70690_d(new PotionEffect(MobEffects.field_76444_x, time, 4));
        time = 12000;
        p.func_70690_d(new PotionEffect(MobEffects.field_189112_A, time));
        p.func_70690_d(new PotionEffect(MobEffects.field_76437_t, time, 1));
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " a ", "bsc", " d ", Character.valueOf('s'), "netherStar", Character.valueOf('a'), Items.field_151153_ao, Character.valueOf('b'), Items.field_151170_bI, Character.valueOf('c'), Blocks.field_185767_cT, Character.valueOf('d'), "gemEmerald");
    }
}

