/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.findspawner;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItemProjectile;
import com.lothrazar.cyclicmagic.item.findspawner.EntityDungeonEye;
import com.lothrazar.cyclicmagic.registry.EntityProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemProjectileDungeon
extends BaseItemProjectile
implements IHasRecipe,
IContent {
    private static final int COOLDOWN = 10;
    private static int DUNGEONRADIUS = 64;
    private boolean USE_THREADING;
    private boolean enabled;

    public ItemProjectileDungeon() {
        this.func_77656_e(1000);
        this.func_77625_d(1);
    }

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, ItemStack held, double x, double y, double z) {
        return new EntityDungeonEye(world, x, y, z);
    }

    @Override
    public String getContentName() {
        return "ender_dungeon";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEMTHROW);
        EntityProjectileRegistry.registerModEntity(EntityDungeonEye.class, "dungeonbolt", 1006);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnderDungeonFinder", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
        DUNGEONRADIUS = config.getInt("Ender Dungeon Radius", "cyclicmagic.items", 64, 8, 128, "Search radius of Spawner Seeker");
        this.USE_THREADING = config.getBoolean("Ender Threading", "cyclicmagic.items", true, "If true, this item will do the searching on a new thread, and then come back to the projectile when found and end the thread.  Set to false to completely disable threading if you have any weird issues or false results, but be aware that setting to false will cause clientside lag on every use");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)this), " sp", " ws", "w  ", Character.valueOf('w'), "cropNetherWart", Character.valueOf('s'), new ItemStack(Blocks.field_150341_Y), Character.valueOf('p'), "enderpearl");
    }

    @Override
    public void onItemThrow(ItemStack held, World world, final EntityPlayer player, EnumHand hand) {
        UtilEntity.setCooldownItem(player, held.func_77973_b(), 10);
        UtilItemStack.damageItem(player, held);
        final EntityDungeonEye entityendereye = new EntityDungeonEye(world, (EntityLivingBase)player);
        this.doThrow(world, player, hand, entityendereye, 0.5f);
        if (this.USE_THREADING) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ItemProjectileDungeon.this.findTargetLocation(player, entityendereye);
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else {
            this.findTargetLocation(player, entityendereye);
        }
    }

    private void findTargetLocation(EntityPlayer player, EntityDungeonEye entityendereye) {
        if (entityendereye == null || entityendereye.field_70128_L) {
            return;
        }
        BlockPos blockpos = UtilWorld.findClosestBlock(player, Blocks.field_150474_ac, DUNGEONRADIUS);
        if (blockpos == null) {
            entityendereye.kill();
            UtilChat.sendStatusMessage(player, UtilChat.lang("item.ender_dungeon.notfound") + " " + DUNGEONRADIUS);
        } else {
            entityendereye.moveTowards(blockpos);
        }
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.dungeonfinder;
    }
}

