/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.locationgps;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.data.IRenderOutline;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItem;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemLocationGps
extends BaseItem
implements IHasRecipe,
IContent,
IRenderOutline {
    private static final String NBT_SIDE = "side";
    private static final String NBT_DIM = "dim";
    private boolean enabled;

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        player.func_184609_a(hand);
        UtilNBT.setItemStackBlockPos(held, pos);
        UtilNBT.setItemStackNBTVal(held, NBT_DIM, player.field_71093_bK);
        UtilNBT.setItemStackNBTVal(held, NBT_SIDE, side.ordinal());
        UtilNBT.setItemStackNBTVal(held, "sidefacing", player.func_174811_aO().ordinal());
        UtilChat.sendStatusMessage(player, UtilChat.lang("item.location.saved") + UtilChat.blockPosToString(pos));
        held.func_77978_p().func_74776_a("hitx", hitX);
        held.func_77978_p().func_74776_a("hity", hitY);
        held.func_77978_p().func_74776_a("hitz", hitZ);
        return EnumActionResult.SUCCESS;
    }

    public static BlockPosDim getPosition(ItemStack item) {
        BlockPos p = UtilNBT.getItemStackBlockPos(item);
        if (p == null) {
            return null;
        }
        BlockPosDim dim = new BlockPosDim(0, p, UtilNBT.getItemStackNBTVal(item, NBT_DIM), "");
        try {
            if (item.func_77978_p().func_74764_b("sidefacing")) {
                dim.setSidePlayerFacing(EnumFacing.values()[UtilNBT.getItemStackNBTVal(item, "sidefacing")]);
            }
            if (item.func_77978_p().func_74764_b(NBT_SIDE)) {
                dim.setSide(EnumFacing.values()[UtilNBT.getItemStackNBTVal(item, NBT_SIDE)]);
            }
            if (item.func_77978_p().func_74764_b("hitx")) {
                NBTTagCompound tag = item.func_77978_p();
                Vec3d vec = new Vec3d((double)tag.func_74760_g("hitx"), (double)tag.func_74760_g("hity"), (double)tag.func_74760_g("hitz"));
                dim.setHitVec(vec);
            }
        }
        catch (Throwable e) {
            ModCyclic.logger.error("SIde error in GPS", e);
        }
        return dim;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            this.deletePosition(player, hand);
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        BlockPosDim dim = ItemLocationGps.getPosition(stack);
        if (dim != null) {
            tooltip.add(dim.toString());
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String side;
                if (dim.getSide() != null) {
                    side = "S: " + dim.getSide().toString().toUpperCase();
                    tooltip.add(TextFormatting.DARK_GRAY + side);
                }
                if (dim.getSidePlayerFacing() != null) {
                    side = "F: " + dim.getSidePlayerFacing().toString().toUpperCase();
                    tooltip.add(TextFormatting.DARK_GRAY + side);
                }
                if (dim.getHitVec() != null) {
                    tooltip.add(TextFormatting.DARK_GRAY + "H: " + dim.getHitVec().toString());
                }
            }
        } else {
            super.func_77624_a(stack, player, tooltip, advanced);
        }
    }

    private void deletePosition(EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        held.func_77982_d(null);
        UtilChat.sendStatusMessage(player, UtilChat.lang("item.location.saved") + "---");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " o ", " s ", " r ", Character.valueOf('o'), "dyeLightBlue", Character.valueOf('s'), Items.field_151121_aF, Character.valueOf('r'), "stickWood");
    }

    @Override
    public String getContentName() {
        return "card_location";
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.items", true, " Set false to delete - requires restart  WARNING disabling this may cause other blocks to not function (wireless nodes)");
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEM);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public int[] getRgb() {
        return new int[]{0, 30, 150};
    }

    @Override
    public Set<BlockPos> renderOutline(World world, ItemStack heldItem, RayTraceResult mouseOver) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        BlockPosDim dim = ItemLocationGps.getPosition(heldItem);
        if (dim != null && dim.toBlockPos() != null && world.field_73011_w.getDimension() == dim.getDimension()) {
            set.add(dim.toBlockPos());
        }
        return set;
    }
}

