/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.random;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.random.ItemRandomizer;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRandomize
implements IMessage,
IMessageHandler<PacketRandomize, IMessage> {
    private BlockPos pos;
    private ItemRandomizer.ActionType actionType;
    private EnumFacing side;

    public PacketRandomize() {
    }

    public PacketRandomize(BlockPos mouseover, EnumFacing s, ItemRandomizer.ActionType t) {
        this.pos = mouseover;
        this.actionType = t;
        this.side = s;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        int s = tags.func_74762_e("s");
        this.side = EnumFacing.values()[s];
        int t = tags.func_74762_e("t");
        this.actionType = ItemRandomizer.ActionType.values()[t];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.actionType.ordinal());
        tags.func_74768_a("s", this.side.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketRandomize message, final MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
            thread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketRandomize.runAction(message, ctx);
                }
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAction(PacketRandomize message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.func_130014_f_();
        List<BlockPos> places = PacketRandomize.getPlaces(message.pos, message.side, message.actionType);
        ArrayList<BlockPos> rpos = new ArrayList<BlockPos>();
        ArrayList<IBlockState> rstates = new ArrayList<IBlockState>();
        IBlockState stateHere = null;
        for (BlockPos p : places) {
            stateHere = world.func_180495_p(p);
            if (stateHere.func_177230_c().func_176195_g(stateHere, world, p) < 0.0f || stateHere == null || world.func_175625_s(p) != null || world.func_175623_d(p) || stateHere.func_185904_a().func_76224_d()) continue;
            rpos.add(p);
            rstates.add(stateHere);
        }
        Collections.shuffle(rpos, world.field_73012_v);
        ArrayList<BlockPos> arrayList = rpos;
        synchronized (arrayList) {
            for (int i = 0; i < rpos.size(); ++i) {
                BlockPos swapPos = (BlockPos)rpos.get(i);
                IBlockState swapState = (IBlockState)rstates.get(i);
                world.func_175655_b(swapPos, false);
                UtilPlaceBlocks.placeStateSafe(world, (EntityPlayer)player, swapPos, swapState, false);
            }
        }
    }

    static List<BlockPos> getPlaces(BlockPos pos, EnumFacing side, ItemRandomizer.ActionType actionType) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n();
        int yMin = pos.func_177956_o();
        int zMin = pos.func_177952_p();
        int xMax = pos.func_177958_n();
        int yMax = pos.func_177956_o();
        int zMax = pos.func_177952_p();
        boolean isVertical = side == EnumFacing.UP || side == EnumFacing.DOWN;
        int offsetRadius = 0;
        switch (actionType) {
            case X3: {
                offsetRadius = 1;
                break;
            }
            case X5: {
                offsetRadius = 2;
                break;
            }
            case X7: {
                offsetRadius = 3;
                break;
            }
            case X9: {
                offsetRadius = 4;
                break;
            }
        }
        if (offsetRadius > 0) {
            if (isVertical) {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                zMin -= offsetRadius;
                zMax += offsetRadius;
            } else if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                zMin -= offsetRadius;
                zMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            } else {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            }
            places = UtilWorld.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        return places;
    }
}

