/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class UtilNBT {
    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static String posToStringCSV(BlockPos position) {
        if (position == null) {
            return "";
        }
        return position.func_177958_n() + "," + position.func_177956_o() + "," + position.func_177952_p();
    }

    public static void setTagBlockPos(NBTTagCompound item, BlockPos pos) {
        if (pos == null) {
            return;
        }
        item.func_74768_a("xpos", pos.func_177958_n());
        item.func_74768_a("ypos", pos.func_177956_o());
        item.func_74768_a("zpos", pos.func_177952_p());
    }

    public static BlockPos getTagBlockPos(NBTTagCompound item) {
        if (item == null || !item.func_74764_b("xpos")) {
            return null;
        }
        return new BlockPos(item.func_74762_e("xpos"), item.func_74762_e("ypos"), item.func_74762_e("zpos"));
    }

    public static void setItemStackBlockPos(ItemStack item, BlockPos pos) {
        if (pos == null) {
            return;
        }
        UtilNBT.setItemStackNBTVal(item, "xpos", pos.func_177958_n());
        UtilNBT.setItemStackNBTVal(item, "ypos", pos.func_177956_o());
        UtilNBT.setItemStackNBTVal(item, "zpos", pos.func_177952_p());
    }

    public static BlockPos getItemStackBlockPos(ItemStack item) {
        if (item.func_190926_b() || item.func_77978_p() == null || !item.func_77978_p().func_74764_b("xpos")) {
            return null;
        }
        return new BlockPos(UtilNBT.getItemStackNBTVal(item, "xpos"), UtilNBT.getItemStackNBTVal(item, "ypos"), UtilNBT.getItemStackNBTVal(item, "zpos"));
    }

    public static void setItemStackNBTVal(ItemStack item, String prop, int value) {
        if (item.func_190926_b()) {
            return;
        }
        UtilNBT.getItemStackNBT(item).func_74768_a(prop, value);
    }

    public static void setItemStackNBTVal(ItemStack item, String prop, String value) {
        if (item.func_190926_b()) {
            return;
        }
        UtilNBT.getItemStackNBT(item).func_74778_a(prop, value);
    }

    public static int getItemStackNBTVal(ItemStack held, String prop) {
        if (held.func_190926_b()) {
            return 0;
        }
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(prop)) {
            return 0;
        }
        return tags.func_74762_e(prop);
    }

    public static String getItemStackDisplayInteger(ItemStack held, String prop) {
        if (held.func_190926_b()) {
            return "";
        }
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(prop)) {
            return "";
        }
        return tags.func_74762_e(prop) + "";
    }

    public static NBTTagCompound getItemStackNBT(ItemStack held) {
        if (held.func_77978_p() == null) {
            held.func_77982_d(new NBTTagCompound());
        }
        return held.func_77978_p();
    }

    public static BlockPos stringCSVToBlockPos(String csv) {
        String[] spl = csv.split(",");
        BlockPos p = null;
        try {
            if (spl != null && spl.length == 3 && spl[0] != "") {
                p = new BlockPos(Integer.parseInt(spl[0]), Integer.parseInt(spl[1]), Integer.parseInt(spl[2]));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return p;
    }

    public static void incrementPlayerIntegerNBT(EntityPlayer player, String prop, int inc) {
        int prev = player.getEntityData().func_74762_e(prop);
        player.getEntityData().func_74768_a(prop, prev += inc);
    }

    public static void writeTagsToInventory(IInventory invo, NBTTagCompound tags, String key) {
        NBTTagList items = tags.func_150295_c(key, (int)tags.func_74732_a());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            ItemStack stack = UtilNBT.itemFromNBT(item);
            int slot = item.func_74762_e("slot");
            invo.func_70299_a(slot, stack);
        }
    }

    public static NBTTagCompound writeInventoryToTag(IInventory invo, NBTTagCompound returnTag, String key) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < invo.func_70302_i_(); ++i) {
            ItemStack chestItem = invo.func_70301_a(i);
            if (chestItem.func_190926_b() || chestItem.func_190916_E() == 0) continue;
            NBTTagCompound itemTag = chestItem.func_77955_b(new NBTTagCompound());
            itemTag.func_74768_a("slot", i);
            nbttaglist.func_74742_a((NBTBase)itemTag);
            invo.func_70299_a(i, ItemStack.field_190927_a);
        }
        returnTag.func_74782_a(key, (NBTBase)nbttaglist);
        return returnTag;
    }

    public static NBTTagCompound writeInventoryToNewTag(IInventory invo, String key) {
        return UtilNBT.writeInventoryToTag(invo, new NBTTagCompound(), key);
    }

    public static int countItemsFromNBT(NBTTagCompound tags, String key) {
        if (tags == null) {
            return 0;
        }
        NBTTagList items = tags.func_150295_c(key, (int)tags.func_74732_a());
        if (items == null) {
            return 0;
        }
        return items.func_74745_c();
    }

    public static ArrayList<ItemStack> readItemsFromNBT(NBTTagCompound tags, String key) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        NBTTagList items = tags.func_150295_c(key, (int)tags.func_74732_a());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            list.add(UtilNBT.itemFromNBT(item));
        }
        return list;
    }

    public static ItemStack enchantItem(Item item, Enchantment ench, short level) {
        ItemStack stack = new ItemStack(item);
        stack.func_77966_a(ench, (int)level);
        return stack;
    }

    public static ItemStack buildEnchantedBook(Enchantment ench, short level) {
        ItemStack stack = new ItemStack(Items.field_151134_bR);
        ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(ench, (int)level));
        return stack;
    }

    public static ItemStack buildEnchantedNametag(String customNameTag) {
        ItemStack nameTag = new ItemStack(Items.field_151057_cb, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", customNameTag);
        nbt.func_74782_a("display", (NBTBase)display);
        nbt.func_74768_a("RepairCost", 1);
        nameTag.func_77982_d(nbt);
        return nameTag;
    }

    public static ItemStack itemFromNBT(NBTTagCompound tag) {
        return new ItemStack(tag);
    }

    public static ItemStack buildNamedPlayerSkull(EntityPlayer player) {
        return UtilNBT.buildNamedPlayerSkull(player.getDisplayNameString());
    }

    public static ItemStack buildNamedPlayerSkull(String displayNameString) {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74778_a("SkullOwner", displayNameString);
        return UtilNBT.buildSkullFromTag(t);
    }

    public static ItemStack buildSkullFromTag(NBTTagCompound player) {
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
        skull.func_77982_d(player);
        return skull;
    }

    public static NBTTagCompound buildCustomSkullTag(String displayName, String textureData) {
        NBTTagCompound base = new NBTTagCompound();
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", displayName);
        base.func_74782_a("display", (NBTBase)display);
        NBTTagCompound skullOwner = new NBTTagCompound();
        skullOwner.func_74778_a("Id", UUID.randomUUID().toString());
        NBTTagCompound props = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        NBTTagCompound textureValue = new NBTTagCompound();
        textureValue.func_74778_a("Value", textureData);
        list.func_74742_a((NBTBase)textureValue);
        props.func_74782_a("textures", (NBTBase)list);
        skullOwner.func_74782_a("Properties", (NBTBase)props);
        base.func_74782_a("SkullOwner", (NBTBase)skullOwner);
        return base;
    }

    public static void setEntityBoolean(Entity entity, String string) {
        UtilNBT.setEntityBoolean(entity, string, true);
    }

    public static void setEntityBoolean(Entity entityevokerfangs, String string, boolean bIn) {
        entityevokerfangs.getEntityData().func_74757_a(string, bIn);
    }

    public static void setEntityInt(Entity entityevokerfangs, String string, int bIn) {
        entityevokerfangs.getEntityData().func_74768_a(string, bIn);
    }

    public static int getEntityInt(Entity entityevokerfangs, String string) {
        return entityevokerfangs.getEntityData().func_74762_e(string);
    }

    public static boolean getEntityBoolean(Entity entityevokerfangs, String string) {
        return entityevokerfangs.getEntityData().func_74767_n(string);
    }

    public static boolean hasTagCompund(ItemStack held) {
        return held.func_77942_o() && held.func_77978_p().func_186856_d() > 0;
    }

    public static boolean stacksTagsEqual(ItemStack main, ItemStack second) {
        if (!main.func_77942_o() && !second.func_77942_o()) {
            return true;
        }
        if (main.func_77942_o() && second.func_77942_o()) {
            return main.func_77978_p().equals((Object)second.func_77978_p());
        }
        return false;
    }
}

