/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.client.renderer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.DyeUtils;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.TorchmasterConfig;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TorchVolumeRenderHandler {
    private static HashMap<BlockPos, DyeColor> visualizedTorches = new HashMap();

    public static void toggle(BlockPos pos, DyeColor color) {
        DyeColor r = visualizedTorches.remove(pos);
        if (r == null) {
            visualizedTorches.put(pos, color);
        }
    }

    public static void remove(BlockPos pos) {
        visualizedTorches.remove(pos);
    }

    public static void clearList() {
        visualizedTorches.clear();
    }

    public static void onGlobalTick(World world) {
        visualizedTorches.entrySet().removeIf(torch -> !world.func_175667_e((BlockPos)torch.getKey()) || world.func_180495_p((BlockPos)torch.getKey()).func_177230_c() != ModBlocks.getMegaTorch());
    }

    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent event) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GlStateManager.func_187441_d((float)2.0f);
        double xD = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double yD = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double zD = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179137_b((double)(-xD), (double)(-yD), (double)(-zD));
        GlStateManager.func_187409_d((int)1028, (int)6913);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        BufferBuilder vbo = Tessellator.func_178181_a().func_178180_c();
        int segmentCount = (int)((float)(TorchmasterConfig.MegaTorchRange * 2 + 1) / TorchmasterConfig.TorchVisualizerSegmentationFactor);
        for (Map.Entry<BlockPos, DyeColor> torch : visualizedTorches.entrySet()) {
            BlockPos pos = torch.getKey();
            DyeColor color = torch.getValue();
            vbo.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            TorchVolumeRenderHandler.CreateSegmentedCube(vbo, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), TorchmasterConfig.MegaTorchRange, color, segmentCount);
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_187409_d((int)1028, (int)6914);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void CreateSegmentedCube(BufferBuilder vbo, float x, float y, float z, int torchRange, DyeColor color, int segmentCount) {
        float f;
        float o = (float)torchRange + 0.5f + 0.005f;
        float cx = x + 0.5f;
        float cy = y + 0.5f;
        float cz = z + 0.5f;
        float segmentSize = ((float)torchRange * 2.0f + 1.0f) / (float)segmentCount;
        GlStateManager.func_187441_d((float)1.0f);
        for (f = -o; f < o; f += segmentSize) {
            vbo.func_181662_b((double)(cx + f), (double)(cy + o), (double)(cz - o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + f), (double)(cy + o), (double)(cz + o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + f), (double)(cy - o), (double)(cz + o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + f), (double)(cy - o), (double)(cz - o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + f), (double)(cy + o), (double)(cz - o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
        }
        for (f = -o; f < o; f += segmentSize) {
            vbo.func_181662_b((double)(cx - o), (double)(cy + o), (double)(cz + f)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + o), (double)(cy + o), (double)(cz + f)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + o), (double)(cy - o), (double)(cz + f)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx - o), (double)(cy - o), (double)(cz + f)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx - o), (double)(cy + o), (double)(cz + f)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
        }
        for (f = -o; f < o; f += segmentSize) {
            vbo.func_181662_b((double)(cx - o), (double)(cy + f), (double)(cz + o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + o), (double)(cy + f), (double)(cz + o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx + o), (double)(cy + f), (double)(cz - o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx - o), (double)(cy + f), (double)(cz - o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            vbo.func_181662_b((double)(cx - o), (double)(cy + f), (double)(cz + o)).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
        }
    }

    public static class DyeColor {
        float r;
        float g;
        float b;
        private static DyeColor[] colors = (DyeColor[])Arrays.stream(ItemDye.field_150922_c).mapToObj(DyeColor::new).toArray(DyeColor[]::new);

        public DyeColor(int color) {
            this.r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            this.g = (float)((color & 0xFF00) >> 8) / 255.0f;
            this.b = (float)(color & 0xFF) / 255.0f;
        }

        public static DyeColor FromItemStack(ItemStack stack) {
            int meta = DyeUtils.rawDyeDamageFromStack((ItemStack)stack);
            if (meta < 0 || meta > 15) {
                return null;
            }
            return colors[meta];
        }
    }
}

