/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator.animations;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.IAnimatable;
import com.teamwizardry.librarianlib.features.animator.Lerper;
import com.teamwizardry.librarianlib.features.animator.LerperHandler;
import com.teamwizardry.librarianlib.features.animator.StaticAnimatableProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003B\u001d\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/teamwizardry/librarianlib/features/animator/animations/StaticAnimation;", "T", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "", "target", "Ljava/lang/Class;", "property", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;", "(Lcom/teamwizardry/librarianlib/features/animator/IAnimatable;)V", "easing", "Lcom/teamwizardry/librarianlib/features/animator/Easing;", "getEasing", "()Lcom/teamwizardry/librarianlib/features/animator/Easing;", "setEasing", "(Lcom/teamwizardry/librarianlib/features/animator/Easing;)V", "from", "getFrom", "()Ljava/lang/Object;", "setFrom", "(Ljava/lang/Object;)V", "lerper", "Lcom/teamwizardry/librarianlib/features/animator/Lerper;", "to", "getTo", "setTo", "update", "", "time", "", "librarianlib-1.12.2"})
public final class StaticAnimation<T>
extends Animation {
    @NotNull
    private Object from;
    @NotNull
    private Object to;
    @NotNull
    private Easing easing;
    private Lerper<Object> lerper;

    @NotNull
    public final Object getFrom() {
        return this.from;
    }

    public final void setFrom(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, "<set-?>");
        this.from = object;
    }

    @NotNull
    public final Object getTo() {
        return this.to;
    }

    public final void setTo(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull(object, "<set-?>");
        this.to = object;
    }

    @NotNull
    public final Easing getEasing() {
        return this.easing;
    }

    public final void setEasing(@NotNull Easing easing) {
        Intrinsics.checkParameterIsNotNull(easing, "<set-?>");
        this.easing = easing;
    }

    @Override
    public void update(float time) {
        float progress2 = this.easing.invoke(this.timeFraction(time));
        Object object = this.lerper.lerp(this.from, this.to, progress2);
        this.getProperty().set(this.getTarget(), object);
    }

    public StaticAnimation(@NotNull IAnimatable property) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        super(null, property);
        this.from = property.get(null);
        this.to = property.get(null);
        this.easing = Easing.linear;
        this.lerper = LerperHandler.INSTANCE.getLerperOrError(property.getType());
    }

    public StaticAnimation(@NotNull Class<T> target, @NotNull String property) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(property, "property");
        this(StaticAnimatableProperty.Companion.get(target, property));
    }
}

