/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.AllocationTracker;
import com.teamwizardry.librarianlib.features.math.Margins2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0004\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 O2\u00020\u0001:\u0001OB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u0016\u00104\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003J\u0011\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0000H\u0086\u0002J\u0011\u00109\u001a\u00020:2\u0006\u00108\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010<\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0003J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0000J\u000e\u0010?\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0007J\b\u0010B\u001a\u00020\u0013H\u0016J\u0011\u0010C\u001a\u00020\u00002\u0006\u00105\u001a\u000206H\u0086\u0002J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0003J&\u0010>\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007J)\u0010>\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020D2\u0006\u0010!\u001a\u00020D2\u0006\u0010\u0019\u001a\u00020D2\u0006\u0010\u001b\u001a\u00020DH\u0086\bJ\u0011\u0010E\u001a\u00020\u00002\u0006\u00105\u001a\u000206H\u0086\u0002J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0007J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0007J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0007J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0007J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0007J\u000e\u0010L\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\b\u0010M\u001a\u00020NH\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010\rR\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\rR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0018R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u0011\u0010&\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0011R\u0011\u0010(\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\rR\u0011\u0010+\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0011R\u0011\u0010-\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\rR\u0011\u00100\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0011\u00102\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0015\u00a8\u0006P"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "", "pos", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "size", "(Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;)V", "x", "", "y", "width", "height", "(DDDD)V", "getHeight", "()D", "heightf", "", "getHeightf", "()F", "heighti", "", "getHeighti", "()I", "max", "getMax", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "maxX", "getMaxX", "maxY", "getMaxY", "min", "getMin", "minX", "getMinX", "minY", "getMinY", "getPos", "getSize", "getWidth", "widthf", "getWidthf", "widthi", "getWidthi", "getX", "xf", "getXf", "xi", "getXi", "getY", "yf", "getYf", "yi", "getYi", "add", "margins", "Lcom/teamwizardry/librarianlib/features/math/Margins2d;", "clamp", "point", "contains", "", "other", "equals", "expand", "offset", "expandToFit", "rect", "grow", "hashCode", "minus", "", "plus", "setHeight", "value", "setWidth", "setX", "setY", "shrink", "subtract", "toString", "", "Companion", "librarianlib-1.12.2"})
public final class Rect2d {
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    @JvmField
    @NotNull
    public static final Rect2d ZERO;
    @JvmField
    @NotNull
    public static final Rect2d INFINITE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getMin() {
        void x$iv;
        double d = this.x;
        double y$iv = this.y;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getMax() {
        void x$iv;
        double d = this.x + this.width;
        double y$iv = this.y + this.height;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    public final double getMinX() {
        return this.x;
    }

    public final double getMinY() {
        return this.y;
    }

    public final double getMaxX() {
        return this.x + this.width;
    }

    public final double getMaxY() {
        return this.y + this.height;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getPos() {
        void x$iv;
        double d = this.x;
        double y$iv = this.y;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getSize() {
        void x$iv;
        double d = this.width;
        double y$iv = this.height;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    public final float getXf() {
        return (float)this.x;
    }

    public final float getYf() {
        return (float)this.y;
    }

    public final float getWidthf() {
        return (float)this.width;
    }

    public final float getHeightf() {
        return (float)this.height;
    }

    public final int getXi() {
        return (int)this.x;
    }

    public final int getYi() {
        return (int)this.y;
    }

    public final int getWidthi() {
        return (int)this.width;
    }

    public final int getHeighti() {
        return (int)this.height;
    }

    @NotNull
    public final Rect2d setX(double value) {
        return new Rect2d(value, this.y, this.width, this.height);
    }

    @NotNull
    public final Rect2d setY(double value) {
        return new Rect2d(this.x, value, this.width, this.height);
    }

    @NotNull
    public final Rect2d setWidth(double value) {
        return new Rect2d(this.x, this.y, value, this.height);
    }

    @NotNull
    public final Rect2d setHeight(double value) {
        return new Rect2d(this.x, this.y, this.width, value);
    }

    @NotNull
    public final Rect2d expandToFit(@NotNull Vec2d point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        double newX = Math.min(this.x, point.getX());
        double newY = Math.min(this.y, point.getY());
        return new Rect2d(newX, newY, Math.max(this.x + this.width, point.getX()) - newX, Math.max(this.y + this.width, point.getY()) - newY);
    }

    @NotNull
    public final Rect2d expandToFit(@NotNull Rect2d rect) {
        Intrinsics.checkParameterIsNotNull(rect, "rect");
        return new Rect2d(Vec2d.Companion.min(rect.getMin(), this.getMin()), Vec2d.Companion.max(rect.getMax(), this.getMax()).minus(Vec2d.Companion.min(rect.getMin(), this.getMin())));
    }

    public final boolean contains(@NotNull Vec2d point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        return point.getX() >= this.getMinX() && point.getY() >= this.getMinY() && point.getX() < this.getMaxX() && point.getY() < this.getMaxY();
    }

    public final boolean contains(@NotNull Rect2d other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return other.getMinX() >= this.getMinX() && other.getMinY() >= this.getMinY() && other.getMaxX() <= this.getMaxX() && other.getMaxY() <= this.getMaxY();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d clamp(@NotNull Vec2d point) {
        void y$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull(point, "point");
        if (this.contains(point)) {
            return point;
        }
        double d = CommonUtilMethods.clamp(point.getX(), this.getPos().getX(), this.getPos().getX() + this.getSize().getX());
        double d2 = CommonUtilMethods.clamp(point.getY(), this.getPos().getY(), this.getPos().getY() + this.getSize().getY());
        return Vec2d.Companion.getPooled((double)x$iv, (double)y$iv);
    }

    @NotNull
    public final Rect2d offset(@NotNull Vec2d offset) {
        Intrinsics.checkParameterIsNotNull(offset, "offset");
        return new Rect2d(this.getPos().plus(offset), this.getSize());
    }

    @NotNull
    public final Rect2d expand(@NotNull Vec2d offset) {
        Intrinsics.checkParameterIsNotNull(offset, "offset");
        return new Rect2d(this.getPos(), this.getSize().plus(offset));
    }

    @NotNull
    public final Rect2d grow(double offset) {
        double y$iv;
        double x$iv;
        double d = offset;
        double d2 = offset;
        Vec2d vec2d = this.getPos();
        Vec2d vec2d2 = Vec2d.Companion.getPooled(x$iv, y$iv);
        Vec2d vec2d3 = vec2d.minus(vec2d2);
        x$iv = offset * (double)2;
        y$iv = offset * (double)2;
        vec2d2 = this.getSize();
        vec2d = vec2d3;
        Vec2d vec2d4 = Vec2d.Companion.getPooled(x$iv, y$iv);
        Vec2d vec2d5 = vec2d2.plus(vec2d4);
        Vec2d vec2d6 = vec2d;
        return new Rect2d(vec2d6, vec2d5);
    }

    @NotNull
    public final Rect2d shrink(double offset) {
        double y$iv;
        double x$iv;
        double d = offset;
        double d2 = offset;
        Vec2d vec2d = this.getPos();
        Vec2d vec2d2 = Vec2d.Companion.getPooled(x$iv, y$iv);
        Vec2d vec2d3 = vec2d.plus(vec2d2);
        x$iv = offset * (double)2;
        y$iv = offset * (double)2;
        vec2d2 = this.getSize();
        vec2d = vec2d3;
        Vec2d vec2d4 = Vec2d.Companion.getPooled(x$iv, y$iv);
        Vec2d vec2d5 = vec2d2.minus(vec2d4);
        Vec2d vec2d6 = vec2d;
        return new Rect2d(vec2d6, vec2d5);
    }

    @NotNull
    public final Rect2d offset(@NotNull Number minX, @NotNull Number minY, @NotNull Number maxX, @NotNull Number maxY) {
        Intrinsics.checkParameterIsNotNull(minX, "minX");
        Intrinsics.checkParameterIsNotNull(minY, "minY");
        Intrinsics.checkParameterIsNotNull(maxX, "maxX");
        Intrinsics.checkParameterIsNotNull(maxY, "maxY");
        return this.offset(minX.doubleValue(), minY.doubleValue(), maxX.doubleValue(), maxY.doubleValue());
    }

    @NotNull
    public final Rect2d offset(double minX, double minY, double maxX, double maxY) {
        double y$iv;
        double x$iv;
        double d = minX;
        double d2 = minY;
        Vec2d vec2d = this.getPos();
        Vec2d vec2d2 = Vec2d.Companion.getPooled(x$iv, y$iv);
        Vec2d vec2d3 = vec2d.plus(vec2d2);
        x$iv = maxX - minX;
        y$iv = maxY - minY;
        vec2d2 = this.getSize();
        vec2d = vec2d3;
        Vec2d vec2d4 = Vec2d.Companion.getPooled(x$iv, y$iv);
        Vec2d vec2d5 = vec2d2.plus(vec2d4);
        Vec2d vec2d6 = vec2d;
        return new Rect2d(vec2d6, vec2d5);
    }

    @NotNull
    public final Rect2d add(@NotNull Vec2d pos2, @NotNull Vec2d size2) {
        Intrinsics.checkParameterIsNotNull(pos2, "pos");
        Intrinsics.checkParameterIsNotNull(size2, "size");
        return new Rect2d(this.getPos().plus(pos2), this.getSize().plus(size2));
    }

    @NotNull
    public final /* synthetic */ Rect2d plus(@NotNull Margins2d margins) {
        Intrinsics.checkParameterIsNotNull(margins, "margins");
        return this.add(margins);
    }

    @NotNull
    public final Rect2d add(@NotNull Margins2d margins) {
        Intrinsics.checkParameterIsNotNull(margins, "margins");
        return new Rect2d(this.x - margins.getLeft(), this.y - margins.getTop(), this.width + margins.getWidth(), this.height + margins.getHeight());
    }

    @NotNull
    public final /* synthetic */ Rect2d minus(@NotNull Margins2d margins) {
        Intrinsics.checkParameterIsNotNull(margins, "margins");
        return this.subtract(margins);
    }

    @NotNull
    public final Rect2d subtract(@NotNull Margins2d margins) {
        Intrinsics.checkParameterIsNotNull(margins, "margins");
        return new Rect2d(this.x + margins.getLeft(), this.y + margins.getTop(), this.width - margins.getWidth(), this.height - margins.getHeight());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.height);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        return this.x == ((Rect2d)other).x && this.y == ((Rect2d)other).y && this.width == ((Rect2d)other).width && this.height == ((Rect2d)other).height;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ',' + this.y + ',' + this.width + ',' + this.height + ')';
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public Rect2d(double x2, double y, double width, double height) {
        block0: {
            Object2IntMap<Rect2d> object2IntMap;
            this.x = x2;
            this.y = y;
            this.width = width;
            this.height = height;
            AllocationTracker allocationTracker = AllocationTracker.INSTANCE;
            long l = allocationTracker.getRect2dAllocations();
            allocationTracker.setRect2dAllocations(l + 1L);
            Object2IntMap<Rect2d> object2IntMap2 = AllocationTracker.INSTANCE.getRect2dAllocationStats();
            if (object2IntMap2 == null) break block0;
            Object2IntMap<Rect2d> stats = object2IntMap = object2IntMap2;
            Map map = stats;
            Rect2d rect2d = this;
            Integer n = stats.getInt(this) + 1;
            map.put(rect2d, n);
        }
    }

    public Rect2d(@NotNull Vec2d pos2, @NotNull Vec2d size2) {
        Intrinsics.checkParameterIsNotNull(pos2, "pos");
        Intrinsics.checkParameterIsNotNull(size2, "size");
        this(pos2.getX(), pos2.getY(), size2.getX(), size2.getY());
    }

    static {
        Companion = new Companion(null);
        ZERO = new Rect2d(0.0, 0.0, 0.0, 0.0);
        INFINITE = new Rect2d(DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY(), DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY(), DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Rect2d$Companion;", "", "()V", "INFINITE", "Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "ZERO", "librarianlib-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

