/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ByteMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2ByteMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatHash;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.IntConsumer;

public class Float2ByteOpenCustomHashMap
extends AbstractFloat2ByteMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient byte[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected FloatHash.Strategy strategy;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Float2ByteMap.FastEntrySet entries;
    protected transient FloatSet keys;
    protected transient ByteCollection values;

    public Float2ByteOpenCustomHashMap(int expected, float f, FloatHash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n + 1];
        this.value = new byte[this.n + 1];
    }

    public Float2ByteOpenCustomHashMap(int expected, FloatHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public Float2ByteOpenCustomHashMap(FloatHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Float2ByteOpenCustomHashMap(Map<? extends Float, ? extends Byte> m, float f, FloatHash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Float2ByteOpenCustomHashMap(Map<? extends Float, ? extends Byte> m, FloatHash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Float2ByteOpenCustomHashMap(Float2ByteMap m, float f, FloatHash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Float2ByteOpenCustomHashMap(Float2ByteMap m, FloatHash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Float2ByteOpenCustomHashMap(float[] k, byte[] v, float f, FloatHash.Strategy strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2ByteOpenCustomHashMap(float[] k, byte[] v, FloatHash.Strategy strategy) {
        this(k, v, 0.75f, strategy);
    }

    public FloatHash.Strategy strategy() {
        return this.strategy;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private byte removeEntry(int pos2) {
        byte oldValue = this.value[pos2];
        --this.size;
        this.shiftKeys(pos2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private byte removeNullEntry() {
        this.containsNullKey = false;
        byte oldValue = this.value[this.n];
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Byte> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int find(float k) {
        if (this.strategy.equals(k, 0.0f)) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        float[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos2];
        if (Float.floatToIntBits(curr) == 0) {
            return -(pos2 + 1);
        }
        if (this.strategy.equals(k, curr)) {
            return pos2;
        }
        do {
            if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) continue;
            return -(pos2 + 1);
        } while (!this.strategy.equals(k, curr));
        return pos2;
    }

    private void insert(int pos2, float k, byte v) {
        if (pos2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public byte put(float k, byte v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return this.defRetValue;
        }
        byte oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    private byte addToValue(int pos2, byte incr) {
        byte oldValue = this.value[pos2];
        this.value[pos2] = (byte)(oldValue + incr);
        return oldValue;
    }

    public byte addTo(float k, byte incr) {
        int pos2;
        if (this.strategy.equals(k, 0.0f)) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos2 = this.n;
            this.containsNullKey = true;
        } else {
            float[] key = this.key;
            pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
            float curr = key[pos2];
            if (Float.floatToIntBits(curr) != 0) {
                if (this.strategy.equals(curr, k)) {
                    return this.addToValue(pos2, incr);
                }
                while (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) {
                    if (!this.strategy.equals(curr, k)) continue;
                    return this.addToValue(pos2, incr);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = (byte)(this.defRetValue + incr);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos2) {
        float[] key = this.key;
        while (true) {
            float curr;
            int last = pos2;
            pos2 = last + 1 & this.mask;
            while (true) {
                if (Float.floatToIntBits(curr = key[pos2]) == 0) {
                    key[last] = 0.0f;
                    return;
                }
                int slot = HashCommon.mix(this.strategy.hashCode(curr)) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos2];
        }
    }

    @Override
    public byte remove(float k) {
        if (this.strategy.equals(k, 0.0f)) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        float[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos2];
        if (Float.floatToIntBits(curr) == 0) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k, curr)) {
            return this.removeEntry(pos2);
        }
        do {
            if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k, curr));
        return this.removeEntry(pos2);
    }

    @Override
    public byte get(float k) {
        if (this.strategy.equals(k, 0.0f)) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        float[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos2];
        if (Float.floatToIntBits(curr) == 0) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k, curr)) {
            return this.value[pos2];
        }
        do {
            if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k, curr));
        return this.value[pos2];
    }

    @Override
    public boolean containsKey(float k) {
        if (this.strategy.equals(k, 0.0f)) {
            return this.containsNullKey;
        }
        float[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos2];
        if (Float.floatToIntBits(curr) == 0) {
            return false;
        }
        if (this.strategy.equals(k, curr)) {
            return true;
        }
        do {
            if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (!this.strategy.equals(k, curr));
        return true;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        float[] key = this.key;
        if (this.containsNullKey && value[this.n] == v) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (Float.floatToIntBits(key[i]) == 0 || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getOrDefault(float k, byte defaultValue) {
        if (this.strategy.equals(k, 0.0f)) {
            return this.containsNullKey ? this.value[this.n] : defaultValue;
        }
        float[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos2];
        if (Float.floatToIntBits(curr) == 0) {
            return defaultValue;
        }
        if (this.strategy.equals(k, curr)) {
            return this.value[pos2];
        }
        do {
            if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) continue;
            return defaultValue;
        } while (!this.strategy.equals(k, curr));
        return this.value[pos2];
    }

    @Override
    public byte putIfAbsent(float k, byte v) {
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        this.insert(-pos2 - 1, k, v);
        return this.defRetValue;
    }

    @Override
    public boolean remove(float k, byte v) {
        if (this.strategy.equals(k, 0.0f)) {
            if (this.containsNullKey && v == this.value[this.n]) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        float[] key = this.key;
        int pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
        float curr = key[pos2];
        if (Float.floatToIntBits(curr) == 0) {
            return false;
        }
        if (this.strategy.equals(k, curr) && v == this.value[pos2]) {
            this.removeEntry(pos2);
            return true;
        }
        do {
            if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & this.mask]) != 0) continue;
            return false;
        } while (!this.strategy.equals(k, curr) || v != this.value[pos2]);
        this.removeEntry(pos2);
        return true;
    }

    @Override
    public boolean replace(float k, byte oldValue, byte v) {
        int pos2 = this.find(k);
        if (pos2 < 0 || oldValue != this.value[pos2]) {
            return false;
        }
        this.value[pos2] = v;
        return true;
    }

    @Override
    public byte replace(float k, byte v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            return this.defRetValue;
        }
        byte oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    @Override
    public byte computeIfAbsent(float k, DoubleToIntFunction mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        byte newValue = SafeMath.safeIntToByte(mappingFunction.applyAsInt(k));
        this.insert(-pos2 - 1, k, newValue);
        return newValue;
    }

    @Override
    public byte computeIfAbsentNullable(float k, DoubleFunction<? extends Byte> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        Byte newValue = mappingFunction.apply(k);
        if (newValue == null) {
            return this.defRetValue;
        }
        byte v = newValue;
        this.insert(-pos2 - 1, k, v);
        return v;
    }

    @Override
    public byte computeIfPresent(float k, BiFunction<? super Float, ? super Byte, ? extends Byte> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        if (pos2 < 0) {
            return this.defRetValue;
        }
        Byte newValue = remappingFunction.apply(Float.valueOf(k), (Byte)this.value[pos2]);
        if (newValue == null) {
            if (this.strategy.equals(k, 0.0f)) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos2);
            }
            return this.defRetValue;
        }
        this.value[pos2] = newValue;
        return this.value[pos2];
    }

    @Override
    public byte compute(float k, BiFunction<? super Float, ? super Byte, ? extends Byte> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        Byte newValue = remappingFunction.apply(Float.valueOf(k), pos2 >= 0 ? Byte.valueOf(this.value[pos2]) : null);
        if (newValue == null) {
            if (pos2 >= 0) {
                if (this.strategy.equals(k, 0.0f)) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(pos2);
                }
            }
            return this.defRetValue;
        }
        byte newVal = newValue;
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, newVal);
            return newVal;
        }
        this.value[pos2] = newVal;
        return this.value[pos2];
    }

    @Override
    public byte merge(float k, byte v, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return v;
        }
        Byte newValue = remappingFunction.apply((Byte)this.value[pos2], (Byte)v);
        if (newValue == null) {
            if (this.strategy.equals(k, 0.0f)) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos2);
            }
            return this.defRetValue;
        }
        this.value[pos2] = newValue;
        return this.value[pos2];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0.0f);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Float2ByteMap.FastEntrySet float2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                @Override
                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2ByteOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(byte v) {
                    return Float2ByteOpenCustomHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Float2ByteOpenCustomHashMap.this.clear();
                }

                @Override
                public void forEach(IntConsumer consumer) {
                    if (Float2ByteOpenCustomHashMap.this.containsNullKey) {
                        consumer.accept(Float2ByteOpenCustomHashMap.this.value[Float2ByteOpenCustomHashMap.this.n]);
                    }
                    int pos2 = Float2ByteOpenCustomHashMap.this.n;
                    while (pos2-- != 0) {
                        if (Float.floatToIntBits(Float2ByteOpenCustomHashMap.this.key[pos2]) == 0) continue;
                        consumer.accept(Float2ByteOpenCustomHashMap.this.value[pos2]);
                    }
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        float[] key = this.key;
        byte[] value = this.value;
        int mask = newN - 1;
        float[] newKey = new float[newN + 1];
        byte[] newValue = new byte[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (Float.floatToIntBits(key[--i]) == 0) {
            }
            int pos2 = HashCommon.mix(this.strategy.hashCode(key[i])) & mask;
            if (Float.floatToIntBits(newKey[pos2]) != 0) {
                while (Float.floatToIntBits(newKey[pos2 = pos2 + 1 & mask]) != 0) {
                }
            }
            newKey[pos2] = key[i];
            newValue[pos2] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Float2ByteOpenCustomHashMap clone() {
        Float2ByteOpenCustomHashMap c;
        try {
            c = (Float2ByteOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (float[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (Float.floatToIntBits(this.key[i]) == 0) {
                ++i;
            }
            t = this.strategy.hashCode(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        if (this.containsNullKey) {
            h += this.value[this.n];
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n + 1];
        float[] key = this.key;
        this.value = new byte[this.n + 1];
        byte[] value = this.value;
        int i = this.size;
        while (i-- != 0) {
            int pos2;
            float k = s.readFloat();
            byte v = s.readByte();
            if (this.strategy.equals(k, 0.0f)) {
                pos2 = this.n;
                this.containsNullKey = true;
            } else {
                pos2 = HashCommon.mix(this.strategy.hashCode(k)) & this.mask;
                while (Float.floatToIntBits(key[pos2]) != 0) {
                    pos2 = pos2 + 1 & this.mask;
                }
            }
            key[pos2] = k;
            value[pos2] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteIterator {
        @Override
        public byte nextByte() {
            return Float2ByteOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        @Override
        public FloatIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public void forEach(DoubleConsumer consumer) {
            if (Float2ByteOpenCustomHashMap.this.containsNullKey) {
                consumer.accept(Float2ByteOpenCustomHashMap.this.key[Float2ByteOpenCustomHashMap.this.n]);
            }
            int pos2 = Float2ByteOpenCustomHashMap.this.n;
            while (pos2-- != 0) {
                float k = Float2ByteOpenCustomHashMap.this.key[pos2];
                if (Float.floatToIntBits(k) == 0) continue;
                consumer.accept(k);
            }
        }

        @Override
        public int size() {
            return Float2ByteOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(float k) {
            return Float2ByteOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(float k) {
            int oldSize = Float2ByteOpenCustomHashMap.this.size;
            Float2ByteOpenCustomHashMap.this.remove(k);
            return Float2ByteOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2ByteOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Float2ByteOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Float2ByteMap.Entry>
    implements Float2ByteMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2ByteMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2ByteMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Float)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Byte)) {
                return false;
            }
            float k = ((Float)e.getKey()).floatValue();
            byte v = (Byte)e.getValue();
            if (Float2ByteOpenCustomHashMap.this.strategy.equals(k, 0.0f)) {
                return Float2ByteOpenCustomHashMap.this.containsNullKey && Float2ByteOpenCustomHashMap.this.value[Float2ByteOpenCustomHashMap.this.n] == v;
            }
            float[] key = Float2ByteOpenCustomHashMap.this.key;
            int pos2 = HashCommon.mix(Float2ByteOpenCustomHashMap.this.strategy.hashCode(k)) & Float2ByteOpenCustomHashMap.this.mask;
            float curr = key[pos2];
            if (Float.floatToIntBits(curr) == 0) {
                return false;
            }
            if (Float2ByteOpenCustomHashMap.this.strategy.equals(k, curr)) {
                return Float2ByteOpenCustomHashMap.this.value[pos2] == v;
            }
            do {
                if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & Float2ByteOpenCustomHashMap.this.mask]) != 0) continue;
                return false;
            } while (!Float2ByteOpenCustomHashMap.this.strategy.equals(k, curr));
            return Float2ByteOpenCustomHashMap.this.value[pos2] == v;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Float)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Byte)) {
                return false;
            }
            float k = ((Float)e.getKey()).floatValue();
            byte v = (Byte)e.getValue();
            if (Float2ByteOpenCustomHashMap.this.strategy.equals(k, 0.0f)) {
                if (Float2ByteOpenCustomHashMap.this.containsNullKey && Float2ByteOpenCustomHashMap.this.value[Float2ByteOpenCustomHashMap.this.n] == v) {
                    Float2ByteOpenCustomHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            float[] key = Float2ByteOpenCustomHashMap.this.key;
            int pos2 = HashCommon.mix(Float2ByteOpenCustomHashMap.this.strategy.hashCode(k)) & Float2ByteOpenCustomHashMap.this.mask;
            float curr = key[pos2];
            if (Float.floatToIntBits(curr) == 0) {
                return false;
            }
            if (Float2ByteOpenCustomHashMap.this.strategy.equals(curr, k)) {
                if (Float2ByteOpenCustomHashMap.this.value[pos2] == v) {
                    Float2ByteOpenCustomHashMap.this.removeEntry(pos2);
                    return true;
                }
                return false;
            }
            do {
                if (Float.floatToIntBits(curr = key[pos2 = pos2 + 1 & Float2ByteOpenCustomHashMap.this.mask]) != 0) continue;
                return false;
            } while (!Float2ByteOpenCustomHashMap.this.strategy.equals(curr, k) || Float2ByteOpenCustomHashMap.this.value[pos2] != v);
            Float2ByteOpenCustomHashMap.this.removeEntry(pos2);
            return true;
        }

        @Override
        public int size() {
            return Float2ByteOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2ByteOpenCustomHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super Float2ByteMap.Entry> consumer) {
            if (Float2ByteOpenCustomHashMap.this.containsNullKey) {
                consumer.accept(new AbstractFloat2ByteMap.BasicEntry(Float2ByteOpenCustomHashMap.this.key[Float2ByteOpenCustomHashMap.this.n], Float2ByteOpenCustomHashMap.this.value[Float2ByteOpenCustomHashMap.this.n]));
            }
            int pos2 = Float2ByteOpenCustomHashMap.this.n;
            while (pos2-- != 0) {
                if (Float.floatToIntBits(Float2ByteOpenCustomHashMap.this.key[pos2]) == 0) continue;
                consumer.accept(new AbstractFloat2ByteMap.BasicEntry(Float2ByteOpenCustomHashMap.this.key[pos2], Float2ByteOpenCustomHashMap.this.value[pos2]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Float2ByteMap.Entry> consumer) {
            AbstractFloat2ByteMap.BasicEntry entry = new AbstractFloat2ByteMap.BasicEntry();
            if (Float2ByteOpenCustomHashMap.this.containsNullKey) {
                entry.key = Float2ByteOpenCustomHashMap.this.key[Float2ByteOpenCustomHashMap.this.n];
                entry.value = Float2ByteOpenCustomHashMap.this.value[Float2ByteOpenCustomHashMap.this.n];
                consumer.accept(entry);
            }
            int pos2 = Float2ByteOpenCustomHashMap.this.n;
            while (pos2-- != 0) {
                if (Float.floatToIntBits(Float2ByteOpenCustomHashMap.this.key[pos2]) == 0) continue;
                entry.key = Float2ByteOpenCustomHashMap.this.key[pos2];
                entry.value = Float2ByteOpenCustomHashMap.this.value[pos2];
                consumer.accept(entry);
            }
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ByteMap.Entry> {
        private final MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ByteMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        boolean mustReturnNullKey;
        FloatArrayList wrapped;

        private MapIterator() {
            this.pos = Float2ByteOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Float2ByteOpenCustomHashMap.this.size;
            this.mustReturnNullKey = Float2ByteOpenCustomHashMap.this.containsNullKey;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Float2ByteOpenCustomHashMap.this.n;
                return this.last;
            }
            float[] key = Float2ByteOpenCustomHashMap.this.key;
            do {
                if (--this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                float k = this.wrapped.getFloat(-this.pos - 1);
                int p = HashCommon.mix(Float2ByteOpenCustomHashMap.this.strategy.hashCode(k)) & Float2ByteOpenCustomHashMap.this.mask;
                while (!Float2ByteOpenCustomHashMap.this.strategy.equals(k, key[p])) {
                    p = p + 1 & Float2ByteOpenCustomHashMap.this.mask;
                }
                return p;
            } while (Float.floatToIntBits(key[this.pos]) == 0);
            this.last = this.pos;
            return this.last;
        }

        private void shiftKeys(int pos2) {
            float[] key = Float2ByteOpenCustomHashMap.this.key;
            while (true) {
                float curr;
                int last = pos2;
                pos2 = last + 1 & Float2ByteOpenCustomHashMap.this.mask;
                while (true) {
                    if (Float.floatToIntBits(curr = key[pos2]) == 0) {
                        key[last] = 0.0f;
                        return;
                    }
                    int slot = HashCommon.mix(Float2ByteOpenCustomHashMap.this.strategy.hashCode(curr)) & Float2ByteOpenCustomHashMap.this.mask;
                    if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                    pos2 = pos2 + 1 & Float2ByteOpenCustomHashMap.this.mask;
                }
                if (pos2 < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new FloatArrayList(2);
                    }
                    this.wrapped.add(key[pos2]);
                }
                key[last] = curr;
                Float2ByteOpenCustomHashMap.this.value[last] = Float2ByteOpenCustomHashMap.this.value[pos2];
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == Float2ByteOpenCustomHashMap.this.n) {
                Float2ByteOpenCustomHashMap.this.containsNullKey = false;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                Float2ByteOpenCustomHashMap.this.remove(this.wrapped.getFloat(-this.pos - 1));
                this.last = -1;
                return;
            }
            --Float2ByteOpenCustomHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    final class MapEntry
    implements Float2ByteMap.Entry,
    Map.Entry<Float, Byte> {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public float getFloatKey() {
            return Float2ByteOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public byte getByteValue() {
            return Float2ByteOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Float2ByteOpenCustomHashMap.this.value[this.index];
            Float2ByteOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        @Deprecated
        public Float getKey() {
            return Float.valueOf(Float2ByteOpenCustomHashMap.this.key[this.index]);
        }

        @Override
        @Deprecated
        public Byte getValue() {
            return Float2ByteOpenCustomHashMap.this.value[this.index];
        }

        @Override
        @Deprecated
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2ByteOpenCustomHashMap.this.strategy.equals(Float2ByteOpenCustomHashMap.this.key[this.index], ((Float)e.getKey()).floatValue()) && Float2ByteOpenCustomHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return Float2ByteOpenCustomHashMap.this.strategy.hashCode(Float2ByteOpenCustomHashMap.this.key[this.index]) ^ Float2ByteOpenCustomHashMap.this.value[this.index];
        }

        public String toString() {
            return Float2ByteOpenCustomHashMap.this.key[this.index] + "=>" + Float2ByteOpenCustomHashMap.this.value[this.index];
        }
    }
}

