/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;
import org.magicwerk.brownies.collections.primitive.ShortObjBigList;
import org.magicwerk.brownies.collections.primitive.ShortObjGapList;

public abstract class IShortList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static short[] toArray(Collection<Short> coll) {
        Object[] values2 = coll.toArray();
        short[] v = new short[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            v[i] = (Short)values2[i];
        }
        return v;
    }

    public IShortList copy() {
        return (IShortList)this.clone();
    }

    public abstract IShortList unmodifiableList();

    public Object clone() {
        try {
            IShortList list2 = (IShortList)super.clone();
            list2.doClone(this);
            return list2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IShortList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len, short elem) {
        this.checkLength(len);
        int size2 = this.size();
        if (len < size2) {
            this.remove(len, size2 - len);
        } else {
            for (int i = size2; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public abstract int size();

    public abstract int capacity();

    public short get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract short doGet(int var1);

    protected abstract short doSet(int var1, short var2);

    public short set(int index, short elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public short put(int index, short elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0;
    }

    protected abstract short doReSet(int var1, short var2);

    protected abstract short getDefaultElem();

    protected void doModify() {
    }

    public boolean add(short elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, short elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, short var2);

    public short remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract short doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof ShortObjGapList) {
            obj = ((ShortObjGapList)obj).list;
        } else if (obj instanceof ShortObjBigList) {
            obj = ((ShortObjBigList)obj).list;
        }
        if (!(obj instanceof IShortList)) {
            return false;
        }
        IShortList list2 = (IShortList)obj;
        int size2 = this.size();
        if (size2 != list2.size()) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            if (IShortList.equalsElem(this.doGet(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short elem = this.doGet(i);
            hashCode = 31 * hashCode + IShortList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(short elem1, short elem2) {
        return elem1 == elem2;
    }

    static int hashCodeElem(short elem) {
        return elem;
    }

    public int getCount(short elem) {
        int count = 0;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IShortList getAll(short elem) {
        IShortList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (!IShortList.equalsElem(e, elem)) continue;
            list2.add(e);
        }
        return list2;
    }

    public IShortList getWhere(IPredicate predicate) {
        IShortList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public void removeWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public void retainWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public IShortList extractWhere(IPredicate predicate) {
        IShortList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public Set getDistinct() {
        HashSet<Short> set = new HashSet<Short>();
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(IFunction<Short, R> mapper) {
        int size2 = this.size();
        GapList<R> mappedList = new GapList<R>(size2);
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            ((IList)mappedList).add(mapper.apply(e));
        }
        return mappedList;
    }

    public void filter(IPredicate<Short> predicate) {
        IShortList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        this.doAssign(list2);
    }

    public int indexOf(short elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(short elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size2 = this.size();
        for (int i = fromIndex; i < size2; ++i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short elem, int fromIndex) {
        int size2 = this.size();
        if (fromIndex >= size2) {
            fromIndex = size2 - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IShortList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(short elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(short elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean addIfAbsent(short elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Short> coll) {
        for (short elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Short> coll) {
        for (short elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public IShortList removeAll(short elem) {
        IShortList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            short e = this.doGet(i);
            if (!IShortList.equalsElem(elem, e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public boolean removeAll(Collection<Short> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(IShortList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Short> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IShortList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public short[] toArray() {
        int size2 = this.size();
        short[] array = new short[size2];
        this.doGetAll(array, 0, size2);
        return array;
    }

    public short[] toArray(int index, int len) {
        short[] array = new short[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public short[] toArray(short[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = (short[])Array.newInstance(array.getClass().getComponentType(), size2);
        }
        this.doGetAll(array, 0, size2);
        if (array.length > size2) {
            array[size2] = 0;
        }
        return array;
    }

    protected void doGetAll(short[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IShortList list2) {
        int listSize = list2.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            short elem = list2.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public short peek() {
        if (this.size() == 0) {
            return 0;
        }
        return this.getFirst();
    }

    public short element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public short poll() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public short remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(short elem) {
        return this.doAdd(-1, elem);
    }

    public short getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public short getLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size2 - 1);
    }

    public void addFirst(short elem) {
        this.doAdd(0, elem);
    }

    public void addLast(short elem) {
        this.doAdd(-1, elem);
    }

    public short removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public short removeLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size2 - 1);
    }

    public boolean offerFirst(short elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(short elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public short peekFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doGet(0);
    }

    public short peekLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0;
        }
        return this.doGet(size2 - 1);
    }

    public short pollFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public short pollLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0;
        }
        return this.doRemove(size2 - 1);
    }

    public short pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(short elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(short elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(short elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(IShortList src, int srcIndex, int srcLen, IShortList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(IShortList src, int srcIndex, int srcLen, IShortList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(IShortList src, int srcIndex, int srcLen, IShortList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IShortList dst, int dstIndex, int dstLen) {
        if (srcLen == -1) {
            srcLen = this.size() - srcIndex;
        }
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        short defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                short elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                short elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(IShortList src, int srcIndex, IShortList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len);
        }
    }

    void doTransferSwap(int srcIndex, IShortList dst, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        dst.checkRange(dstIndex, len);
        for (int i = 0; i < len; ++i) {
            short swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IShortList doCreate(int var1);

    protected abstract void doAssign(IShortList var1);

    public IShortList getAll(int index, int len) {
        this.checkRange(index, len);
        IShortList list2 = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list2.add(this.doGet(index + i));
        }
        return list2;
    }

    public IShortList extract(int index, int len) {
        this.checkRange(index, len);
        IShortList list2 = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list2.add(this.doGet(index + i));
        }
        this.remove(index, len);
        return list2;
    }

    public short[] getArray(int index, int len) {
        this.checkRange(index, len);
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(IShortList list2) {
        return this.doAddAll(-1, list2);
    }

    public boolean addAll(int index, IShortList list2) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list2);
    }

    public boolean addAll(Collection<Short> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyShortListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyShortListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Short> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyShortListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyShortListFromCollection(coll));
    }

    public boolean addArray(short ... elems) {
        return this.doAddAll(-1, new IReadOnlyShortListFromArray(elems));
    }

    public boolean addArray(int index, short ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyShortListFromArray(elems));
    }

    public boolean addMult(int len, short elem) {
        return this.doAddAll(-1, new IReadOnlyShortListFromMult(len, elem));
    }

    public boolean addMult(int index, int len, short elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyShortListFromMult(len, elem));
    }

    public void setAll(int index, IShortList list2) {
        int listSize = list2.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list2);
    }

    public void setAll(int index, Collection<Short> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyShortListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyShortListFromCollection(coll));
        }
    }

    public void setArray(int index, short ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyShortListFromArray(elems));
    }

    public void setMult(int index, int len, short elem) {
        this.checkRange(index, len);
        this.doReplaceAll(index, len, new IReadOnlyShortListFromMult(len, elem));
    }

    public void putAll(int index, IShortList list2) {
        this.checkIndexAdd(index);
        this.checkNonNull(list2);
        int len = this.size() - index;
        if (list2 != null && list2.size() < len) {
            len = list2.size();
        }
        this.doReplaceAll(index, len, list2);
    }

    public void putAll(int index, Collection<Short> coll) {
        if (coll instanceof IShortList) {
            this.putAll(index, (IShortList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyShortListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyShortListFromCollection(coll));
        }
    }

    public void putArray(int index, short ... elems) {
        this.putAll(index, new IReadOnlyShortListFromArray(elems));
    }

    public void putMult(int index, int len, short elem) {
        this.putAll(index, new IReadOnlyShortListFromMult(len, elem));
    }

    public void initAll(IShortList list2) {
        this.checkNonNull(list2);
        this.doReplaceAll(0, this.size(), list2);
    }

    public void initAll(Collection<Short> coll) {
        if (coll instanceof IShortList) {
            this.initAll((IShortList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyShortListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyShortListFromCollection(coll));
        }
    }

    public void initArray(short ... elems) {
        this.initAll(new IReadOnlyShortListFromArray(elems));
    }

    public void initMult(int len, short elem) {
        this.checkLength(len);
        this.initAll(new IReadOnlyShortListFromMult(len, elem));
    }

    public void replaceAll(int index, int len, Collection<Short> coll) {
        if (coll instanceof IShortList) {
            this.replaceAll(index, len, (IShortList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len, new IReadOnlyShortListFromList((List)coll));
        } else {
            this.replaceAll(index, len, new IReadOnlyShortListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len, short ... elems) {
        this.replaceAll(index, len, new IReadOnlyShortListFromArray(elems));
    }

    public void replaceMult(int index, int len, int numElems, short elem) {
        this.replaceAll(index, len, new IReadOnlyShortListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len, IShortList list2) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len == -1) {
            len = this.size() - index;
            if (list2 != null && list2.size() < len) {
                len = list2.size();
            }
        } else {
            this.checkRange(index, len);
        }
        this.doReplaceAll(index, len, list2);
    }

    protected boolean doReplaceAll(int index, int len, IShortList list2) {
        assert (index >= 0 && index <= this.size());
        assert (len >= 0 && index + len <= this.size());
        int srcLen = 0;
        if (list2 != null) {
            srcLen = list2.size();
        }
        this.doEnsureCapacity(this.size() - len + srcLen);
        this.doRemoveAll(index, len);
        for (int i = 0; i < srcLen; ++i) {
            if (this.doAdd(index + i, list2.doGet(i))) continue;
            --index;
        }
        return len > 0 || srcLen > 0;
    }

    public void fill(short elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, (short)0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.setMult(srcIndex + len - fill, fill, (short)0);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            short swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            short swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        this.doRotate(index, len, distance);
    }

    protected void doRotate(int index, int len, int distance) {
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len);
        int num = 0;
        int start = 0;
        while (num != len) {
            short elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(short key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, short var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be (short) 0");
        }
    }

    protected static class IReadOnlyShortListFromList
    extends IReadOnlyShortList {
        List<Short> list2;

        IReadOnlyShortListFromList(List<Short> list2) {
            this.list2 = list2;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected short doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyShortListFromCollection
    extends IReadOnlyShortList {
        short[] array;

        IReadOnlyShortListFromCollection(Collection<Short> coll) {
            this.array = IReadOnlyShortListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected short doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyShortListFromMult
    extends IReadOnlyShortList {
        int len;
        short elem;

        IReadOnlyShortListFromMult(int len, short elem) {
            this.checkLength(len);
            this.len = len;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected short doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyShortListFromArray
    extends IReadOnlyShortList {
        short[] array;

        IReadOnlyShortListFromArray(short[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected short doGet(int index) {
            return this.array[index];
        }
    }

    protected static abstract class IReadOnlyShortList
    extends IShortList {
        protected IReadOnlyShortList() {
        }

        @Override
        public IShortList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IShortList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected short doSet(int index, short elem) {
            this.error();
            return 0;
        }

        @Override
        protected short doReSet(int index, short elem) {
            this.error();
            return 0;
        }

        @Override
        protected short getDefaultElem() {
            this.error();
            return 0;
        }

        @Override
        protected boolean doAdd(int index, short elem) {
            this.error();
            return false;
        }

        @Override
        protected short doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IShortList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IShortList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len, short key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

