/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.function.Function;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.multipart.PartInfo;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class MultipartAction {
    public final BlockPos pos;
    public final IPartSlot slot;
    public final int type;

    private MultipartAction(int type, BlockPos pos, IPartSlot slot) {
        this.pos = pos;
        this.slot = slot;
        this.type = type;
    }

    public abstract void handlePacket(EntityPlayer var1);

    public static abstract class DataCarrier
    extends MultipartAction {
        public final IBlockState state;
        public final NBTTagCompound data;

        private DataCarrier(int type, BlockPos pos, IPartSlot slot, IBlockState state, NBTTagCompound data) {
            super(type, pos, slot);
            this.state = state;
            this.data = data;
        }
    }

    public static final class Remove
    extends MultipartAction {
        public static final int TYPE = 2;

        public Remove(BlockPos pos, IPartSlot slot) {
            super(2, pos, slot);
        }

        @Override
        public void handlePacket(EntityPlayer player) {
            PartInfo.handleRemovalPacket(player.field_70170_p, this.pos, this.slot);
        }
    }

    public static final class Change
    extends DataCarrier {
        public static final int TYPE = 1;
        private static final MethodHandle SPacketUpdateTileEntity$nbt;
        private static final Function<SPacketUpdateTileEntity, NBTTagCompound> getUpdateTag;

        public Change(BlockPos pos, IPartSlot slot, IBlockState state, NBTTagCompound data) {
            super(1, pos, slot, state, data);
        }

        public Change(IPartInfo info) {
            this(info.getPartPos(), info.getSlot(), info.getState(), info.getTile() != null ? getUpdateTag.apply(info.getTile().getPartUpdatePacket()) : null);
        }

        @Override
        public void handlePacket(EntityPlayer player) {
            PartInfo.handleUpdatePacket(player.field_70170_p, this.pos, this.slot, this.state, this.data != null ? new SPacketUpdateTileEntity(this.pos, 0, this.data) : null);
        }

        static {
            try {
                Field f = ReflectionHelper.findField(SPacketUpdateTileEntity.class, (String[])new String[]{"field_148860_e", "nbt"});
                SPacketUpdateTileEntity$nbt = MethodHandles.lookup().unreflectGetter(f);
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
            getUpdateTag = it -> {
                try {
                    return SPacketUpdateTileEntity$nbt.invokeExact((SPacketUpdateTileEntity)it);
                }
                catch (Throwable ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            };
        }
    }

    public static final class Add
    extends DataCarrier {
        public static final int TYPE = 0;

        public Add(BlockPos pos, IPartSlot slot, IBlockState state, NBTTagCompound data) {
            super(0, pos, slot, state, data);
        }

        public Add(IPartInfo info) {
            this(info.getPartPos(), info.getSlot(), info.getState(), info.getTile() != null ? info.getTile().getPartUpdateTag() : null);
        }

        @Override
        public void handlePacket(EntityPlayer player) {
            PartInfo.handleAdditionPacket(player.field_70170_p, this.pos, this.slot, this.state, this.data);
        }
    }
}

