/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import java.util.List;
import mcmultipart.MCMultiPart;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.network.ChangeList;
import mcmultipart.network.MultipartAction;
import mcmultipart.network.Packet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PacketMultipartAction
extends Packet<PacketMultipartAction> {
    private final ChangeList changes;

    public PacketMultipartAction() {
        this(new ChangeList());
    }

    public PacketMultipartAction(ChangeList changes) {
        this.changes = changes;
    }

    @Override
    public void handleClient(EntityPlayer player) {
        this.changes.getChanges().forEach(it -> it.handlePacket(player));
    }

    @Override
    public void handleServer(EntityPlayer player) {
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        this.changes.sort();
        List<MultipartAction> l = this.changes.getChanges();
        buf.writeShort(l.size());
        boolean prevHasSameCoords = false;
        boolean prevHasSameSlot = false;
        for (int i = 0; i < l.size(); ++i) {
            MultipartAction entry = l.get(i);
            int entrySlot = MCMultiPart.slotRegistry.getID((IForgeRegistryEntry)entry.slot);
            boolean nextHasSameCoords = false;
            boolean nextHasSameSlot = false;
            if (i + 1 < l.size()) {
                MultipartAction next = l.get(i + 1);
                int nextSlot = MCMultiPart.slotRegistry.getID((IForgeRegistryEntry)next.slot);
                nextHasSameCoords = next.pos.equals((Object)entry.pos);
                nextHasSameSlot = nextSlot == entrySlot;
            }
            buf.writeByte(entry.type | (prevHasSameCoords ? 128 : 0) | (prevHasSameSlot ? 64 : 0));
            if (!prevHasSameCoords) {
                buf.func_179255_a(entry.pos);
            }
            if (!prevHasSameSlot) {
                buf.func_150787_b(entrySlot);
            }
            if (entry instanceof MultipartAction.DataCarrier) {
                MultipartAction.DataCarrier dc = (MultipartAction.DataCarrier)entry;
                buf.func_150787_b(MCMultiPart.stateMap.func_148747_b((Object)dc.state));
                buf.func_150786_a(dc.data);
            }
            prevHasSameCoords = nextHasSameCoords;
            prevHasSameSlot = nextHasSameSlot;
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf) throws Exception {
        this.changes.clear();
        int partsCount = buf.readUnsignedShort();
        BlockPos prevCoords = BlockPos.field_177992_a;
        int prevSlotId = 0;
        for (int i = 0; i < partsCount; ++i) {
            short bits = buf.readUnsignedByte();
            boolean prevHasSameCoords = (bits & 0x80) != 0;
            boolean prevHasSameSlotId = (bits & 0x40) != 0;
            int type = bits & 0x1F;
            BlockPos coords = prevCoords;
            int slotId = prevSlotId;
            if (!prevHasSameCoords) {
                coords = buf.func_179259_c();
            }
            if (!prevHasSameSlotId) {
                slotId = buf.func_150792_a();
            }
            IPartSlot slot = (IPartSlot)MCMultiPart.slotRegistry.getValue(slotId);
            IBlockState state = null;
            NBTTagCompound nbt = null;
            if (type == 0 || type == 1) {
                int value = buf.func_150792_a();
                state = (IBlockState)MCMultiPart.stateMap.func_148745_a(value);
                nbt = buf.func_150793_b();
            }
            switch (type) {
                case 0: {
                    this.changes.addChange(new MultipartAction.Add(coords, slot, state, nbt));
                    break;
                }
                case 1: {
                    this.changes.addChange(new MultipartAction.Change(coords, slot, state, nbt));
                    break;
                }
                case 2: {
                    this.changes.addChange(new MultipartAction.Remove(coords, slot));
                    break;
                }
                default: {
                    MCMultiPart.log.fatal("Error while decoding packet: Invalid action type {}", (Object)type);
                }
            }
            prevCoords = coords;
            prevSlotId = slotId;
        }
    }
}

