/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block;

import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.block.BlockBase;
import com.buuz135.industrial.proxy.block.tile.TileEntityLabel;
import com.buuz135.industrial.proxy.client.infopiece.IHasDisplayStack;
import com.buuz135.industrial.proxy.client.render.LabelTESR;
import com.buuz135.industrial.tile.misc.BlackHoleUnitTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockLabel
extends BlockBase {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.0625);
    public static AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.125, 0.125, 1.0, 0.875, 0.875, 0.9375);
    public static AxisAlignedBB EAST_AABB = new AxisAlignedBB(1.0, 0.125, 0.125, 0.9375, 0.875, 0.875);
    public static AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.125, 0.125, 0.0625, 0.875, 0.875);
    private HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();

    public BlockLabel() {
        super("black_hole_label");
        this.func_149711_c(1.5f).func_149752_b(10.0f);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this, 4, 0), new Object[]{"ppp", "iri", "ppp", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('i'), Items.field_151121_aF, Character.valueOf('r'), Items.field_151137_ax});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return NORTH_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side.func_176740_k().func_176722_c() && worldIn.func_175625_s(pos.func_177972_a(side.func_176734_d())) instanceof IHasDisplayStack;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        EnumFacing facing;
        super.onNeighborChange(world, pos, neighbor);
        if (world instanceof World && !((World)world).field_72995_K && !(world.func_175625_s(pos.func_177972_a(facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING))) instanceof IHasDisplayStack)) {
            ((World)world).func_175655_b(pos, true);
        }
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileEntity = this.createTileEntity(worldIn, state);
        worldIn.func_175690_a(pos, tileEntity);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileEntityLabel tile = new TileEntityLabel();
        tile.func_145834_a(world);
        return tile;
    }

    @Override
    public void registerBlock(IForgeRegistry<Block> blocks) {
        super.registerBlock(blocks);
        GameRegistry.registerTileEntity(TileEntityLabel.class, (ResourceLocation)new ResourceLocation("industrialforegoing", this.getRegistryName().func_110623_a() + "_tile"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        super.registerRender();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLabel.class, (TileEntitySpecialRenderer)new LabelTESR());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity entity = worldIn.func_175625_s(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
        TileEntity self = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && self instanceof TileEntityLabel && entity instanceof IHasDisplayStack && !((IHasDisplayStack)entity).getItemStack().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            if (playerIn.func_70093_af()) {
                playerIn.func_184185_a(SoundEvents.field_187750_dc, 1.0f, 1.0f);
                if (((TileEntityLabel)self).getFormatType() == TileEntityLabel.FormatType.STACKS) {
                    ((TileEntityLabel)self).setFormatType(TileEntityLabel.FormatType.MILL);
                } else {
                    ((TileEntityLabel)self).setFormatType(TileEntityLabel.FormatType.STACKS);
                }
            } else if (entity instanceof BlackHoleUnitTile && entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH)) {
                ItemStack stack = playerIn.func_184586_b(hand);
                if (!stack.func_190926_b() && ((BlackHoleUnitTile)entity).canInsertItem(stack)) {
                    playerIn.func_184611_a(hand, ((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH)).insertItem(0, stack, false));
                } else if (System.currentTimeMillis() - this.INTERACTION_LOGGER.getOrDefault(playerIn.func_110124_au(), System.currentTimeMillis()) < 300L) {
                    IItemHandler handler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
                    for (ItemStack itemStack : playerIn.field_71071_by.field_70462_a) {
                        if (itemStack.func_190926_b() || !handler.insertItem(0, itemStack, true).func_190926_b()) continue;
                        handler.insertItem(0, itemStack.func_77946_l(), false);
                        itemStack.func_190920_e(0);
                    }
                }
                this.INTERACTION_LOGGER.put(playerIn.func_110124_au(), System.currentTimeMillis());
            }
        }
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            TileEntity entity = worldIn.func_175625_s(pos.func_177972_a((EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
            TileEntity self = worldIn.func_175625_s(pos);
            if (self instanceof TileEntityLabel && entity instanceof BlackHoleUnitTile && ((BlackHoleUnitTile)entity).getDisplayAmount() > 0 && !((IHasDisplayStack)entity).getItemStack().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH)).extractItem(0, playerIn.func_70093_af() ? 64 : 1, false));
            }
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }
}

