/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.tile.CustomGeneratorMachine;
import com.buuz135.industrial.utils.WorkUtils;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public abstract class AbstractReactorGeneratorTile
extends CustomGeneratorMachine {
    private IFluidTank tank;
    private int generatedPower;

    public AbstractReactorGeneratorTile(int id, int generatedPower) {
        super(id);
        this.generatedPower = generatedPower;
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.tank = this.addFluidTank(this.getFluid(), 8000, EnumDyeColor.PURPLE, "Tank", new BoundingRectangle(58, 25, 18, 54));
    }

    protected long consumeFuel() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0L;
        }
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() >= 1) {
            this.tank.drain(1, true);
            return (long)this.generatedPower * 7L;
        }
        return 0L;
    }

    public long getEnergyFillRate() {
        return this.generatedPower;
    }

    protected long getMaxEnergy() {
        return 1000000L;
    }

    public abstract Fluid getFluid();
}

