/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.common.Mekanism;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.inventory.container.ContainerDigitalMiner;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDigitalMiner
extends GuiMekanismTile<TileEntityDigitalMiner> {
    public static final int START_BUTTON_ID = 0;
    public static final int STOP_BUTTON_ID = 1;
    public static final int CONFIG_BUTTON_ID = 2;
    public static final int RESET_BUTTON_ID = 3;
    public static final int SILK_TOUCH_BUTTON_ID = 4;
    public static final int AUTOEJECT_BUTTON_ID = 5;
    public static final int AUTO_PULL_BUTTON_ID = 6;
    private GuiButton startButton;
    private GuiButton stopButton;
    private GuiButton configButton;
    private GuiButton resetButton;
    private GuiButton silkTouchButton;
    private GuiButton autoEjectButton;
    private GuiButton autoPullButton;

    public GuiDigitalMiner(InventoryPlayer inventory, TileEntityDigitalMiner tile) {
        super(tile, new ContainerDigitalMiner(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 163, 23));
        this.addGuiElement(new GuiVisualsTab(this, (TileEntityDigitalMiner)this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            double perTick = ((TileEntityDigitalMiner)this.tileEntity).getPerTick();
            String multiplier = MekanismUtils.getEnergyDisplay(perTick);
            ArrayList<String> ret = new ArrayList<String>(4);
            ret.add(LangUtils.localize("mekanism.gui.digitalMiner.capacity") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy()));
            ret.add(LangUtils.localize("gui.needed") + ": " + multiplier + "/t");
            if (perTick > ((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy()) {
                ret.add(TextFormatting.RED + LangUtils.localize("mekanism.gui.insufficientbuffer"));
            }
            ret.add(LangUtils.localize("mekanism.gui.bufferfree") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy() - ((TileEntityDigitalMiner)this.tileEntity).getEnergy()));
            return ret;
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 151, 5).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 143, 26));
        this.field_147000_g += 64;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.startButton = new GuiButton(0, this.field_147003_i + 69, this.field_147009_r + 17, 60, 20, LangUtils.localize("gui.start"));
        this.field_146292_n.add(this.startButton);
        this.stopButton = new GuiButton(1, this.field_147003_i + 69, this.field_147009_r + 37, 60, 20, LangUtils.localize("gui.stop"));
        this.field_146292_n.add(this.stopButton);
        this.configButton = new GuiButton(2, this.field_147003_i + 69, this.field_147009_r + 57, 60, 20, LangUtils.localize("gui.config"));
        this.field_146292_n.add(this.configButton);
        this.resetButton = new GuiButtonDisableableImage(3, this.field_147003_i + 131, this.field_147009_r + 47, 14, 14, 208, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.resetButton);
        this.silkTouchButton = new GuiButtonDisableableImage(4, this.field_147003_i + 131, this.field_147009_r + 63, 14, 14, 222, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.silkTouchButton);
        this.autoEjectButton = new GuiButtonDisableableImage(5, this.field_147003_i + 147, this.field_147009_r + 47, 14, 14, 180, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.autoEjectButton);
        this.autoPullButton = new GuiButtonDisableableImage(6, this.field_147003_i + 147, this.field_147009_r + 63, 14, 14, 194, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.autoPullButton);
        this.updateEnabledButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        switch (guibutton.field_146127_k) {
            case 0: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3)));
                break;
            }
            case 1: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(4)));
                break;
            }
            case 2: {
                Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
                break;
            }
            case 3: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(5)));
                break;
            }
            case 4: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(9)));
                break;
            }
            case 5: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0)));
                break;
            }
            case 6: {
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(1)));
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.startButton.field_146124_l = ((TileEntityDigitalMiner)this.tileEntity).searcher.state == ThreadMinerSearch.State.IDLE || !((TileEntityDigitalMiner)this.tileEntity).running;
        this.stopButton.field_146124_l = ((TileEntityDigitalMiner)this.tileEntity).searcher.state != ThreadMinerSearch.State.IDLE && ((TileEntityDigitalMiner)this.tileEntity).running;
        this.configButton.field_146124_l = ((TileEntityDigitalMiner)this.tileEntity).searcher.state == ThreadMinerSearch.State.IDLE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityDigitalMiner)this.tileEntity).func_70005_c_(), 69, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String runningType = ((TileEntityDigitalMiner)this.tileEntity).getPerTick() > ((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy() ? LangUtils.localize("mekanism.gui.digitalMiner.lowPower") : (((TileEntityDigitalMiner)this.tileEntity).running ? LangUtils.localize("gui.digitalMiner.running") : LangUtils.localize("gui.idle"));
        this.field_146289_q.func_78276_b(runningType, 9, 10, 52480);
        this.field_146289_q.func_78276_b(((TileEntityDigitalMiner)this.tileEntity).searcher.state.desc, 9, 19, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + LangUtils.localize("gui." + (((TileEntityDigitalMiner)this.tileEntity).doEject ? "on" : "off")), 9, 30, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.pull") + ": " + LangUtils.localize("gui." + (((TileEntityDigitalMiner)this.tileEntity).doPull ? "on" : "off")), 9, 39, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.silk") + ": " + LangUtils.localize("gui." + (((TileEntityDigitalMiner)this.tileEntity).silkTouch ? "on" : "off")), 9, 48, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMiner.toMine") + ":", 9, 59, 52480);
        this.field_146289_q.func_78276_b("" + ((TileEntityDigitalMiner)this.tileEntity).clientToMine, 9, 68, 52480);
        if (!((TileEntityDigitalMiner)this.tileEntity).missingStack.func_190926_b()) {
            this.drawColorIcon(144, 27, EnumColor.DARK_RED, 0.8f);
            this.renderItem(((TileEntityDigitalMiner)this.tileEntity).missingStack, 144, 27);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSlot.png"));
            this.func_73729_b(143, 26, GuiSlot.SlotOverlay.CHECK.textureX, GuiSlot.SlotOverlay.CHECK.textureY, 18, 18);
        }
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.autoEjectButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
        } else if (this.autoPullButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.autoPull"), xAxis, yAxis);
        } else if (this.resetButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.reset"), xAxis, yAxis);
        } else if (this.silkTouchButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.silkTouch"), xAxis, yAxis);
        } else if (xAxis >= 164 && xAxis <= 168 && yAxis >= 25 && yAxis <= 77) {
            this.displayTooltip(MekanismUtils.getEnergyDisplay(((TileEntityDigitalMiner)this.tileEntity).getEnergy(), ((TileEntityDigitalMiner)this.tileEntity).getMaxEnergy()), xAxis, yAxis);
        } else if (xAxis >= 144 && xAxis <= 160 && yAxis >= 27 && yAxis <= 43) {
            if (!((TileEntityDigitalMiner)this.tileEntity).missingStack.func_190926_b()) {
                this.displayTooltip(LangUtils.localize("gui.digitalMiner.missingBlock"), xAxis, yAxis);
            } else {
                this.displayTooltip(LangUtils.localize("gui.well"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        int displayInt = ((TileEntityDigitalMiner)this.tileEntity).getScaledEnergyLevel(52);
        this.func_73729_b(this.field_147003_i + 164, this.field_147009_r + 25 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMiner.png");
    }
}

