/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TransporterManager {
    private static Map<Coord4D, Set<TransporterStack>> flowingStacks = new HashMap<Coord4D, Set<TransporterStack>>();

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(TransporterStack stack) {
        flowingStacks.computeIfAbsent(stack.getDest(), k -> new HashSet()).add(stack);
    }

    public static void remove(TransporterStack stack) {
        if (stack.hasPath() && stack.getPathType() != TransporterStack.Path.NONE) {
            flowingStacks.get(stack.getDest()).remove(stack);
        }
    }

    private static int simulateInsert(IItemHandler handler, InventoryInfo inventoryInfo, ItemStack stack, int count) {
        int originalCount = stack.func_190916_E();
        if (count != originalCount) {
            stack.func_190920_e(count);
        }
        for (int i = 0; i < handler.getSlots() && !stack.func_190926_b(); ++i) {
            int destCount;
            int max = handler.getSlotLimit(i);
            if (max == 0 || !handler.isItemValid(i, stack) || (destCount = inventoryInfo.stackSizes.get(i).intValue()) > 0 && !InventoryUtils.areItemsStackable((ItemStack)inventoryInfo.inventory.get(i), stack) || destCount == 0 && ItemStack.func_77989_b((ItemStack)handler.insertItem(i, stack, true), (ItemStack)stack)) continue;
            int mergedCount = count + destCount;
            if (mergedCount > max) {
                inventoryInfo.stackSizes.set(i, max);
                count = mergedCount - max;
                stack.func_190920_e(count);
                continue;
            }
            inventoryInfo.stackSizes.set(i, mergedCount);
            if (count != originalCount) {
                stack.func_190920_e(originalCount);
            }
            return 0;
        }
        if (count != originalCount) {
            stack.func_190920_e(originalCount);
        }
        return count;
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() || returned.func_190916_E() < stack.func_190916_E();
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() ? stack : StackUtils.size(stack, stack.func_190916_E() - returned.func_190916_E());
    }

    public static TransitRequest.TransitResponse getPredictedInsert(TileEntity tileEntity, EnumColor color, TransitRequest request, EnumFacing side) {
        IItemHandler handler;
        ISideConfiguration config;
        if (tileEntity instanceof ISideConfiguration && (config = (ISideConfiguration)tileEntity).getEjector().hasStrictInput()) {
            EnumFacing tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
            if (configColor != null && configColor != color) {
                return TransitRequest.TransitResponse.EMPTY;
            }
        }
        if ((handler = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d())) == null) {
            Mekanism.logger.error("Failed to predict insert; not an IItemHandler: {}", (Object)tileEntity);
            return TransitRequest.TransitResponse.EMPTY;
        }
        InventoryInfo inventoryInfo = new InventoryInfo(handler);
        Set<TransporterStack> transporterStacks = flowingStacks.get(Coord4D.get(tileEntity));
        if (transporterStacks != null) {
            for (TransporterStack transporterStack : transporterStacks) {
                if (transporterStack == null || transporterStack.getPathType() == TransporterStack.Path.NONE || TransporterManager.simulateInsert(handler, inventoryInfo, transporterStack.itemStack, transporterStack.itemStack.func_190916_E()) <= 0) continue;
                return TransitRequest.TransitResponse.EMPTY;
            }
        }
        for (Map.Entry entry : request.getItemMap().entrySet()) {
            int numToSend;
            ItemStack stack = ((HashedItem)entry.getKey()).getStack();
            int numLeftOver = TransporterManager.simulateInsert(handler, inventoryInfo, stack, numToSend = ((Integer)((Pair)entry.getValue()).getLeft()).intValue());
            if (numLeftOver == numToSend) continue;
            return new TransitRequest.TransitResponse(StackUtils.size(stack, numToSend - numLeftOver), (Map)((Pair)entry.getValue()).getRight());
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    private static class InventoryInfo {
        public NonNullList<ItemStack> inventory;
        public List<Integer> stackSizes = new ArrayList<Integer>();

        public InventoryInfo(IItemHandler handler) {
            this.inventory = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                this.inventory.set(i, (Object)stack);
                this.stackSizes.add(stack.func_190916_E());
            }
        }
    }
}

