/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.util;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IngredientAny;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;

public class IngredientWrapper {
    private final IIngredient left;
    private final IIngredient middle;
    private final IIngredient right;
    private final String infuseType;

    public IngredientWrapper(IIngredient ingredient) {
        this(ingredient, (IIngredient)IngredientAny.INSTANCE);
    }

    public IngredientWrapper(IIngredient left, IIngredient right) {
        this(left, (IIngredient)IngredientAny.INSTANCE, right);
    }

    public IngredientWrapper(IIngredient left, IIngredient middle, IIngredient right) {
        this.left = IngredientHelper.optionalIngredient(left);
        this.middle = IngredientHelper.optionalIngredient(middle);
        this.right = IngredientHelper.optionalIngredient(right);
        this.infuseType = "";
    }

    public IngredientWrapper(IIngredient ingredient, String infuseType) {
        this.left = IngredientHelper.optionalIngredient(ingredient);
        this.middle = IngredientAny.INSTANCE;
        this.right = IngredientAny.INSTANCE;
        this.infuseType = infuseType == null ? "" : infuseType;
    }

    public String getInfuseType() {
        return this.infuseType;
    }

    public IIngredient getIngredient() {
        return this.left;
    }

    public IIngredient getLeft() {
        return this.left;
    }

    public IIngredient getMiddle() {
        return this.middle;
    }

    public IIngredient getRight() {
        return this.right;
    }

    public int getAmount() {
        return 0;
    }

    public String toString() {
        String output = "";
        if (!this.left.equals(IngredientAny.INSTANCE)) {
            output = output + this.getDescriptor(this.left);
        }
        if (!this.middle.equals(IngredientAny.INSTANCE)) {
            output = output + ", " + this.getDescriptor(this.middle);
        }
        if (!this.right.equals(IngredientAny.INSTANCE)) {
            output = output + ", " + this.getDescriptor(this.right);
        }
        if (!this.infuseType.isEmpty()) {
            output = output + ", " + this.infuseType;
        }
        return output;
    }

    public boolean isEmpty() {
        return this.left.equals(IngredientAny.INSTANCE) && this.middle.equals(IngredientAny.INSTANCE) && this.right.equals(IngredientAny.INSTANCE) && this.infuseType.isEmpty();
    }

    private String getDescriptor(IIngredient ingredient) {
        return ingredient.toCommandString();
    }
}

