/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.dynamo;

import cofh.thermalexpansion.util.managers.dynamo.CompressionManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;

public class CompressionParser
extends BaseParser {
    int defaultEnergy = CompressionManager.DEFAULT_ENERGY;
    Set<String> removeQueue = new ObjectOpenHashSet();

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement contentElement : contentArray) {
            JsonObject content = contentElement.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            String fluidName = content.get("fluid").getAsString();
            if (content.has("remove") && content.get("remove").getAsBoolean()) {
                this.removeQueue.add(fluidName);
                continue;
            }
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (CompressionManager.addFuel(fluidName, energy)) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }

    @Override
    public void postProcess() {
        for (String fluidName : this.removeQueue) {
            CompressionManager.removeFuel(fluidName);
        }
    }
}

