/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary;

import com.google.common.collect.Lists;
import cubex2.cxlibrary.asm.ClassTransformer;
import cubex2.cxlibrary.asm.PacketTransformer;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class CoreModTransformer
implements IClassTransformer {
    private static List<ClassTransformer> transformers = Lists.newLinkedList();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        for (ClassTransformer transformer : transformers) {
            if (!transformer.transform(classNode)) continue;
            ClassWriter classWriter = new ClassWriter(transformer.getClassWriterFlags());
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    static {
        transformers.add(new PacketTransformer());
    }
}

