/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import cubex2.cxlibrary.gui.control.Anchor;
import cubex2.cxlibrary.gui.control.Control;
import cubex2.cxlibrary.gui.control.ControlBuilder;
import cubex2.cxlibrary.gui.control.ControlContainer;
import cubex2.cxlibrary.gui.data.GuiData;
import net.minecraft.client.renderer.GlStateManager;

public class Label
extends Control {
    protected String text;
    protected int color = -16777216;
    protected boolean centered;
    private String[] lines;

    public Label(String text, Anchor anchor, ControlContainer parent) {
        super(anchor, parent);
        this.setText(text);
    }

    public Label setCentered() {
        this.centered = true;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
        this.lines = this.text != null ? this.text.split("\n") : new String[0];
        int width = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            int w = this.mc.field_71466_p.func_78256_a(this.lines[i]);
            if (w <= width) continue;
            width = w;
        }
        this.anchor.width(width).height(this.lines.length * 13 - 4);
        if (this.getBounds() != null) {
            this.updateBounds();
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.lines.length; ++i) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int y = this.getY() + i * 13;
            if (this.centered) {
                this.mc.field_71466_p.func_78276_b(this.lines[i], this.getX() + (this.getWidth() - this.mc.field_71466_p.func_78256_a(this.text)) / 2, y, this.color);
                continue;
            }
            this.mc.field_71466_p.func_78276_b(this.lines[i], this.getX(), y, this.color);
        }
    }

    public static class Builder
    extends ControlBuilder<Label> {
        private final String text;

        public Builder(String text, GuiData data, String name, ControlContainer parent) {
            super(data, name, parent);
            this.text = text;
        }

        @Override
        protected Label createInstance() {
            return new Label(this.text, this.anchor, this.parent);
        }
    }
}

