/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.data;

import com.google.common.collect.Maps;
import cubex2.cxlibrary.gui.control.Anchor;
import cubex2.cxlibrary.gui.control.ControlContainer;
import cubex2.cxlibrary.gui.control.SlotControl;
import cubex2.cxlibrary.gui.data.ControlData;
import cubex2.cxlibrary.gui.data.IControlProvider;
import cubex2.cxlibrary.gui.data.SlotData;
import cubex2.cxlibrary.inventory.ISlotCX;
import cubex2.cxlibrary.util.CXUtil;
import cubex2.cxlibrary.util.ClientUtil;
import cubex2.cxlibrary.util.Cloneable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class GuiData {
    private String parent;
    private Map<String, ControlData> controls;
    private Map<String, SlotData[]> slots;
    private transient GuiData parentData;

    public Anchor apply(String name, ControlContainer parent, IControlProvider provider) {
        if (this.controls != null) {
            this.loadParent();
            ControlData data = this.controls.get(name);
            if (data != null) {
                Anchor anchor = new Anchor();
                data.apply(anchor, parent, provider);
                return anchor;
            }
        }
        return new Anchor();
    }

    public SlotControl.Builder apply(SlotControl.Builder builder) {
        if (this.slots != null) {
            this.loadParent();
            if (builder.slot instanceof ISlotCX) {
                SlotData[] slotDatas;
                String name = ((ISlotCX)builder.slot).getName();
                for (SlotData slotData : slotDatas = this.slots.get(name)) {
                    if (!slotData.apply(builder)) continue;
                    return builder;
                }
            }
        }
        return builder;
    }

    private void loadParent() {
        if (this.parent != null && this.parentData == null) {
            this.parentData = ClientUtil.loadGuiData(new ResourceLocation(this.parent), true);
            this.parentData.loadParent();
            if (this.controls == null) {
                this.controls = Maps.newLinkedHashMap();
            }
            if (this.slots == null) {
                this.slots = Maps.newHashMap();
            }
            Map<String, ControlData> parentControls = this.parentData.cloneControls();
            for (Map.Entry<String, ControlData> entry : this.controls.entrySet()) {
                if (parentControls.containsKey(entry.getKey())) {
                    ControlData toOverride = parentControls.get(entry.getKey());
                    toOverride.claimChildValues(entry.getValue());
                    continue;
                }
                parentControls.put(entry.getKey(), entry.getValue());
            }
            this.controls.clear();
            this.controls.putAll(parentControls);
            Map<String, SlotData[]> parentSlots = this.parentData.cloneSlots();
            for (Map.Entry<String, SlotData[]> entry : this.slots.entrySet()) {
                parentSlots.put(entry.getKey(), entry.getValue());
            }
            this.slots.clear();
            this.slots.putAll(parentSlots);
        }
    }

    private Map<String, SlotData[]> cloneSlots() {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        if (this.slots != null) {
            for (Map.Entry<String, SlotData[]> entry : this.slots.entrySet()) {
                ret.put(entry.getKey(), CXUtil.deepClone((Cloneable[])entry.getValue(), SlotData.class));
            }
        }
        return ret;
    }

    private Map<String, ControlData> cloneControls() {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        if (this.controls != null) {
            for (Map.Entry<String, ControlData> entry : this.controls.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return ret;
    }
}

