/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.spawner.EntityDataRegistry;
import crazypants.enderio.util.CapturedMob;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.util.ResourceLocation;

public class Entity
implements IRecipeConfigElement {
    protected Optional<String> name = this.empty();
    private double costMultiplier = 1.0;
    private boolean disabled = false;
    private boolean isDefault = false;
    private boolean isBoss = false;
    private boolean clone = false;
    private boolean soulvial = true;
    protected transient Predicate<ResourceLocation> filter = always -> false;
    private static final Pattern WILDCARD1 = Pattern.compile("^([a-z0-9_]+|\\*):([a-z0-9_]*)\\*([a-z0-9_]*)$");
    private static final Pattern WILDCARD2 = Pattern.compile("^([a-z0-9_]*)\\*([a-z0-9_]*):([a-z0-9_]+|\\*)$");

    public void register(String recipeName, RecipeLevel recipeLevel) {
        if (this.isDefault()) {
            EntityDataRegistry.getInstance().setDefaults(this.getCostMultiplier(), this.isDisabled(), !this.isSoulvial(), this.isClone());
        } else if (this.isBoss()) {
            CapturedMob.setBossesBlacklisted(!this.isSoulvial());
        } else {
            EntityDataRegistry.getInstance().addEntityData(this.name, this.filter, this.getCostMultiplier(), this.isDisabled(), !this.isSoulvial(), this.isClone());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (!this.name.isPresent()) {
            throw new InvalidRecipeConfigException("Entity name must be set");
        }
        String name = this.name.get();
        if (name.equals("*") || name.equals("*:*")) {
            this.isDefault = true;
            return this;
        } else {
            if (name.equals("*boss*") || name.equals("*:*boss*")) {
                this.isBoss = true;
                if (this.disabled) {
                    throw new InvalidRecipeConfigException("Cannot set the 'all modded bosses' entry to 'disabled' (set 'soulvial' to false instead)");
                }
                if (!this.clone) return this;
                throw new InvalidRecipeConfigException("Cannot set the 'all modded bosses' entry to 'clone'");
            }
            if (name.contains("*")) {
                Matcher matcher1 = WILDCARD1.matcher(name);
                Matcher matcher2 = WILDCARD2.matcher(name);
                if (matcher1.matches()) {
                    this.filter = new ResourceLocationMatcher(matcher1.group(1), null, null, null, matcher1.group(2), matcher1.group(3));
                    return this;
                } else {
                    if (!matcher2.matches()) throw new InvalidRecipeConfigException("'" + name + "' is not a valid wildcard pattern");
                    this.filter = new ResourceLocationMatcher(null, matcher2.group(1), matcher2.group(2), matcher2.group(3), null, null);
                }
                return this;
            } else {
                ResourceLocation entityId = new ResourceLocation(name.trim());
                this.filter = id -> entityId.equals(id);
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            Log.warn("Could not find an entity for '" + this.name.get() + "'");
            Log.warn("Available entities are:");
            for (CapturedMob possible : CapturedMob.getAllSouls()) {
                Log.warn(" -> " + possible.getEntityName() + " (" + possible.getDisplayName() + ")");
            }
            throw new InvalidRecipeConfigException("Could not find an entity for '" + this.name.get() + "'");
        }
    }

    @Override
    public boolean isValid() {
        if (this.isDefault || this.isBoss) {
            return true;
        }
        for (CapturedMob possible : CapturedMob.getAllSouls()) {
            if (!this.filter.test(possible.getEntityName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        if ("costMultiplier".equals(name)) {
            try {
                this.costMultiplier = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'amount': Not a number");
            }
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        if ("clone".equals(name)) {
            this.clone = Boolean.parseBoolean(value);
            return true;
        }
        if ("soulvial".equals(name)) {
            this.soulvial = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    public double getCostMultiplier() {
        return this.costMultiplier;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    public boolean isClone() {
        return this.clone;
    }

    public boolean isSoulvial() {
        return this.soulvial;
    }

    private static class ResourceLocationMatcher
    implements Predicate<ResourceLocation> {
        @Nullable
        private final String modid;
        @Nullable
        private final String modidPre;
        @Nullable
        private final String modidPost;
        @Nullable
        private final String id;
        @Nullable
        private final String pre;
        @Nullable
        private final String post;

        @Nullable
        private static String fix(@Nullable String id) {
            return id == null || id.trim().isEmpty() || "*".equals(id.trim()) ? null : id;
        }

        ResourceLocationMatcher(@Nullable String modid, @Nullable String modidPre, @Nullable String modidPost, @Nullable String id, @Nullable String pre, @Nullable String post) {
            this.modid = ResourceLocationMatcher.fix(modid);
            this.modidPre = ResourceLocationMatcher.fix(modidPre);
            this.modidPost = ResourceLocationMatcher.fix(modidPost);
            this.id = ResourceLocationMatcher.fix(id);
            this.pre = ResourceLocationMatcher.fix(pre);
            this.post = ResourceLocationMatcher.fix(post);
        }

        @Override
        public boolean test(@Nullable ResourceLocation t) {
            return !(t == null || this.modid != null && !t.func_110624_b().equals(this.modid) || this.modidPre != null && !t.func_110624_b().startsWith(this.modidPre) || this.modidPost != null && !t.func_110624_b().endsWith(this.modidPost) || this.id != null && !t.func_110623_a().equals(this.id) || this.pre != null && !t.func_110623_a().startsWith(this.pre) || this.post != null && !t.func_110623_a().endsWith(this.post));
        }
    }
}

