/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RecipeTooltipFontRenderer
extends FontRenderer {
    @Nonnull
    private static final String RECIPE_BASE = "#RECIPE";
    @Nonnull
    public static final String RECIPE_END = "#";
    @Nonnull
    private static final String RECIPE_ID_MARKER = "=";
    @Nonnull
    public static final String RECIPE = "#RECIPE#";
    @Nonnull
    public static final String RECIPE_ID = "#RECIPE=";
    @Nonnull
    private static final String MATCHER = "#RECIPE=?([^#]*)#";
    private static final Pattern PATTERN = Pattern.compile("#RECIPE=?([^#]*)#");
    private static final int BORDER = 1;
    private static final int MARGIN = 1;
    private static final int ITEM = 16;
    private static final int S1 = 2;
    private static final int S2 = 21;
    private static final int S3 = 40;
    private static final int WIDTH = 19;
    private static final int FULL_WIDTH = 58;
    @Nonnull
    private static final NNList<Point> LOCS = new NNList((Object[])new Point[]{new Point(2, 2), new Point(21, 2), new Point(40, 2), new Point(2, 21), new Point(21, 21), new Point(40, 21), new Point(2, 40), new Point(21, 40), new Point(40, 40)});
    @Nonnull
    protected final GuiContainerBaseEIO<?> gui;
    @Nonnull
    protected final Map<String, NNList<ItemStack>> recipes = new HashMap<String, NNList<ItemStack>>();

    public RecipeTooltipFontRenderer(@Nonnull GuiContainerBaseEIO<?> gui) {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            this.func_78264_a(Minecraft.func_71410_x().func_152349_b());
            this.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        this.func_110549_a(null);
        this.gui = gui;
    }

    public void registerRecipe(String id, @Nonnull NNList<ItemStack> recipe) {
        this.recipes.put(id, recipe);
    }

    public int func_78256_a(@Nonnull String text) {
        Matcher match = PATTERN.matcher(text);
        if (match.find()) {
            int width = super.func_78256_a(match.replaceFirst(""));
            return 58 + (width > 0 ? width + 2 : 0);
        }
        return super.func_78256_a(text);
    }

    @Nonnull
    public List<String> func_78271_c(@Nonnull String text, int wrapWidth) {
        List result = super.func_78271_c(text, wrapWidth);
        if (result.size() > 1 && PATTERN.matcher(text).find()) {
            for (int i = 0; i < result.size(); ++i) {
                if (PATTERN.matcher((CharSequence)result.get(i)).find()) continue;
                result.set(i, RECIPE + (String)result.get(i));
            }
        }
        return result;
    }

    public int func_175063_a(@Nonnull String text, float x, float y, int color) {
        Matcher match = PATTERN.matcher(text);
        if (match.find()) {
            String id = match.group(1);
            if (id != null && !id.isEmpty()) {
                this.drawRecipeAt((int)x, (int)y, id, color);
            }
            return super.func_175063_a(match.replaceFirst(""), x + 58.0f + 2.0f, y, color);
        }
        return super.func_175063_a(text, x, y, color);
    }

    protected void drawRecipeAt(int x, int y, @Nonnull String id, int color) {
        float old = this.gui.setZLevel(300.0f);
        this.gui.func_73733_a(x + 0, y + 0, x + 57 + 1, y + 57 + 1, color & 0xFF7F7F7F, color & 0xFF7F7F7F);
        for (int r = 0; r < 4; ++r) {
            this.gui.func_73733_a(x + 0, y + r * 19, x + 57 + 1, y + r * 19 + 1, color, color);
            this.gui.func_73733_a(x + r * 19, y + 0, x + r * 19 + 1, y + 57 + 1, color, color);
        }
        this.gui.setZLevel(old);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        old = renderItem.field_77023_b;
        renderItem.field_77023_b = 400.0f;
        int pos = 0;
        for (ItemStack stack : (NNList)NullHelper.first((Object[])new NNList[]{this.recipes.get(id), NNList.emptyList()})) {
            Point point = (Point)LOCS.get(pos++);
            this.gui.drawFakeItemStack(x + point.x, y + point.y, stack);
        }
        renderItem.field_77023_b = old;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }
}

