/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.conduitprobe;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.power.forge.tile.ILegacyPoweredTile;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConduitProbe
implements IMessage {
    private long pos;
    private EnumFacing side;

    public static boolean canCreatePacket(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IConduitBundle) {
            return true;
        }
        if (te instanceof ILegacyPoweredTile) {
            return true;
        }
        return te instanceof IHasConduitProbeData;
    }

    public PacketConduitProbe() {
    }

    public PacketConduitProbe(@Nonnull BlockPos pos, EnumFacing side) {
        this.pos = pos.func_177986_g();
        this.side = side;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
        if (this.side == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(this.side.ordinal());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.pos = buffer.readLong();
        short ord = buffer.readShort();
        this.side = ord < 0 ? null : EnumFacing.field_82609_l[ord];
    }

    public static interface IHasConduitProbeData {
        @Nonnull
        public NNList<ITextComponent> getConduitProbeInformation(@Nonnull EntityPlayer var1, @Nullable EnumFacing var2);
    }

    public static class Handler
    implements IMessageHandler<PacketConduitProbe, IMessage> {
        @Nonnull
        private static final TextComponentString NOTEXT = new TextComponentString("");

        public IMessage onMessage(PacketConduitProbe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            BlockPos pos = BlockPos.func_177969_a((long)message.pos);
            if (!world.func_175667_e(pos)) {
                return null;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IHasConduitProbeData) {
                ((IHasConduitProbeData)te).getConduitProbeInformation((EntityPlayer)player, message.side).forEach(arg_0 -> Handler.lambda$onMessage$0((EntityPlayer)player, arg_0));
            }
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(EntityPlayer player, ITextComponent elem) {
            player.func_145747_a((ITextComponent)NullHelper.first((Object[])new ITextComponent[]{elem, NOTEXT}));
        }
    }
}

