/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.handler.darksteel.DarkSteelTooltipManager;
import crazypants.enderio.base.item.darksteel.SlotNeighborHelper;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio")
public class ItemInventoryCharger
extends Item
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IOverlayRenderAware {
    @Nonnull
    private final ICapacitorKey energyStorageKey;
    @Nonnull
    private final ICapacitorKey energyInputKey;
    @Nonnull
    private final ICapacitorKey energyUseKey;
    private final boolean rangeLimited;

    public static ItemInventoryCharger createSimple(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemInventoryCharger res = new ItemInventoryCharger(modObject, CapacitorKey.DARK_STEEL_CHARGER_SIMPLE_ENERGY_BUFFER, CapacitorKey.DARK_STEEL_CHARGER_SIMPLE_ENERGY_INPUT, CapacitorKey.DARK_STEEL_CHARGER_SIMPLE_ENERGY_USE, true);
        return res;
    }

    public static ItemInventoryCharger createBasic(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemInventoryCharger res = new ItemInventoryCharger(modObject, CapacitorKey.DARK_STEEL_CHARGER_BASIC_ENERGY_BUFFER, CapacitorKey.DARK_STEEL_CHARGER_BASIC_ENERGY_INPUT, CapacitorKey.DARK_STEEL_CHARGER_BASIC_ENERGY_USE, false);
        return res;
    }

    public static ItemInventoryCharger create(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemInventoryCharger res = new ItemInventoryCharger(modObject, CapacitorKey.DARK_STEEL_CHARGER_ENERGY_BUFFER, CapacitorKey.DARK_STEEL_CHARGER_ENERGY_INPUT, CapacitorKey.DARK_STEEL_CHARGER_ENERGY_USE, false);
        return res;
    }

    public static ItemInventoryCharger createVibrant(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemInventoryCharger res = new ItemInventoryCharger(modObject, CapacitorKey.DARK_STEEL_CHARGER_VIBRANT_ENERGY_BUFFER, CapacitorKey.DARK_STEEL_CHARGER_VIBRANT_ENERGY_INPUT, CapacitorKey.DARK_STEEL_CHARGER_VIBRANT_ENERGY_USE, false);
        return res;
    }

    protected ItemInventoryCharger(@Nonnull IModObject modObject, @Nonnull ICapacitorKey energyStorageKey, @Nonnull ICapacitorKey energyInputKey, @Nonnull ICapacitorKey energyUseKey, boolean rangeLimited) {
        this.energyStorageKey = energyStorageKey;
        this.energyInputKey = energyInputKey;
        this.energyUseKey = energyUseKey;
        this.rangeLimited = rangeLimited;
        modObject.apply(this);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(0)).addToItem(is, this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            list.add((Object)is);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && EnderIO.proxy.getServerTickCount() % 20L == 0L && (player = event.player) != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
                if (!(stackInSlot.func_77973_b() instanceof ItemInventoryCharger)) continue;
                ((ItemInventoryCharger)stackInSlot.func_77973_b()).charge(player, stackInSlot, i);
            }
        }
    }

    public void charge(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, int slot) {
        EnergyUpgrade.EnergyUpgradeHolder eu;
        if (NbtValue.ENABLED.getBoolean(stack) && (eu = EnergyUpgradeManager.loadFromItem(stack)) != null && eu.getEnergy() > 0) {
            for (int i : this.rangeLimited ? SlotNeighborHelper.getSlotNeighors(slot) : SlotNeighborHelper.getAllSlots()) {
                int added;
                IEnergyStorage cap;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
                if (stackInSlot.func_77973_b() instanceof ItemInventoryCharger || !Prep.isValid(stackInSlot) || (cap = PowerHandlerUtil.getCapability((ICapabilityProvider)stackInSlot, null)) == null || !cap.canReceive() || cap.getEnergyStored() >= cap.getMaxEnergyStored() || (added = cap.receiveEnergy(eu.extractEnergy(eu.getEnergy(), true), false)) <= 0) continue;
                eu.extractEnergy(added, false);
                eu.writeToItem();
                if (eu.getEnergy() > 0) continue;
                return;
            }
        }
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return NbtValue.ENABLED.getBoolean(stack) || super.func_77636_d(stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                this.openUpgradeGui(playerIn, handIn);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (EnergyUpgradeManager.loadFromItem(stack) != null) {
            if (!worldIn.field_72995_K) {
                NbtValue.ENABLED.setBoolean(stack, !NbtValue.ENABLED.getBoolean(stack));
                playerIn.func_146105_b((ITextComponent)(NbtValue.ENABLED.getBoolean(stack) ? Lang.INVCHARGER_ENABLED : Lang.INVCHARGER_DISABLED).toChatServer(), true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        if (EnergyUpgradeManager.loadFromItem(itemstack) == null) {
            list.add(Lang.INVCHARGER_NEEDUPGRADE.get());
        }
        DarkSteelTooltipManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelTooltipManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str = EnergyUpgradeManager.getStoredEnergyString(itemstack);
        if (str != null) {
            list.add(str);
        }
        DarkSteelTooltipManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable_vert.render(stack, xPosition, yPosition);
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.OFFHAND;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return EquipmentData.DARK_STEEL;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return this.energyStorageKey;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return this.energyInputKey;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return this.energyUseKey;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.NO_POWER;
    }

    @Override
    public boolean allowExtractEnergy() {
        return true;
    }
}

