/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.anvil;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.lang.Lang;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class AnvilUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "anvil";
    @Nonnull
    public static final NNList<AnvilUpgrade> INSTANCES = new NNList((Object[])new AnvilUpgrade[]{new AnvilUpgrade(0), new AnvilUpgrade(1), new AnvilUpgrade(2)});

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        INSTANCES.apply(instance -> event.getRegistry().register((IForgeRegistryEntry)instance));
    }

    public static AnvilUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        int level = ((AnvilUpgrade)INSTANCES.get(0)).getUpgradeVariantLevel(stack);
        return level < 0 ? null : (AnvilUpgrade)INSTANCES.get(level);
    }

    public static AnvilUpgrade getHighestEquippedUpgrade(@Nonnull EntityPlayer player) {
        int level = -1;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            level = Math.max(level, ((AnvilUpgrade)INSTANCES.get(0)).getUpgradeVariantLevel(player.func_184582_a((EntityEquipmentSlot)NullHelper.notnullJ((Object)slot, (String)"Enum.values()"))));
        }
        return level < 0 ? null : (AnvilUpgrade)INSTANCES.get(level);
    }

    public AnvilUpgrade(int level) {
        super(UPGRADE_NAME, level, "enderio.darksteel.upgrade.anvil." + level, (IValue<Integer>)((IValue)DarkSteelConfig.anvilUpgradeCost.get(level)));
    }

    @Override
    @Nonnull
    public List<IRule> getRules() {
        return new NNList((Object[])new IRule[]{Rules.withLevels(this.variant, INSTANCES), Rules.itemTypeTooltip(Lang.DSU_CLASS_EVERYTHING), Rules.staticCheck(item -> !(item instanceof INoAnvilUpgrade))});
    }

    public boolean allowsEditingOtherEquippedItems() {
        return this.variant >= 1;
    }

    public boolean allowsEditingSlotItems() {
        return this.variant >= 2;
    }

    public boolean allowsAnvilRecipes() {
        return this.variant >= 2;
    }

    public static interface INoAnvilUpgrade {
    }
}

