/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.jump;

import com.enderio.core.client.ClientUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class JumpUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "jumpBoost";
    private static final String[] numbers = new String[]{"one", "two", "three"};
    @Nonnull
    public static final JumpUpgrade JUMP_ONE = new JumpUpgrade(1);
    @Nonnull
    public static final JumpUpgrade JUMP_TWO = new JumpUpgrade(2);
    @Nonnull
    public static final JumpUpgrade JUMP_THREE = new JumpUpgrade(3);
    @Nonnull
    public static final IRule.Prerequisite HAS_ANY = new IRule.Prerequisite(){

        @Override
        @Nonnull
        public IRule.CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
            for (JumpUpgrade upgrade : new JumpUpgrade[]{JUMP_ONE, JUMP_TWO, JUMP_THREE}) {
                if (!upgrade.hasUpgrade(stack, item)) continue;
                return IRule.CheckResult.PASS;
            }
            return new IRule.CheckResult((ITextComponent)Lang.DSU_CHECK_PREREQ_MISSING.toChatServer(new TextComponentTranslation(JUMP_ONE.getUnlocalizedName() + ".name", new Object[0])));
        }

        @Override
        @Nonnull
        public IDarkSteelUpgrade getPrerequisite() {
            return JUMP_ONE;
        }
    };
    private final short level;

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)JUMP_ONE);
        event.getRegistry().register((IForgeRegistryEntry)JUMP_TWO);
        event.getRegistry().register((IForgeRegistryEntry)JUMP_THREE);
    }

    public static JumpUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (JUMP_THREE.hasUpgrade(stack)) {
            return JUMP_THREE;
        }
        if (JUMP_TWO.hasUpgrade(stack)) {
            return JUMP_TWO;
        }
        if (JUMP_ONE.hasUpgrade(stack)) {
            return JUMP_ONE;
        }
        return null;
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return JumpUpgrade.loadAnyFromItem(player.func_184582_a(EntityEquipmentSlot.FEET)) != null;
    }

    public JumpUpgrade(int level) {
        super(UPGRADE_NAME, level, "enderio.darksteel.upgrade.jump_" + numbers[level - 1], (IValue<Integer>)((IValue)DarkSteelConfig.jumpUpgradeCost.get(level - 1)));
        this.level = (short)level;
    }

    @Override
    protected int getMinVariant() {
        return 1;
    }

    @Override
    @Nonnull
    public List<IRule> getRules() {
        return new NNList((Object[])new IRule[]{Rules.forSlot(EntityEquipmentSlot.FEET), EnergyUpgrade.HAS_ANY, Rules.withLevels((int)this.level, null, JUMP_ONE, JUMP_TWO), Rules.itemTypeTooltip(EntityEquipmentSlot.FEET)});
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    public short getLevel() {
        return this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doMultiplayerSFX(@Nonnull EntityPlayer player) {
        SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.JUMP, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.75f);
        Random rand = player.field_70170_p.field_73012_v;
        for (int i = rand.nextInt(10) + 5; i >= 0; --i) {
            double posX = player.field_70165_t + (rand.nextDouble() * 0.5 - 0.25);
            double posY = player.field_70163_u - player.func_70033_W();
            double posZ = player.field_70161_v + (rand.nextDouble() * 0.5 - 0.25);
            double velX = (player instanceof EntityOtherPlayerMP ? 0.0 : player.field_70159_w) + (rand.nextDouble() * 0.5 - 0.25);
            double velY = (player instanceof EntityOtherPlayerMP ? 0.0 : player.field_70181_x / 2.0) + rand.nextDouble() * -0.5;
            double velZ = (player instanceof EntityOtherPlayerMP ? 0.0 : player.field_70179_y) + (rand.nextDouble() * 0.5 - 0.25);
            Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), posX, posY, posZ, 1.0, 1.0, 1.0, new int[0]);
            ClientUtil.setParticleVelocity((Particle)fx, (double)velX, (double)velY, (double)velZ);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)NullHelper.notnullM((Object)fx, (String)"spawnEffectParticle() failed unexptedly"));
        }
    }

    @Override
    public boolean keybindingDefault() {
        return true;
    }
}

