/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.model;

import com.enderio.core.common.vecmath.Vector4d;
import crazypants.enderio.base.EnderIO;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class RotatingSmartItemModel
implements IBakedModel {
    @Nonnull
    private final IBakedModel parent;
    @Nonnull
    private final Function<ItemCameraTransforms.TransformType, Vector4d> rots;
    @Nonnull
    private final ItemOverrideList overrides = new ItemOverrideList(new ArrayList()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (originalModel != RotatingSmartItemModel.this) {
                return originalModel;
            }
            IBakedModel newBase = RotatingSmartItemModel.this.parent.func_188617_f().handleItemState(RotatingSmartItemModel.this.parent, stack, world, entity);
            if (RotatingSmartItemModel.this.parent != newBase) {
                return new RotatingSmartItemModel(newBase, RotatingSmartItemModel.this.rots);
            }
            return RotatingSmartItemModel.this;
        }
    };

    public RotatingSmartItemModel(@Nonnull IBakedModel parent, @Nonnull Function<ItemCameraTransforms.TransformType, Vector4d> rots) {
        this.parent = parent;
        this.rots = rots;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.parent.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        Pair perspective = this.parent.handlePerspective(cameraTransformType);
        Vector4d rot = this.rots.apply(cameraTransformType);
        if (rot == null) {
            return perspective;
        }
        double r = (float)(EnderIO.proxy.getTickCount() % 360L) + (Minecraft.func_71410_x().func_147113_T() ? 0.0f : Minecraft.func_71410_x().func_184121_ak());
        TRSRTransformation transformOrig = new TRSRTransformation((Matrix4f)perspective.getRight());
        Quat4f leftRot = transformOrig.getLeftRot();
        Quat4f dynamicRotation = new Quat4f();
        dynamicRotation.set(new AxisAngle4d(rot.x, rot.y, rot.z, Math.toRadians(r * rot.w)));
        dynamicRotation.normalize();
        leftRot.mul(dynamicRotation);
        TRSRTransformation transformNew = new TRSRTransformation(transformOrig.getTranslation(), leftRot, transformOrig.getScale(), transformOrig.getRightRot());
        return Pair.of((Object)perspective.getLeft(), (Object)transformNew.getMatrix());
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

