/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.scheduler;

import crazypants.enderio.base.scheduler.Event;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public final class Scheduler
extends Thread {
    public static final Scheduler instance = new Scheduler();
    private final List<Event> events = new ArrayList<Event>();

    public void registerEvent(Event event) {
        if (this.isAlive()) {
            throw new RuntimeException("Bad state");
        }
        event.calculate(Calendar.getInstance(Locale.getDefault()));
        this.events.add(event);
    }

    private Scheduler() {
        super("Ender IO Scheduler");
    }

    @Override
    public void run() {
        while (!this.events.isEmpty()) {
            try {
                Calendar cal = Calendar.getInstance(Locale.getDefault());
                for (Event event : this.events) {
                    if (!event.isActive(cal)) continue;
                    event.run(cal);
                }
                Collections.sort(this.events, new Sorter(cal));
                long tts = this.events.get(0).getTimeToStart(cal);
                if (tts > 0L) {
                    Scheduler.sleep(tts);
                    continue;
                }
                if (tts < 0L) {
                    this.events.remove(0);
                }
                Scheduler.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class Sorter
    implements Comparator<Event> {
        private final Calendar cal;

        Sorter(Calendar cal) {
            this.cal = cal;
        }

        @Override
        public int compare(Event o1, Event o2) {
            long tts1 = o1.getTimeToStart(this.cal);
            long tts2 = o2.getTimeToStart(this.cal);
            return Long.compare(tts1, tts2);
        }
    }
}

