/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.teleport.packet;

import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.sound.SoundHelper;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTravelEvent
implements IMessage {
    long pos;
    int powerUse;
    boolean conserveMotion;
    int source;
    int hand;

    public PacketTravelEvent() {
    }

    public PacketTravelEvent(BlockPos pos, int powerUse, boolean conserveMotion, TravelSource source, EnumHand hand) {
        this.pos = pos.func_177986_g();
        this.powerUse = powerUse;
        this.conserveMotion = conserveMotion;
        this.source = source.ordinal();
        this.hand = (hand == null ? EnumHand.MAIN_HAND : hand).ordinal();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
        buf.writeInt(this.powerUse);
        buf.writeBoolean(this.conserveMotion);
        buf.writeInt(this.source);
        buf.writeInt(this.hand);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
        this.powerUse = buf.readInt();
        this.conserveMotion = buf.readBoolean();
        this.source = buf.readInt();
        this.hand = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketTravelEvent, IMessage> {
        public IMessage onMessage(PacketTravelEvent message, MessageContext ctx) {
            EntityPlayerMP toTp = ctx.getServerHandler().field_147369_b;
            TravelSource source = (TravelSource)((Object)NullHelper.notnullJ((Object)((Object)TravelSource.values()[message.source]), (String)"Enum.values()"));
            EnumHand hand = (EnumHand)NullHelper.notnullJ((Object)EnumHand.values()[message.hand], (String)"Enum.values()");
            this.doServerTeleport((Entity)toTp, BlockPos.func_177969_a((long)message.pos), message.powerUse, message.conserveMotion, source, hand);
            return null;
        }

        private boolean doServerTeleport(@Nonnull Entity toTp, @Nonnull BlockPos pos, int powerUse, boolean conserveMotion, @Nonnull TravelSource source, @Nonnull EnumHand hand) {
            EntityPlayer player = toTp instanceof EntityPlayer ? (EntityPlayer)toTp : null;
            TeleportEntityEvent evt = new TeleportEntityEvent(toTp, source, pos, toTp.field_71093_bK);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                return false;
            }
            pos = evt.getTarget();
            SoundHelper.playSound(toTp.field_70170_p, toTp, source.sound, 1.0f, 1.0f);
            if (player != null) {
                player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5);
            } else {
                toTp.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            SoundHelper.playSound(toTp.field_70170_p, toTp, source.sound, 1.0f, 1.0f);
            toTp.field_70143_R = 0.0f;
            if (player != null) {
                ItemStack heldItem;
                if (conserveMotion) {
                    Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
                    SPacketEntityVelocity p = new SPacketEntityVelocity(toTp.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)p);
                }
                if (powerUse > 0 && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof IItemOfTravel) {
                    ItemStack item = heldItem.func_77946_l();
                    ((IItemOfTravel)item.func_77973_b()).extractInternal(item, powerUse);
                    player.func_184611_a(hand, item);
                }
            }
            return true;
        }
    }
}

