/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.invpanel;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.gui.widget.VScrollbar;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.block.skull.BlockEndermanSkull;
import crazypants.enderio.base.block.skull.SkullType;
import crazypants.enderio.base.gui.BlockSceneRenderer;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.RecipeTooltipFontRenderer;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.JeiAccessor;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.machine.gui.GuiMachineBase;
import crazypants.enderio.invpanel.client.CraftingHelper;
import crazypants.enderio.invpanel.client.DatabaseView;
import crazypants.enderio.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.invpanel.client.ItemEntry;
import crazypants.enderio.invpanel.client.SortOrder;
import crazypants.enderio.invpanel.config.InvpanelConfig;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import crazypants.enderio.invpanel.network.PacketFetchItem;
import crazypants.enderio.invpanel.network.PacketGuiSettings;
import crazypants.enderio.invpanel.network.PacketHandler;
import crazypants.enderio.invpanel.network.PacketSetExtractionDisabled;
import crazypants.enderio.invpanel.util.StoredCraftingRecipe;
import crazypants.enderio.util.Prep;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class GuiInventoryPanel
extends GuiMachineBase<TileInventoryPanel> {
    @Nonnull
    private static final Rectangle RECTANGLE_FUEL_TANK = new Rectangle(12, 149, 16, 47);
    @Nonnull
    private static final Rectangle inventoryArea = new Rectangle(107, 27, 108, 90);
    @Nonnull
    private static final Rectangle btnRefill = new Rectangle(85, 32, 20, 20);
    @Nonnull
    private static final Rectangle btnReturnArea = new Rectangle(6, 72, 90, 8);
    private static final int ID_SORT = 9876;
    private static final int ID_CLEAR = 9877;
    private static final int ID_SYNC = 9878;
    private static final int GHOST_COLUMNS = 6;
    private static final int GHOST_ROWS = 6;
    @Nonnull
    private final DatabaseView view;
    @Nonnull
    private final TextFieldEnder tfFilter;
    private String tfFilterExternalValue = null;
    @Nonnull
    private final IconButton btnSort;
    @Nonnull
    private final ToggleButton btnSync;
    @Nonnull
    private final GuiToolTip ttRefill;
    @Nonnull
    private final VScrollbar scrollbar;
    @Nonnull
    private final MultiIconButton btnClear;
    @Nonnull
    private final ItemStackButton[] repButtons = new ItemStackButton[10];
    private int scrollPos;
    private int ghostSlotTooltipStacksize;
    @Nonnull
    private final String headerCrafting;
    @Nonnull
    private final String headerReturn;
    @Nonnull
    private final String headerStorage;
    @Nonnull
    private final String headerInventory;
    @Nonnull
    private final String infoTextFilter;
    @Nonnull
    private final String infoTextOffline;
    @Nonnull
    private final String infoTextNoConnection;
    private CraftingHelper craftingHelper;
    @Nonnull
    private final RecipeTooltipFontRenderer rtfr;
    @Nonnull
    private final BlockSceneRenderer bsr_active = new BlockSceneRenderer((NNList<Pair<BlockPos, IBlockState>>)new NNList((Object[])new Pair[]{Pair.of((Object)new BlockPos(0, 0, 0), (Object)ModObject.blockEndermanSkull.getBlock().func_176223_P().func_177226_a(BlockEndermanSkull.VARIANT, (Comparable)((Object)SkullType.REANIMATED_TORMENTED)))}));
    @Nonnull
    private final BlockSceneRenderer bsr_offline = new BlockSceneRenderer((NNList<Pair<BlockPos, IBlockState>>)new NNList((Object[])new Pair[]{Pair.of((Object)new BlockPos(0, 0, 0), (Object)ModObject.blockEndermanSkull.getBlock().func_176223_P().func_177226_a(BlockEndermanSkull.VARIANT, (Comparable)((Object)SkullType.TORMENTED)))}));
    @Nonnull
    private final Rectangle btnAddStoredRecipe = new Rectangle();

    public GuiInventoryPanel(@Nonnull TileInventoryPanel te, @Nonnull Container container) {
        super(te, container, new String[]{"inv_panel", "inv_panel_extended"});
        this.redstoneButton.field_146125_m = false;
        this.configB.field_146125_m = false;
        this.rtfr = new RecipeTooltipFontRenderer(this);
        this.ghostSlotHandler = new GhostSlotHandler(){

            protected void ghostSlotClicked(@Nonnull GuiContainerBase gui, @Nonnull GhostSlot slot, int x, int y, int button) {
                if (slot instanceof InvSlot) {
                    GuiInventoryPanel.this.ghostSlotClicked((InvSlot)slot, x, y, button);
                } else {
                    super.ghostSlotClicked(gui, slot, x, y, button);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void drawGhostSlotToolTip_OLD(@Nonnull GuiContainerBase gui, int mouseX, int mouseY) {
                ItemStack stack;
                GhostSlot slot = this.getGhostSlotAt(gui, mouseX, mouseY);
                if (slot != null && !(stack = slot.getStack()).func_190926_b()) {
                    GuiInventoryPanel.this.ghostSlotTooltipStacksize = stack.func_190916_E();
                    try {
                        GuiInventoryPanel.this.func_146285_a(stack, mouseX, mouseY);
                    }
                    finally {
                        GuiInventoryPanel.this.ghostSlotTooltipStacksize = 0;
                    }
                }
            }
        };
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 6; ++x) {
                this.getGhostSlotHandler().add((GhostSlot)new InvSlot(108 + x * 18, 28 + y * 18));
            }
        }
        for (int i = 0; i < 10; ++i) {
            final int index = i;
            TileInventoryPanel te1 = (TileInventoryPanel)this.getTileEntity();
            StoredCraftingRecipe recipe = te1.getStoredCraftingRecipe(index);
            this.repButtons[index] = new ItemStackButton((IGuiScreen)this, 22 + index, -35, 18 + index * 20, IconEIO.QUESTION, null);
            this.addToolTip(new GuiToolTip(this.repButtons[index].getBounds(), new String[]{EnderIO.lang.localize("gui.inventorypanel.tooltip.recipe.store")}){

                public boolean shouldDraw() {
                    return super.shouldDraw() && !GuiInventoryPanel.this.repButtons[index].hasItemStack() && ((GuiInventoryPanel)GuiInventoryPanel.this).repButtons[index].field_146124_l;
                }
            });
            if (recipe == null) continue;
            ItemStack icon = recipe.getResult(te1);
            this.repButtons[index].setStack(icon);
            this.rtfr.registerRecipe("invprecipe" + index, recipe.getIngredients());
            this.addToolTip(new GuiToolTip(this.repButtons[index].getBounds(), new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    this.text.add(TextFormatting.YELLOW + GuiInventoryPanel.this.repButtons[index].itemStackName());
                    this.text.add("#RECIPE=invprecipe" + index + "#" + TextFormatting.GRAY + EnderIO.lang.localize("gui.inventorypanel.tooltip.recipe.load"));
                    this.text.add("#RECIPE#" + TextFormatting.GRAY + EnderIO.lang.localize("gui.inventorypanel.tooltip.recipe.loadstacks"));
                    this.text.add("#RECIPE#" + TextFormatting.GRAY + EnderIO.lang.localize("gui.inventorypanel.tooltip.recipe.delete"));
                    this.text.add("#RECIPE#");
                    this.text.add("#RECIPE#");
                    this.text.add("#RECIPE#");
                }

                public boolean shouldDraw() {
                    return super.shouldDraw() && GuiInventoryPanel.this.repButtons[index].hasItemStack() && ((GuiInventoryPanel)GuiInventoryPanel.this).repButtons[index].field_146124_l;
                }
            });
        }
        this.view = new DatabaseView();
        int sortMode = te.getGuiSortMode();
        int sortOrderIdx = sortMode >> 1;
        SortOrder[] orders = SortOrder.values();
        if (sortOrderIdx >= 0 && sortOrderIdx < orders.length) {
            this.view.setSortOrder(orders[sortOrderIdx], (sortMode & 1) != 0);
        }
        this.tfFilter = new TextFieldEnder(this.getFontRenderer(), 108, 11, 106, 10);
        this.tfFilter.func_146185_a(false);
        this.tfFilter.func_146180_a(te.getGuiFilterString());
        this.btnSync = new ToggleButton((IGuiScreen)this, 9878, 233, 46, (IWidgetIcon)IconEIO.CROSS, (IWidgetIcon)IconEIO.TICK);
        this.btnSync.setSelected(((TileInventoryPanel)this.getTileEntity()).getGuiSync());
        this.btnSync.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled")});
        this.btnSync.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
        if (JeiAccessor.isJeiRuntimeAvailable()) {
            this.btnSync.setToolTip(new String[]{EnderIO.lang.localize("gui.inventorypanel.tooltip.sync.jei")});
            this.btnSync.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled"), EnderIO.lang.localize("gui.inventorypanel.tooltip.sync.jei.line1"), EnderIO.lang.localize("gui.inventorypanel.tooltip.sync.jei.line2")});
            this.btnSync.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
            if (((TileInventoryPanel)this.getTileEntity()).getGuiSync()) {
                if (!te.getGuiFilterString().isEmpty()) {
                    this.updateToJEI(te.getGuiFilterString());
                } else {
                    this.updateFromJEI();
                }
            }
        } else {
            this.btnSync.setToolTip(new String[]{EnderIO.lang.localize("gui.inventorypanel.tooltip.sync")});
            this.btnSync.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled")});
            this.btnSync.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
            this.btnSync.field_146124_l = false;
        }
        this.btnSort = new IconButton((IGuiScreen)this, 9876, 233, 27, this.getSortOrderIcon()){

            public boolean func_146116_c(@Nonnull Minecraft mc1, int xIn, int yIn) {
                return this.mousePressedButton(mc1, xIn, yIn, 0);
            }

            public boolean mousePressedButton(@Nonnull Minecraft mc1, int xIn, int yIn, int button) {
                if (button <= 1 && super.checkMousePress(mc1, xIn, yIn)) {
                    GuiInventoryPanel.this.toggleSortOrder(button == 0);
                    return true;
                }
                return false;
            }
        };
        this.scrollbar = new VScrollbar((IGuiScreen)this, 215, 27, 108);
        this.btnClear = new MultiIconButton((IGuiScreen)this, 9877, 65, 60, (IWidgetIcon)EnderWidget.X_BUT, (IWidgetIcon)EnderWidget.X_BUT_PRESSED, (IWidgetIcon)EnderWidget.X_BUT_HOVER);
        this.textFields.add((Object)this.tfFilter);
        this.headerCrafting = EnderIO.lang.localize("gui.inventorypanel.header.crafting");
        this.headerReturn = EnderIO.lang.localize("gui.inventorypanel.header.return");
        this.headerStorage = EnderIO.lang.localize("gui.inventorypanel.header.storage");
        this.headerInventory = EnderIO.lang.localizeExact("container.inventory");
        this.infoTextFilter = EnderIO.lang.localize("gui.inventorypanel.info.filter");
        this.infoTextOffline = EnderIO.lang.localize("gui.inventorypanel.info.offline");
        this.infoTextNoConnection = EnderIO.lang.localize("gui.inventorypanel.info.noconnection");
        ArrayList list = new ArrayList();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.return.line");
        this.addToolTip(new GuiToolTip(btnReturnArea, list){

            public boolean shouldDraw() {
                return super.shouldDraw() && !((TileInventoryPanel)GuiInventoryPanel.this.getTileEntity()).isExtractionDisabled();
            }
        });
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.storage.line");
        this.addToolTip(new GuiToolTip(btnReturnArea, list){

            public boolean shouldDraw() {
                return super.shouldDraw() && ((TileInventoryPanel)GuiInventoryPanel.this.getTileEntity()).isExtractionDisabled();
            }
        });
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.filterslot.line");
        this.addToolTip(new GuiToolTip(new Rectangle(233, 7, 16, 16), list){

            public boolean shouldDraw() {
                return !GuiInventoryPanel.this.getContainer().getSlotFilter().func_75216_d() && super.shouldDraw();
            }
        });
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.refill.line");
        this.ttRefill = new GuiToolTip(btnRefill, list);
        this.ttRefill.setIsVisible(false);
        this.addToolTip(this.ttRefill);
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.clear.line");
        this.btnClear.setToolTip(list.toArray(new String[list.size()]));
        if (!((Boolean)InvpanelConfig.inventoryPanelFree.get()).booleanValue()) {
            this.addToolTip(new GuiToolTip(RECTANGLE_FUEL_TANK, new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    this.text.add(EnderIO.lang.localize("gui.inventorypanel.tooltip.fuelTank"));
                    this.text.add(LangFluid.MB((IFluidTank)((TileInventoryPanel)((GuiInventoryPanel)GuiInventoryPanel.this).getTileEntity()).fuelTank));
                }
            });
        }
        list.clear();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)"enderio.gui.inventorypanel.tooltip.addrecipe.line");
        this.addToolTip(new GuiToolTip(this.btnAddStoredRecipe, list));
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_FUEL_TANK.contains(mouseX, mouseY)) {
            return ((TileInventoryPanel)this.getTileEntity()).fuelTank.getFluid();
        }
        GhostSlot slot = this.getGhostSlotHandler().getGhostSlotAt((GuiContainerBase)this, mouseX + this.getGuiLeft(), mouseY + this.getGuiTop());
        if (slot instanceof InvSlot) {
            return slot.getStack();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    public void syncSettingsChange() {
        int sortMode = this.view.getSortOrder().ordinal() << 1;
        if (this.view.isSortOrderInverted()) {
            sortMode |= 1;
        }
        String filterText = !this.btnSync.isSelected() || this.tfFilterExternalValue == null || !this.tfFilterExternalValue.equals(this.tfFilter.func_146179_b()) ? this.tfFilter.func_146179_b() : "";
        if (((TileInventoryPanel)this.getTileEntity()).getGuiSortMode() != sortMode || ((TileInventoryPanel)this.getTileEntity()).getGuiSync() != this.btnSync.isSelected() || !StringUtils.equals((CharSequence)((TileInventoryPanel)this.getTileEntity()).getGuiFilterString(), (CharSequence)filterText)) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGuiSettings(this.getContainer().field_75152_c, sortMode, filterText, this.btnSync.isSelected()));
            ((TileInventoryPanel)this.getTileEntity()).setGuiParameter(sortMode, this.tfFilter.func_146179_b(), this.btnSync.isSelected());
        }
    }

    public void setCraftingHelper(CraftingHelper craftingHelper) {
        if (this.craftingHelper != null) {
            this.craftingHelper.remove();
        }
        this.craftingHelper = craftingHelper;
        this.ttRefill.setIsVisible(craftingHelper != null);
        if (craftingHelper != null) {
            craftingHelper.install();
        }
    }

    public void fillFromStoredRecipe(int index, boolean shift) {
        StoredCraftingRecipe recipe = ((TileInventoryPanel)this.getTileEntity()).getStoredCraftingRecipe(index);
        if (recipe == null) {
            return;
        }
        if (this.getContainer().clearCraftingGrid()) {
            CraftingHelper helper = CraftingHelper.createFromRecipe(recipe);
            this.setCraftingHelper(helper);
            helper.refill(this, shift ? 64 : 1);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateSortButton();
        this.btnSort.onGuiInit();
        this.btnClear.onGuiInit();
        this.btnSync.onGuiInit();
        this.addScrollbar(this.scrollbar);
        for (ItemStackButton button : this.repButtons) {
            if (button == null) continue;
            button.onGuiInit();
        }
        ((InventoryPanelContainer)this.field_147002_h).createGhostSlots(this.getGhostSlotHandler());
    }

    public void func_146284_a(@Nonnull GuiButton b) throws IOException {
        super.func_146284_a(b);
        if (b.field_146127_k == 9877 && this.getContainer().clearCraftingGrid()) {
            this.setCraftingHelper(null);
        }
        if (b instanceof ItemStackButton) {
            StoredCraftingRecipe recipe;
            TileInventoryPanel te;
            ItemStackButton recipeClicked = (ItemStackButton)b;
            if (recipeClicked.hasItemStack()) {
                if (GuiInventoryPanel.func_146271_m() && recipeClicked.isRightClick()) {
                    ((TileInventoryPanel)this.getTileEntity()).removeStoredCraftingRecipe(recipeClicked.field_146127_k - 22);
                    recipeClicked.clearStack();
                } else if (!recipeClicked.isRightClick()) {
                    this.fillFromStoredRecipe(recipeClicked.field_146127_k - 22, GuiInventoryPanel.func_146272_n());
                }
            } else if (!GuiInventoryPanel.func_146271_m() && (te = (TileInventoryPanel)this.getTileEntity()).getStoredCraftingRecipes() < 10 && this.getContainer().hasNewCraftingRecipe() && (recipe = new StoredCraftingRecipe()).loadFromCraftingGrid(this.getContainer().getCraftingGridSlots())) {
                this.playClickSound();
                te.addStoredCraftingRecipe(recipe);
                recipeClicked.setStack(recipe.getResult(te));
            }
        }
    }

    @Override
    protected void func_146976_a(float par1, int mouseX, int mouseY) {
        this.syncSettingsChange();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture(0);
        int sx = this.field_147003_i;
        int sy = this.field_147009_r;
        this.func_73729_b(sx, sy, 0, 0, 232, 232);
        this.func_73729_b(sx + 232, sy, 232, 0, 24, 68);
        if (this.craftingHelper != null || this.getContainer().hasCraftingRecipe()) {
            boolean hover = btnRefill.contains(mouseX - sx, mouseY - sy);
            int iconX = hover ? (GuiInventoryPanel.func_146272_n() ? 48 : 24) : 0;
            this.bindGuiTexture(1);
            this.func_73729_b(sx + GuiInventoryPanel.btnRefill.x - 2, sy + GuiInventoryPanel.btnRefill.y - 2, iconX, 232, 24, 24);
            this.bindGuiTexture(0);
        }
        TileInventoryPanel te = (TileInventoryPanel)this.getTileEntity();
        int numStoredRecipes = te.getStoredCraftingRecipes();
        this.bindGuiTexture(1);
        this.func_73729_b(sx - 42, (this.field_146295_m - 208) / 2, 0, 0, 42, 208);
        this.bindGuiTexture(0);
        for (int i = 0; i < 10; ++i) {
            if (this.repButtons[i] == null || this.repButtons[i].hasItemStack()) continue;
            this.repButtons[i].setEnabled(false);
        }
        if (numStoredRecipes < 10 && this.getContainer().hasNewCraftingRecipe() && this.repButtons[numStoredRecipes] != null) {
            this.repButtons[numStoredRecipes].setEnabled(true);
        }
        SmartTank fuelTank = te.fuelTank;
        if (!((Boolean)InvpanelConfig.inventoryPanelFree.get()).booleanValue()) {
            this.func_73729_b(sx + 11, sy + 147, 232, 163, 18, 49);
            if (fuelTank.getFluidAmount() > 0) {
                RenderUtil.renderGuiTank((FluidStack)fuelTank.getFluid(), (int)fuelTank.getCapacity(), (int)fuelTank.getFluidAmount(), (double)(sx + 12), (double)(sy + 148), (double)this.field_73735_i, (double)16.0, (double)47.0);
            }
        }
        EnderWidget returnButton = te.isExtractionDisabled() ? (btnReturnArea.contains(mouseX - sx, mouseY - sy) ? EnderWidget.STOP_BUT_HOVER : EnderWidget.STOP_BUT) : (btnReturnArea.contains(mouseX - sx, mouseY - sy) ? EnderWidget.RETURN_BUT_HOVER : EnderWidget.RETURN_BUT);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EnderWidget.RETURN_BUT.getMap().render((IWidgetIcon)returnButton, (double)(sx + 7), (double)(sy + 72), true);
        int headerColor = 0x404040;
        int focusedColor = 6587540;
        FontRenderer fr = this.getFontRenderer();
        fr.func_78276_b(this.headerCrafting, sx + 7, sy + 6, headerColor);
        fr.func_78276_b(te.isExtractionDisabled() ? this.headerStorage : this.headerReturn, sx + 7 + 10, sy + 72, btnReturnArea.contains(mouseX - sx, mouseY - sy) ? focusedColor : headerColor);
        fr.func_78276_b(this.headerInventory, sx + 38, sy + 138, headerColor);
        super.func_146976_a(par1, mouseX, mouseY);
        if (JeiAccessor.isJeiRuntimeAvailable() && this.btnSync.isSelected()) {
            this.updateFromJEI();
        }
        this.view.setDatabase(this.getDatabase());
        this.view.setItemFilter(te.getItemFilter());
        this.view.updateFilter(this.tfFilter.func_146179_b());
        boolean update = this.view.sortItems();
        this.scrollbar.setScrollMax(Math.max(0, (this.view.getNumEntries() + 6 - 1) / 6 - 6));
        if (update || this.scrollPos != this.scrollbar.getScrollPos()) {
            this.updateGhostSlots();
        }
        if (te.isActive()) {
            this.tfFilter.func_146184_c(true);
            if (!this.tfFilter.func_146206_l() && this.tfFilter.func_146179_b().isEmpty()) {
                fr.func_78276_b(this.infoTextFilter, this.tfFilter.field_146209_f, this.tfFilter.field_146210_g, 0x707070);
            }
        } else if (!te.isActive() && te.hasConnection()) {
            this.tfFilter.func_146184_c(false);
            this.setText(this.tfFilter, "");
            fr.func_78276_b(this.infoTextOffline, this.tfFilter.field_146209_f, this.tfFilter.field_146210_g, 0x707070);
        } else {
            this.tfFilter.func_146184_c(false);
            this.setText(this.tfFilter, "");
            fr.func_78276_b(this.infoTextNoConnection, this.tfFilter.field_146209_f, this.tfFilter.field_146210_g, 0x707070);
        }
        if (!((Boolean)InvpanelConfig.inventoryPanelFree.get()).booleanValue()) {
            GlStateManager.func_179094_E();
            BlockEndermanSkull.guiRender = true;
            (te.isActive() && te.hasConnection() ? this.bsr_active : this.bsr_offline).drawScreen(sx - 4, sy + 132 + 49, 48, 48);
            BlockEndermanSkull.guiRender = false;
            GlStateManager.func_179121_F();
        }
    }

    protected void onTextFieldChanged(@Nonnull TextFieldEnder tf, @Nonnull String old) {
        if (tf == this.tfFilter && this.btnSync.isSelected() && this.tfFilter.func_146206_l() && JeiAccessor.isJeiRuntimeAvailable()) {
            this.updateToJEI(this.tfFilter.func_146179_b());
        }
    }

    private void updateToJEI(String text) {
        if (text != null && !text.isEmpty()) {
            JeiAccessor.setFilterText(text);
        } else {
            JeiAccessor.setFilterText("");
        }
    }

    private void updateFromJEI() {
        String filterText = JeiAccessor.getFilterText();
        if (!filterText.isEmpty() && !filterText.equals(this.tfFilter.func_146179_b())) {
            this.tfFilter.func_146180_a(filterText);
            this.tfFilterExternalValue = filterText;
        }
    }

    public void drawFakeItemStack(int x, int y, @Nonnull ItemStack stack) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        boolean smallText = (Boolean)InvpanelConfig.inventoryPanelScaleText.get();
        String str = null;
        if (stack.func_190916_E() >= 1000) {
            String unit = "k";
            int units = 1000;
            int value = stack.func_190916_E() / units;
            if (smallText) {
                double val;
                int bit;
                if (value >= units) {
                    units *= 1000;
                    value /= 1000;
                    unit = "m";
                }
                if ((bit = (int)Math.floor((val = (double)(stack.func_190916_E() % units) / (double)units) * 10.0)) > 0) {
                    unit = "." + bit + unit;
                }
            }
            str = value + unit;
        } else if (stack.func_190916_E() > 1) {
            str = Integer.toString(stack.func_190916_E());
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        if (str != null) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + 16), (float)(y + 16), (float)0.0f);
            if (smallText) {
                float scale = 0.666666f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                font.func_175063_a(str, (float)(-font.func_78256_a(str) - 1), -8.0f, 0xFFFFFF);
                GlStateManager.func_179121_F();
            } else {
                font.func_175063_a(str, (float)(-font.func_78256_a(str)), -8.0f, 0xFFFFFF);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        this.field_146296_j.func_180453_a(font, stack, x, y, "");
    }

    public void drawHoveringText(@Nonnull List<String> list, int mouseX, int mouseY, @Nonnull FontRenderer font) {
        if (this.ghostSlotTooltipStacksize >= 1000) {
            list.add(TextFormatting.WHITE + EnderIO.lang.localize("gui.inventorypanel.tooltip.itemsstored", new Object[]{Integer.toString(this.ghostSlotTooltipStacksize)}));
        }
        super.drawHoveringText(list, mouseX, mouseY, font);
    }

    @Nonnull
    public InventoryPanelContainer getContainer() {
        return (InventoryPanelContainer)this.field_147002_h;
    }

    @Nullable
    public InventoryDatabaseClient getDatabase() {
        return ((TileInventoryPanel)this.getTileEntity()).getDatabaseClient();
    }

    private IconEIO getSortOrderIcon() {
        SortOrder order = this.view.getSortOrder();
        boolean invert = this.view.isSortOrderInverted();
        switch (order) {
            case NAME: {
                return invert ? IconEIO.SORT_NAME_UP : IconEIO.SORT_NAME_DOWN;
            }
            case COUNT: {
                return invert ? IconEIO.SORT_SIZE_UP : IconEIO.SORT_SIZE_DOWN;
            }
            case MOD: {
                return invert ? IconEIO.SORT_MOD_UP : IconEIO.SORT_MOD_DOWN;
            }
        }
        return null;
    }

    void toggleSortOrder(boolean next) {
        SortOrder order = this.view.getSortOrder();
        SortOrder[] values = SortOrder.values();
        int idx = order.ordinal();
        if (next && this.view.isSortOrderInverted()) {
            order = values[(idx + 1) % values.length];
        } else if (!next && !this.view.isSortOrderInverted()) {
            if (idx == 0) {
                idx = values.length;
            }
            order = values[idx - 1];
        }
        this.view.setSortOrder(order, !this.view.isSortOrderInverted());
        this.updateSortButton();
    }

    private void updateSortButton() {
        SortOrder order = this.view.getSortOrder();
        ArrayList list = new ArrayList();
        SpecialTooltipHandler.addTooltipFromResources(list, (String)("enderio.gui.inventorypanel.tooltip.sort." + order.name().toLowerCase(Locale.US) + (this.view.isSortOrderInverted() ? "_up" : "_down") + ".line"));
        this.btnSort.setIcon((IWidgetIcon)this.getSortOrderIcon());
        this.btnSort.setToolTip(list.toArray(new String[list.size()]));
    }

    private void updateGhostSlots() {
        this.scrollPos = this.scrollbar.getScrollPos();
        int index = this.scrollPos * 6;
        int count = this.view.getNumEntries();
        int i = 0;
        while (i < 36) {
            InvSlot slot = (InvSlot)((Object)this.getGhostSlotHandler().getGhostSlots().get(i));
            slot.entry = index < count ? this.view.getItemEntry(index) : null;
            ++i;
            ++index;
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    public int getXSize() {
        return 230;
    }

    public int getYSize() {
        return 232;
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        StoredCraftingRecipe recipe;
        TileInventoryPanel te;
        super.func_73864_a(x, y, button);
        if (btnRefill.contains(x -= this.field_147003_i, y -= this.field_147009_r) && this.getContainer().hasCraftingRecipe()) {
            this.playClickSound();
            this.setCraftingHelper(CraftingHelper.createFromSlots(this.getContainer().getCraftingGridSlots()));
            this.craftingHelper.refill(this, GuiInventoryPanel.func_146272_n() ? 64 : 1);
        }
        if (this.btnAddStoredRecipe.contains(x, y) && (te = (TileInventoryPanel)this.getTileEntity()).getStoredCraftingRecipes() < 10 && this.getContainer().hasNewCraftingRecipe() && (recipe = new StoredCraftingRecipe()).loadFromCraftingGrid(this.getContainer().getCraftingGridSlots())) {
            this.playClickSound();
            te.addStoredCraftingRecipe(recipe);
        }
        if (btnReturnArea.contains(x, y)) {
            te = (TileInventoryPanel)this.getTileEntity();
            this.playClickSound();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetExtractionDisabled(this.getContainer().field_75152_c, !te.isExtractionDisabled()));
            te.setExtractionDisabled(!te.isExtractionDisabled());
        }
    }

    private void playClickSound() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected void mouseWheel(int x, int y, int delta) {
        super.mouseWheel(x, y, delta);
        if (this.draggingScrollbar == null) {
            boolean shift = GuiInventoryPanel.func_146272_n();
            if (inventoryArea.contains(x -= this.field_147003_i, y -= this.field_147009_r)) {
                GhostSlot hovered = this.getGhostSlotHandler().getGhostSlotAt((GuiContainerBase)this, x, y);
                if (!shift) {
                    this.scrollbar.scrollBy(-Integer.signum(delta));
                } else if (hovered instanceof InvSlot) {
                    ItemStack itemStack;
                    InvSlot invSlot = (InvSlot)hovered;
                    InventoryDatabaseClient db = this.getDatabase();
                    if (!invSlot.getStack().func_190926_b() && invSlot.entry != null && db != null && ((itemStack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_190926_b() || ItemUtil.areStackMergable((ItemStack)itemStack, (ItemStack)invSlot.getStack()))) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFetchItem(db.getGeneration(), invSlot.entry, -1, 1));
                    }
                }
            }
        }
    }

    protected void ghostSlotClicked(@Nonnull InvSlot invSlot, int x, int y, int button) {
        InventoryDatabaseClient db = this.getDatabase();
        if (invSlot.entry != null && !invSlot.getStack().func_190926_b() && db != null) {
            int targetSlot;
            int count = Math.min(invSlot.getStack().func_190916_E(), invSlot.getStack().func_77976_d());
            if (button == 0) {
                if (GuiInventoryPanel.func_146272_n()) {
                    InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
                    targetSlot = playerInv.func_70447_i();
                    if (targetSlot >= 0) {
                        targetSlot = this.getContainer().getSlotIndex((IInventory)playerInv, targetSlot);
                    }
                    if (targetSlot < 0) {
                        return;
                    }
                } else {
                    targetSlot = -1;
                }
            } else if (button == 1) {
                targetSlot = -1;
                count = GuiInventoryPanel.func_146271_m() ? 1 : (count + 1) / 2;
            } else {
                return;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFetchItem(db.getGeneration(), invSlot.entry, targetSlot, count));
        }
    }

    @Nonnull
    public FontRenderer getFontRenderer() {
        return this.rtfr;
    }

    @Override
    public List<Rectangle> getBlockingAreas() {
        List<Rectangle> rectangles = super.getBlockingAreas();
        rectangles.add(new Rectangle(this.field_147003_i - 42, (this.field_146295_m - 208) / 2, 42, 208));
        rectangles.add(new Rectangle(this.field_147003_i + 232, this.field_147009_r, 24, 68));
        return rectangles;
    }

    @Override
    public Rectangle getDocumentationButtonArea() {
        return new Rectangle(this.field_147003_i - 42, this.field_147009_r + 3, 25, 25);
    }

    @Override
    public Rectangle getDocumentationArea() {
        return super.getDocumentationArea();
    }

    public class ItemStackButton
    extends IconButton {
        private ItemStack stack;
        private boolean rightClick;
        private final IWidgetIcon backupIcon;

        public ItemStackButton(IGuiScreen gui, int id, int x, @Nullable int y, @Nullable IWidgetIcon icon, ItemStack itm) {
            super(gui, id, x, y, icon);
            this.rightClick = false;
            this.backupIcon = icon;
            this.stack = itm;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.hasItemStack()) {
                this.icon = null;
                GlStateManager.func_179145_e();
                RenderHelper.func_74520_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179091_B();
                GlStateManager.func_179126_j();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
                ((GuiInventoryPanel)GuiInventoryPanel.this).field_146296_j.field_77023_b = this.field_146127_k + 1;
                GuiInventoryPanel.this.field_146296_j.func_180450_b(this.stack, 3, 3);
                GuiInventoryPanel.this.field_146296_j.func_180453_a(GuiInventoryPanel.this.field_146289_q, this.stack, 3, 3, "");
                GlStateManager.func_179121_F();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                RenderHelper.func_74520_c();
            } else {
                this.icon = this.backupIcon;
            }
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        }

        private boolean hasItemStack() {
            return this.stack != null && !this.stack.func_190926_b();
        }

        private String itemStackName() {
            return this.hasItemStack() ? this.stack.func_82833_r() : "";
        }

        public boolean isRightClick() {
            return this.rightClick;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }

        public void clearStack() {
            this.stack = null;
        }

        public boolean mousePressedButton(@Nonnull Minecraft mc, int mouseX, int mouseY, int button) {
            if (button == 1 && super.checkMousePress(mc, mouseX, mouseY)) {
                this.rightClick = true;
                return true;
            }
            this.rightClick = false;
            return false;
        }
    }

    class InvSlot
    extends GhostSlot {
        ItemEntry entry;

        InvSlot(int x, int y) {
            this.setX(x);
            this.setY(y);
            this.setGrayOut(false);
            this.setStackSizeLimit(Integer.MAX_VALUE);
        }

        @Nonnull
        public ItemStack getStack() {
            return this.entry == null ? Prep.getEmpty() : this.entry.makeItemStack();
        }
    }
}

