/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.invpanel;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.invpanel.capability.CapabilityDatabaseHandler;
import crazypants.enderio.base.invpanel.capability.IDatabaseHandler;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IInventoryPanel;
import crazypants.enderio.base.machine.base.te.ICap;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.invpanel.client.ClientDatabaseManager;
import crazypants.enderio.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.invpanel.config.InvpanelConfig;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.network.PacketGuiSettingsUpdated;
import crazypants.enderio.invpanel.network.PacketStoredCraftingRecipe;
import crazypants.enderio.invpanel.network.PacketUpdateExtractionDisabled;
import crazypants.enderio.invpanel.util.StoredCraftingRecipe;
import crazypants.enderio.machines.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machines.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

@Storable
public class TileInventoryPanel
extends AbstractInventoryMachineEntity
implements IInventoryPanel,
ITankAccess.IExtendedTankAccess,
IHasNutrientTank {
    public static final int SLOT_CRAFTING_START = 0;
    public static final int SLOT_CRAFTING_RESULT = 9;
    public static final int SLOT_VIEW_FILTER = 10;
    public static final int SLOT_RETURN_START = 11;
    public static final int MAX_STORED_CRAFTING_RECIPES = 10;
    @Store
    protected final SmartTank fuelTank = new SmartTank(Fluids.NUTRIENT_DISTILLATION.getFluid(), (Boolean)InvpanelConfig.inventoryPanelFree.get() != false ? 0 : 2000);
    protected boolean tanksDirty;
    IDatabaseHandler dbServer = null;
    private InventoryDatabaseClient dbClient;
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    private boolean active;
    @Store
    private boolean extractionDisabled;
    public InventoryPanelContainer eventHandler;
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE})
    private boolean hasConnection = false;
    private IItemFilter itemFilter;
    @Store
    private int guiSortMode;
    @Store
    @Nonnull
    private String guiFilterString = "";
    @Store
    private boolean guiSync;
    @Store
    private float power;
    @Store
    private final ArrayList<StoredCraftingRecipe> storedCraftingRecipes;
    @Store
    private EnumDyeColor color;
    @Nonnull
    private static final IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileInventoryPanel() {
        super(new SlotDefinition(0, 8, 11, 25, 21, 20));
        this.fuelTank.setTileEntity((TileEntity)this);
        this.fuelTank.setCanDrain(false);
        this.storedCraftingRecipes = new ArrayList();
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facingIn -> this.getSmartTankFluidHandler().get(facingIn));
        this.addICap(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ICap.facedOnly(facingIn -> this.extractionDisabled ? ICap.DENY : ICap.NEXT));
    }

    public IInventoryDatabaseServer getDatabaseServer() {
        return this.dbServer != null ? this.dbServer.getDatabase() : null;
    }

    public InventoryDatabaseClient getDatabaseClient(int generation) {
        if (this.dbClient != null && this.dbClient.getGeneration() != generation) {
            ClientDatabaseManager.INSTANCE.destroyDatabase(this.dbClient.getGeneration());
            this.dbClient = null;
        }
        if (this.dbClient == null) {
            this.dbClient = ClientDatabaseManager.INSTANCE.getOrCreateDatabase(generation);
        }
        return this.dbClient;
    }

    @Nullable
    public InventoryDatabaseClient getDatabaseClient() {
        return this.hasConnection ? this.dbClient : null;
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, @Nonnull ItemStack stack) {
        if (slot == 10 && !stack.func_190926_b()) {
            return FilterRegistry.isItemFilter(stack) && FilterRegistry.isFilterSet(stack);
        }
        return false;
    }

    @Override
    protected boolean hasStuffToPush() {
        return !this.extractionDisabled && super.hasStuffToPush();
    }

    @Override
    protected boolean shouldProcessOutputQueue() {
        return !this.extractionDisabled && super.shouldProcessOutputQueue();
    }

    @Override
    protected boolean hasSpaceToPull() {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        if (mode == IoMode.PUSH) {
            return !this.extractionDisabled;
        }
        return false;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack contents) {
        super.setInventorySlotContents(slot, contents);
        if (slot < 9 && this.eventHandler != null) {
            this.eventHandler.func_75130_a(emptyInventory);
        }
        if (slot == 10) {
            this.updateItemFilter();
        }
    }

    private void updateItemFilter() {
        this.itemFilter = (IItemFilter)FilterRegistry.getFilterForUpgrade((ItemStack)NullHelper.first((Object[])new ItemStack[]{this.inventory[10], Prep.getEmpty()}));
    }

    public IItemFilter getItemFilter() {
        return this.itemFilter;
    }

    @Override
    public boolean isActive() {
        return (Boolean)InvpanelConfig.inventoryPanelFree.get() != false || this.active;
    }

    public boolean hasConnection() {
        return this.hasConnection;
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        if (this.shouldDoWorkThisTick(20)) {
            this.scanNetwork();
        }
        if (this.getDatabaseServer() != null) {
            this.getDatabaseServer().tick(this);
        }
        if (this.updateClients) {
            this.forceUpdatePlayers();
            this.func_70296_d();
            this.updateClients = false;
        }
        if (this.tanksDirty) {
            this.tanksDirty = false;
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
        }
    }

    private void scanNetwork() {
        EnumFacing facingDir = this.getFacing();
        EnumFacing backside = this.getIODirection();
        BlockPos p = this.field_174879_c.func_177972_a(backside);
        TileEntity te = this.field_145850_b.func_175625_s(p);
        IDatabaseHandler dbHandler = null;
        if (te != null && te.hasCapability(CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY, facingDir)) {
            dbHandler = (IDatabaseHandler)te.getCapability(CapabilityDatabaseHandler.DATABASE_HANDLER_CAPABILITY, facingDir);
        }
        if (dbHandler != null) {
            this.dbServer = dbHandler;
            this.getDatabaseServer().sendChangeLogs();
            this.refuelPower(this.dbServer.getDatabase());
            this.hasConnection = true;
            if (this.active != this.getDatabaseServer().isOperational(this)) {
                this.active = this.getDatabaseServer().isOperational(this);
                this.updateClients = true;
            }
        } else {
            if (this.active) {
                this.updateClients = true;
            }
            this.hasConnection = false;
            this.dbServer = null;
            this.dbClient = null;
            this.active = false;
        }
    }

    @Override
    public float getAvailablePower() {
        return (float)this.getFluidReserve() * ((Float)InvpanelConfig.inventoryPanelPowerPerMB.get()).floatValue();
    }

    @Override
    public void refuelPower(@Nonnull IInventoryDatabaseServer db) {
        float missingPower = ((Float)InvpanelConfig.inventoryPanelPowerPerMB.get()).floatValue() * 0.5f - this.getPowerLevel();
        if (missingPower > 0.0f) {
            int amount = (int)Math.ceil(missingPower / ((Float)InvpanelConfig.inventoryPanelPowerPerMB.get()).floatValue());
            if ((amount = Math.min(amount, this.getFluidReserve())) > 0) {
                this.useNutrient(amount);
                this.addPower((float)amount * ((Float)InvpanelConfig.inventoryPanelPowerPerMB.get()).floatValue());
            }
        }
    }

    @Override
    public float getPowerLevel() {
        return this.power;
    }

    @Override
    public boolean usePower(float amount) {
        if (this.power > 0.0f) {
            this.power = Math.max(this.power - amount, 0.0f);
            return true;
        }
        return false;
    }

    @Override
    public void addPower(float amount) {
        this.power += amount;
    }

    public void useNutrient(int amount) {
        this.fuelTank.removeFluidAmount(amount);
    }

    private int getFluidReserve() {
        return (Boolean)InvpanelConfig.inventoryPanelFree.get() != false ? 100 : this.fuelTank.getFluidAmount();
    }

    @Override
    protected void processTasks(boolean redstoneCheck) {
    }

    public int getGuiSortMode() {
        return this.guiSortMode;
    }

    @Nonnull
    public String getGuiFilterString() {
        return this.guiFilterString;
    }

    public boolean getGuiSync() {
        return this.guiSync;
    }

    public void setGuiParameter(int sortMode, @Nonnull String filterString, boolean sync) {
        this.guiSortMode = sortMode;
        this.guiFilterString = filterString;
        this.guiSync = sync;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketGuiSettingsUpdated(this), this.field_145850_b.field_73011_w.getDimension());
            this.func_70296_d();
        }
    }

    public int getStoredCraftingRecipes() {
        return this.storedCraftingRecipes.size();
    }

    @Nullable
    public StoredCraftingRecipe getStoredCraftingRecipe(int index) {
        if (index < 0 || index >= this.storedCraftingRecipes.size()) {
            return null;
        }
        return this.storedCraftingRecipes.get(index);
    }

    public void addStoredCraftingRecipe(@Nullable StoredCraftingRecipe recipe) {
        this.storedCraftingRecipes.add(recipe);
        if (NullHelper.untrust((Object)this.field_145850_b) == null || this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStoredCraftingRecipe(0, 0, recipe));
        } else {
            this.func_70296_d();
            this.updateBlock();
        }
    }

    public void removeStoredCraftingRecipe(int index) {
        if (index >= 0 && index < this.storedCraftingRecipes.size()) {
            this.storedCraftingRecipes.remove(index);
            if (NullHelper.untrust((Object)this.field_145850_b) == null || this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStoredCraftingRecipe(1, index, null));
            } else {
                this.func_70296_d();
                this.updateBlock();
            }
        }
    }

    public boolean isExtractionDisabled() {
        return this.extractionDisabled;
    }

    public void setExtractionDisabled(boolean extractionDisabled) {
        this.extractionDisabled = extractionDisabled;
        if (NullHelper.untrust((Object)this.field_145850_b) != null && !this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketUpdateExtractionDisabled(this, extractionDisabled), this.field_145850_b.field_73011_w.getDimension());
        }
    }

    public void updateExtractionDisabled(boolean extractionDisabledIn) {
        this.extractionDisabled = extractionDisabledIn;
    }

    @Override
    protected void onAfterNbtRead() {
        this.faceModes = null;
        if (this.eventHandler != null) {
            this.eventHandler.checkCraftingRecipes();
        }
        this.updateItemFilter();
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    @Nonnull
    public IoMode getIoMode(@Nullable EnumFacing face) {
        return face == this.getIODirection() ? IoMode.NONE : IoMode.DISABLED;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
    }

    @Override
    @Nonnull
    public IoMode toggleIoModeForFace(@Nullable EnumFacing faceHit) {
        return this.getIoMode(faceHit);
    }

    private EnumFacing getIODirection() {
        return this.getFacing().func_176734_d();
    }

    protected EnumDyeColor getColor() {
        return this.color;
    }

    protected void setColor(EnumDyeColor color) {
        this.color = color;
        this.func_70296_d();
        this.forceUpdatePlayers();
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && this.fuelTank.canFill(forFluidType.getFluid())) {
            return this.fuelTank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.fuelTank;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileInventoryPanel.this.fuelTank.getFluid();
            }

            public int getCapacity() {
                return TileInventoryPanel.this.fuelTank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.fuelTank});
        }
        return this.smartTankFluidHandler;
    }
}

