/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.gui.BlockSceneRenderer;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.LavaGenConfig;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.lava.TileLavaGenerator;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class LavaGeneratorRecipeCategory
extends BlankRecipeCategory<LavaGeneratorRecipeWrapper> {
    @Nonnull
    public static final String UID = "LavaGenerator";
    @Nonnull
    private final IDrawable background;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableLavaGeneratorRecipes.get()).booleanValue()) {
            return;
        }
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new LavaGeneratorRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_lava_generator.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipes(Collections.singletonList(new LavaGeneratorRecipeWrapper(MachinesPlugin.iGuiHelper)), UID);
    }

    public LavaGeneratorRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 70);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_lava_generator.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull LavaGeneratorRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        fluidStacks.init(0, true, 10, 22);
        group.init(1, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 30, 50, 40, 10, 0, 0);
        group.init(2, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 90, 50, 40, 10, 0, 0);
        fluidStacks.set(ingredients);
        group.set(ingredients);
        recipeWrapper.currentX = ((RecipeLayout)recipeLayout).getPosX();
        recipeWrapper.currentY = ((RecipeLayout)recipeLayout).getPosY();
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class LavaGeneratorRecipeWrapper
    extends BlankRecipeWrapper {
        @Nonnull
        private final BlockSceneRenderer bsr;
        private int currentX = 0;
        private int currentY = 0;

        public LavaGeneratorRecipeWrapper(@Nonnull IGuiHelper guiHelper) {
            IBlockState gen = MachineObject.block_lava_generator.getBlockNN().func_176223_P().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON));
            IBlockState chassis = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.BODY));
            IBlockState waterfull = Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15));
            IBlockState water = Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(13));
            IBlockState air = Blocks.field_150350_a.func_176223_P();
            this.bsr = new BlockSceneRenderer((NNList<Pair<BlockPos, IBlockState>>)new NNList((Object[])new Pair[]{Pair.of((Object)new BlockPos(1, 1, 1), (Object)chassis), Pair.of((Object)new BlockPos(1, 1, 1), (Object)gen), Pair.of((Object)new BlockPos(1, 0, 1), (Object)waterfull), Pair.of((Object)new BlockPos(1, 1, 0), (Object)air), Pair.of((Object)new BlockPos(0, 1, 1), (Object)water), Pair.of((Object)new BlockPos(1, 1, 2), (Object)water), Pair.of((Object)new BlockPos(2, 1, 1), (Object)water)}));
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputs(FluidStack.class, (List)new NNList((Object[])new FluidStack[]{new FluidStack(FluidRegistry.LAVA, 1000)}));
            ingredients.setOutputs(EnergyIngredient.class, (List)new NNList((Object[])new EnergyIngredient[]{new EnergyIngredient(Math.round(TileLavaGenerator.getNominalPowerGenPerTick(DefaultCapacitorData.BASIC_CAPACITOR)), true), new EnergyIngredient(Math.round(TileLavaGenerator.getNominalPowerGenPerTick(DefaultCapacitorData.ENDER_CAPACITOR)), true)}));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int x = 15 + this.currentX;
            int y = 0 + this.currentY;
            int w = 130;
            int h = 50;
            GlStateManager.func_179094_E();
            this.bsr.drawScreen(x, y, w, h);
            GlStateManager.func_179121_F();
            FontRenderer fr = minecraft.field_71466_p;
            String txt = "-";
            int sw = fr.func_78256_a(txt);
            fr.func_175063_a("-", (float)(80 - sw / 2), 50.0f, ColorUtil.getRGB((Color)Color.WHITE));
            int burnTime = ((Boolean)LavaGenConfig.useVanillaBurnTime.get() != false ? 20000 : TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151129_at))) / 1000 / CapacitorKey.LAVAGEN_POWER_FLUID_USE.get(DefaultCapacitorData.BASIC_CAPACITOR);
            txt = LangFluid.tMB(burnTime);
            fr.func_78276_b(txt, 0, 40, ColorUtil.getRGB((Color)Color.GRAY));
            int i = 0;
            for (String split : Lang.JEI_LAVAGEN_COOLING.get().split("\\s+")) {
                if (split == null) continue;
                sw = fr.func_78256_a(split);
                fr.func_78276_b(split, 160 - sw, 8 * i++, ColorUtil.getRGB((Color)Color.GRAY));
            }
            txt = Lang.JEI_LAVAGEN_HEAT.get();
            sw = fr.func_78256_a(txt);
            fr.func_78276_b(txt, 80 - sw / 2, 60, ColorUtil.getRGB((Color)Color.GRAY));
        }
    }
}

