/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner.creative;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.google.common.base.Predicate;
import crazypants.enderio.base.capability.Filters;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.machines.machine.spawner.SpawnerLogic;
import crazypants.enderio.machines.machine.spawner.SpawnerNotification;
import crazypants.enderio.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@Storable
public class TileCreativeSpawner
extends AbstractCapabilityMachineEntity
implements IPaintable.IPaintableTileEntity,
SpawnerLogic.ISpawnerCallback,
EntityAction.Implementer {
    @Nonnull
    private final SpawnerLogic logic = new SpawnerLogic(this);

    public TileCreativeSpawner() {
        this.getInventory().add(EnderInventory.Type.INPUT, (Enum)SLOT.VIAL, new InventorySlot(Filters.WITH_MOB_SOUL, 1));
        this.getInventory().add(EnderInventory.Type.INPUT, (Enum)SLOT.PATTERN, new InventorySlot());
        this.getInventory().add(EnderInventory.Type.INPUT, (Enum)SLOT.OFFERING, new InventorySlot((Predicate)new Filters.PredicateItemStack(){

            public boolean doApply(@Nonnull ItemStack input) {
                InventorySlot slot = TileCreativeSpawner.this.getInventory().getSlot((Enum)SLOT.PATTERN);
                return !slot.isEmpty() && ItemUtil.areStacksEqual((ItemStack)slot.get(), (ItemStack)input);
            }
        }, -1));
    }

    @Override
    protected void processTasks(boolean redstoneCheck) {
        if (!redstoneCheck || this.getInventory().getSlot((Enum)SLOT.VIAL).isEmpty()) {
            return;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return;
        }
        InventorySlot slot = this.getInventory().getSlot((Enum)SLOT.PATTERN);
        if (slot.isEmpty()) {
            if (!this.shouldDoWorkThisTick(1200)) {
                return;
            }
            if (((Boolean)SpawnerConfig.homeZoneEnabled.get()).booleanValue() && !this.logic.isAreaClear((Integer)SpawnerConfig.homeZoneSize.get(), (Integer)SpawnerConfig.homeZoneSize.get(), (Integer)SpawnerConfig.homeZoneLimit.get())) {
                return;
            }
        } else {
            InventorySlot slot2 = this.getInventory().getSlot((Enum)SLOT.OFFERING);
            if (slot2.get().func_190916_E() < slot.get().func_190916_E()) {
                return;
            }
            if (!this.logic.isAreaClear()) {
                return;
            }
            if (((Boolean)SpawnerConfig.homeZoneEnabled.get()).booleanValue() && !this.logic.isAreaClear((Integer)SpawnerConfig.homeZoneSize.get(), (Integer)SpawnerConfig.homeZoneSize.get(), (Integer)SpawnerConfig.homeZoneLimit.get())) {
                return;
            }
            slot2.get().func_190918_g(slot.get().func_190916_E());
            this.func_70296_d();
        }
        for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerSpawnCount.get(); ++i) {
            this.logic.trySpawnEntity();
        }
    }

    @Override
    @Nonnull
    public NNList<CapturedMob> getEntities() {
        CapturedMob capturedMob = this.getEntity();
        if (capturedMob != null) {
            return new NNList((Object[])new CapturedMob[]{capturedMob});
        }
        return NNList.emptyList();
    }

    @Override
    @Nonnull
    public EntityAction getEntityAction() {
        return EntityAction.SPAWN;
    }

    @Override
    @Nonnull
    public World getSpawnerWorld() {
        return this.field_145850_b;
    }

    @Override
    @Nonnull
    public BlockPos getSpawnerPos() {
        return this.field_174879_c;
    }

    @Override
    public int getRange() {
        return (Integer)SpawnerConfig.poweredSpawnerSpawnRange.get();
    }

    @Override
    public void setNotification(@Nonnull SpawnerNotification note) {
    }

    @Override
    public void removeNotification(@Nonnull SpawnerNotification note) {
    }

    @Override
    public boolean isActive() {
        return this.getInventory().getSlot((Enum)SLOT.PATTERN).isEmpty();
    }

    @Override
    @Nullable
    public CapturedMob getEntity() {
        return CapturedMob.create(this.getInventory().getSlot((Enum)SLOT.VIAL).get());
    }

    @Override
    public void setHome(@Nonnull EntityCreature entity) {
        if (((Boolean)SpawnerConfig.homeZoneEnabled.get()).booleanValue()) {
            entity.func_175449_a(this.field_174879_c, ((Integer)SpawnerConfig.homeZoneSize.get()).intValue());
        }
    }

    @Override
    public void resetCapturedMob() {
    }

    static enum SLOT {
        VIAL,
        PATTERN,
        OFFERING;

    }
}

